/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.form;

import javax.annotation.Nonnull;

public class AzureValidationInfo {
    private final Object value;
    private final Object input;
    private final String message;
    private final Type type;

    public static AzureValidationInfo pending(Object input) {
        return AzureValidationInfo.builder().type(Type.PENDING).message("Validating...").input(input).build();
    }

    public static AzureValidationInfo error(@Nonnull String message, Object input) {
        return AzureValidationInfo.builder().type(Type.ERROR).message(message).input(input).build();
    }

    public static AzureValidationInfo warning(@Nonnull String message, Object input) {
        return AzureValidationInfo.builder().type(Type.WARNING).message(message).input(input).build();
    }

    public static AzureValidationInfo success(Object input) {
        return AzureValidationInfo.builder().type(Type.SUCCESS).message("Validation passed!").input(input).build();
    }

    public static AzureValidationInfo ok(Object input) {
        return AzureValidationInfo.success(input);
    }

    public static AzureValidationInfo none(Object input) {
        return AzureValidationInfo.builder().type(Type.SUCCESS).message("No need to validate.").input(input).build();
    }

    public boolean isValid() {
        return this.getType() != Type.PENDING && this.getType() != Type.ERROR;
    }

    public String toString() {
        return String.format("[%s]%s", new Object[]{this.type, this.message});
    }

    private static Type $default$type() {
        return Type.ERROR;
    }

    AzureValidationInfo(Object value, Object input, String message, Type type) {
        this.value = value;
        this.input = input;
        this.message = message;
        this.type = type;
    }

    public static AzureValidationInfoBuilder builder() {
        return new AzureValidationInfoBuilder();
    }

    public Object getValue() {
        return this.value;
    }

    public Object getInput() {
        return this.input;
    }

    public String getMessage() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    public static class AzureValidationInfoBuilder {
        private Object value;
        private Object input;
        private String message;
        private Type type$value;
        private boolean type$set;

        AzureValidationInfoBuilder() {
        }

        public AzureValidationInfoBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public AzureValidationInfoBuilder input(Object input) {
            this.input = input;
            return this;
        }

        public AzureValidationInfoBuilder message(String message) {
            this.message = message;
            return this;
        }

        public AzureValidationInfoBuilder type(Type type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public AzureValidationInfo build() {
            Type type$value = this.type$value;
            if (!this.type$set) {
                type$value = AzureValidationInfo.$default$type();
            }
            return new AzureValidationInfo(this.value, this.input, this.message, type$value);
        }

        public String toString() {
            return "AzureValidationInfo.AzureValidationInfoBuilder(value=" + this.value + ", input=" + this.input + ", message=" + this.message + ", type$value=" + (Object)((Object)this.type$value) + ")";
        }
    }

    public static enum Type {
        PENDING,
        ERROR,
        WARNING,
        SUCCESS;

    }
}

