/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.SimpleTokenCache;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.identity.implementation.util.ScopeUtil;
import com.microsoft.azure.toolkit.lib.auth.TokenCredentialManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Mono;

public class TokenCredentialManagerWithCache
extends TokenCredentialManager {
    private final Map<String, TokenCredential> tokenCredentialCache = new ConcurrentHashMap<String, TokenCredential>();

    @Override
    public TokenCredential createTokenCredentialForTenant(String tenantId) {
        return this.tokenCredentialCache.computeIfAbsent(tenantId, key -> new CachedTokenCredential(super.createTokenCredentialForTenant(tenantId)));
    }

    static class CachedTokenCredential
    implements TokenCredential {
        private final Map<String, SimpleTokenCache> tokenCache = new ConcurrentHashMap<String, SimpleTokenCache>();
        private final TokenCredential tokenCredential;

        public CachedTokenCredential(TokenCredential tokenCredential) {
            this.tokenCredential = tokenCredential;
        }

        public Mono<AccessToken> getToken(TokenRequestContext request) {
            String resource = ScopeUtil.scopesToResource((List)request.getScopes());
            return this.tokenCache.computeIfAbsent(resource, ignore -> new SimpleTokenCache(() -> this.tokenCredential.getToken(request))).getToken();
        }
    }
}

