/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.management.AzureEnvironment;
import com.azure.identity.implementation.MsalToken;
import com.azure.identity.implementation.util.ScopeUtil;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.azure.toolkit.lib.auth.TokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.TokenCredentialManagerWithCache;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import java.net.MalformedURLException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

public class RefreshTokenTokenCredentialManager
extends TokenCredentialManagerWithCache {
    public static Mono<TokenCredentialManager> createTokenCredentialManager(@Nonnull AzureEnvironment env, String clientId, @Nonnull TokenCredential credential) {
        return RefreshTokenTokenCredentialManager.fromCredential(env, clientId, RefreshTokenTokenCredentialManager.getRootAccessToken(env, credential));
    }

    public static Mono<TokenCredentialManager> createTokenCredentialManager(@Nonnull AzureEnvironment env, @Nonnull String clientId, String refreshToken) {
        TokenCredentialManager tcm = new TokenCredentialManager();
        tcm.setEnvironment(env);
        tcm.credentialSupplier = tenant -> new RefreshTokenCredential(AzureEnvironmentUtils.getAuthority(env), clientId, (String)tenant, refreshToken);
        tcm.rootCredentialSupplier = () -> new RefreshTokenCredential(AzureEnvironmentUtils.getAuthority(env), clientId, "common", refreshToken);
        return Mono.just((Object)tcm);
    }

    private static String getRefreshTokenFromMsalToken(MsalToken accessToken) {
        String refreshTokenFromResult;
        IAuthenticationResult result = accessToken.getAuthenticationResult();
        if (result == null) {
            return null;
        }
        try {
            refreshTokenFromResult = (String)FieldUtils.readField((Object)result, (String)"refreshToken", (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new AzureToolkitAuthenticationException("cannot read refreshToken from IAuthenticationResult.");
        }
        return refreshTokenFromResult;
    }

    public static TokenCredentialManager createFromRefreshToken(@Nonnull AzureEnvironment env, MsalToken token, String authority, String clientId) {
        String refreshToken = RefreshTokenTokenCredentialManager.getRefreshTokenFromMsalToken(token);
        if (StringUtils.isBlank((CharSequence)refreshToken)) {
            throw new IllegalArgumentException("cannot get refresh token from msal token.");
        }
        TokenCredentialManagerWithCache tokenCredentialManager = new TokenCredentialManagerWithCache();
        tokenCredentialManager.setEnvironment(env);
        tokenCredentialManager.setEmail(RefreshTokenTokenCredentialManager.getEmailFromMsalToken(token));
        tokenCredentialManager.setCredentialSupplier(tenantId -> new RefreshTokenCredential(authority, clientId, (String)tenantId, refreshToken));
        tokenCredentialManager.setRootCredentialSupplier(() -> request -> Mono.just((Object)token));
        return tokenCredentialManager;
    }

    private static String getEmailFromMsalToken(MsalToken token) {
        IAuthenticationResult result = token.getAuthenticationResult();
        if (result != null && result.account() != null) {
            return result.account().username();
        }
        return null;
    }

    @NotNull
    private static Mono<TokenCredentialManager> fromCredential(@Nonnull AzureEnvironment env, @Nonnull String clientId, Mono<AccessToken> rootAccessToken) {
        return rootAccessToken.map(accessToken -> {
            if (accessToken instanceof MsalToken) {
                return RefreshTokenTokenCredentialManager.createFromRefreshToken(env, (MsalToken)accessToken, AzureEnvironmentUtils.getAuthority(env), clientId);
            }
            throw new AzureToolkitAuthenticationException(String.format("The credential(%s) is not a msal token.", accessToken.getClass().getSimpleName()));
        });
    }

    public static Mono<AccessToken> getRootAccessToken(@Nonnull AzureEnvironment env, @Nonnull TokenCredential credential) {
        TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(ScopeUtil.resourceToScopes((String)env.getManagementEndpoint()));
        return credential.getToken(tokenRequestContext);
    }

    static class RefreshTokenCredential
    implements TokenCredential {
        private final String authority;
        private final String clientId;
        private final String tenantId;
        private final String refreshToken;

        public Mono<AccessToken> getToken(TokenRequestContext context) {
            return Mono.just((Object)this.authenticate(ScopeUtil.scopesToResource((List)context.getScopes())));
        }

        private AccessToken authenticate(String resource) {
            AuthenticationResult result;
            String authorityUrl = this.authority + "/" + this.tenantId;
            ExecutorService service = Executors.newFixedThreadPool(1);
            try {
                AuthenticationContext context = new AuthenticationContext(authorityUrl, true, service);
                Future future = context.acquireTokenByRefreshToken(this.refreshToken, this.clientId, resource, null);
                result = (AuthenticationResult)future.get();
            }
            catch (InterruptedException | MalformedURLException | ExecutionException e) {
                throw new AzureToolkitAuthenticationException(String.format("Cannot acquire token from refresh token due to error: %s", e.getMessage()), e);
            }
            finally {
                service.shutdown();
            }
            if (result == null) {
                throw new AzureToolkitAuthenticationException("Authentication result from acquireTokenByRefreshToken is null.");
            }
            return this.fromAuthenticationResult(result);
        }

        private AccessToken fromAuthenticationResult(AuthenticationResult authenticationResult) {
            if (authenticationResult == null) {
                return null;
            }
            if (authenticationResult.getExpiresOnDate() == null) {
                throw new AzureToolkitAuthenticationException("there is no expiration information in AuthenticationResult.");
            }
            OffsetDateTime expiresOnDate = OffsetDateTime.ofInstant(authenticationResult.getExpiresOnDate().toInstant(), ZoneOffset.UTC);
            return new AccessToken(authenticationResult.getAccessToken(), expiresOnDate);
        }

        public RefreshTokenCredential(String authority, String clientId, String tenantId, String refreshToken) {
            this.authority = authority;
            this.clientId = clientId;
            this.tenantId = tenantId;
            this.refreshToken = refreshToken;
        }
    }
}

