/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.identity.implementation.util.ScopeUtil;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

class AzureTokenCredentialsAdapter
extends AzureTokenCredentials {
    private final TokenCredential tokenCredential;
    private final Map<String, AccessToken> accessTokenCache = new ConcurrentHashMap<String, AccessToken>();

    AzureTokenCredentialsAdapter(AzureEnvironment environment, String tenantId, TokenCredential tokenCredential) {
        super(environment, tenantId);
        this.tokenCredential = tokenCredential;
    }

    public String getToken(String endpoint) {
        if (!this.accessTokenCache.containsKey(endpoint) || this.accessTokenCache.get(endpoint).isExpired()) {
            this.accessTokenCache.put(endpoint, (AccessToken)this.tokenCredential.getToken(new TokenRequestContext().addScopes(ScopeUtil.resourceToScopes((String)endpoint))).block());
        }
        return this.accessTokenCache.get(endpoint).getToken();
    }

    public static AzureTokenCredentials from(com.azure.core.management.AzureEnvironment env, String tenantId, TokenCredential tokenCredential) {
        AzureEnvironment azureEnvironment = Arrays.stream(AzureEnvironment.knownEnvironments()).filter(e -> StringUtils.equalsIgnoreCase((CharSequence)env.getManagementEndpoint(), (CharSequence)e.managementEndpoint())).findFirst().orElse(AzureEnvironment.AZURE);
        return new AzureTokenCredentialsAdapter(azureEnvironment, tenantId, tokenCredential);
    }
}

