/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth;

import com.azure.core.credential.TokenCredential;
import com.azure.core.management.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAccount;
import com.microsoft.azure.toolkit.lib.auth.Account$AjcClosure1;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.auth.AzureTokenCredentialsAdapter;
import com.microsoft.azure.toolkit.lib.auth.IAccountActions;
import com.microsoft.azure.toolkit.lib.auth.TokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.model.AccountEntity;
import com.microsoft.azure.toolkit.lib.auth.model.AuthType;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.common.cache.CacheEvict;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.cache.Preloader;
import com.microsoft.azure.toolkit.lib.common.event.AzureEventBus;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import reactor.core.publisher.Mono;

public abstract class Account
implements IAccount {
    protected static final String TOOLKIT_TOKEN_CACHE_NAME = "azure-toolkit.cache";
    protected AccountEntity entity = new AccountEntity();
    protected boolean enablePersistence = false;
    protected TokenCredentialManager credentialManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public abstract AuthType getAuthType();

    protected abstract String getClientId();

    public AzureEnvironment getEnvironment() {
        return this.entity == null ? null : this.entity.getEnvironment();
    }

    public String portalUrl() {
        return AzureEnvironmentUtils.getPortalUrl(this.getEnvironment());
    }

    protected abstract Mono<Boolean> preLoginCheck();

    public TokenCredential getTokenCredentialForTenant(String tenantId) {
        this.requireAuthenticated();
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new IllegalArgumentException("Should provide non-empty tenant id for retrieving credential.");
        }
        return this.credentialManager.createTokenCredentialForTenant(tenantId);
    }

    public AzureTokenCredentials getTokenCredentialForTenantV1(String tenantId) {
        this.requireAuthenticated();
        return AzureTokenCredentialsAdapter.from(this.getEnvironment(), tenantId, this.getTokenCredentialForTenant(tenantId));
    }

    public TokenCredential getTokenCredential(String subscriptionId) {
        this.requireAuthenticated();
        Subscription subscription = this.getSelectedSubscriptionById(subscriptionId);
        return this.getTokenCredentialForTenant(subscription.getTenantId());
    }

    public AzureTokenCredentials getTokenCredentialV1(String subscriptionId) {
        this.requireAuthenticated();
        Subscription subscription = this.getSelectedSubscriptionById(subscriptionId);
        return this.getTokenCredentialForTenantV1(subscription.getTenantId());
    }

    @CacheEvict(value="<ALL>")
    public void logout() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        Account$AjcClosure1 account$AjcClosure1 = new Account$AjcClosure1(objectArray);
        CacheManager.aspectOf().aroundCacheEvict(account$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public List<Subscription> getSubscriptions() {
        this.requireAuthenticated();
        return this.entity.getSubscriptions();
    }

    public List<Subscription> getSelectedSubscriptions() {
        this.requireAuthenticated();
        return this.entity.getSubscriptions().stream().filter(Subscription::isSelected).collect(Collectors.toList());
    }

    public void selectSubscription(List<String> selectedSubscriptionIds) {
        this.requireAuthenticated();
        if (CollectionUtils.isEmpty(selectedSubscriptionIds)) {
            throw new AzureToolkitRuntimeException("No subscriptions are selected. You must select at least one subscription.", new Object[]{IAccountActions.SELECT_SUBS});
        }
        if (CollectionUtils.isEmpty(this.getSubscriptions())) {
            throw new AzureToolkitRuntimeException("There are no subscriptions to select.", new Object[]{IAccountActions.TRY_AZURE});
        }
        if (this.entity.getSubscriptions().stream().anyMatch(s -> Utils.containsIgnoreCase((List)selectedSubscriptionIds, (String)s.getId()))) {
            Account.selectSubscriptionInner(this.getSubscriptions(), selectedSubscriptionIds);
            AzureEventBus.emit((String)"account.subscription_changed.account", (Object)this);
            AzureTaskManager manager = AzureTaskManager.getInstance();
            if (Objects.nonNull(manager)) {
                manager.runOnPooledThread(Preloader::load);
            }
        } else {
            throw new AzureToolkitRuntimeException("the selected subscriptions are invalid", new Object[]{IAccountActions.SELECT_SUBS});
        }
    }

    private Mono<TokenCredentialManager> initializeTokenCredentialManager() {
        return this.createTokenCredentialManager().doOnSuccess(tokenCredentialManager -> {
            this.credentialManager = tokenCredentialManager;
        });
    }

    protected abstract Mono<TokenCredentialManager> createTokenCredentialManager();

    public Mono<Boolean> checkAvailable() {
        return this.preLoginCheck().doOnSuccess(avail -> this.entity.setAvailable((boolean)avail));
    }

    protected Mono<Account> login() {
        Mono<Boolean> mono = this.loginStep1();
        return mono.flatMap(ignore -> {
            if (this.entity.getSubscriptions() == null) {
                return this.credentialManager.listSubscriptions(this.entity.getTenantIds()).map(subscriptions -> {
                    this.entity.setTenantIds(subscriptions.stream().map(Subscription::getTenantId).distinct().collect(Collectors.toList()));
                    this.entity.setSubscriptions((List<Subscription>)subscriptions);
                    return true;
                });
            }
            return Mono.just((Object)true);
        }).map(ignore -> {
            this.finishLogin();
            return this;
        });
    }

    public Mono<Account> continueLogin() {
        ((AzureAccount)Azure.az(AzureAccount.class)).setAccount(this);
        return Mono.just((Object)this);
    }

    private void finishLogin() {
        Account.selectSubscriptionInner(this.getSubscriptions(), this.entity.getSelectedSubscriptionIds());
        if (this.getSelectedSubscriptions().isEmpty()) {
            this.getSubscriptions().forEach(subscription -> subscription.setSelected(true));
            this.entity.setSelectedSubscriptionIds(this.getSubscriptions().stream().map(Subscription::getId).collect(Collectors.toList()));
        }
    }

    public Mono<List<Subscription>> reloadSubscriptions() {
        List beforeRefreshSelectedSubsIds = this.getSelectedSubscriptions().stream().map(Subscription::getId).collect(Collectors.toList());
        return this.credentialManager.listTenants().flatMap(tenantIds -> this.credentialManager.listSubscriptions((List<String>)tenantIds).map(subscriptions -> {
            this.entity.setTenantIds(subscriptions.stream().map(Subscription::getTenantId).distinct().collect(Collectors.toList()));
            this.entity.setSubscriptions((List<Subscription>)subscriptions);
            this.selectSubscription(beforeRefreshSelectedSubsIds);
            return this.getSubscriptions();
        }));
    }

    private Mono<Boolean> loginStep1() {
        return this.checkAvailable().flatMap(ignore -> this.initializeTokenCredentialManager()).flatMap(this::loadTenantIdsIfAbsent).doOnSuccess(tenantIds -> {
            this.entity.setType(this.getAuthType());
            this.entity.setClientId(this.getClientId());
            if (this.entity.getTenantIds() == null) {
                this.entity.setTenantIds((List<String>)tenantIds);
            }
            if (StringUtils.isNotBlank((CharSequence)this.credentialManager.getEmail())) {
                this.entity.setEmail(this.credentialManager.getEmail());
            }
            this.entity.setEnvironment(this.credentialManager.getEnvironment());
        }).map(ignore -> {
            this.entity.setAvailable(true);
            return true;
        });
    }

    private Mono<List<String>> loadTenantIdsIfAbsent(TokenCredentialManager tokenCredentialManager) {
        if (CollectionUtils.isNotEmpty(this.entity.getTenantIds())) {
            return Mono.just(this.entity.getTenantIds());
        }
        return tokenCredentialManager.listTenants();
    }

    public String toString() {
        List<Subscription> selectedSubscriptions;
        ArrayList<String> details = new ArrayList<String>();
        if (!this.entity.isAvailable()) {
            return "<account not available>";
        }
        if (this.getAuthType() != null) {
            details.add(String.format("Auth type: %s", TextUtils.cyan((String)this.getAuthType().toString())));
        }
        if (this.entity.isAvailable() && CollectionUtils.isNotEmpty(this.getSubscriptions()) && (selectedSubscriptions = this.getSelectedSubscriptions()) != null && selectedSubscriptions.size() == 1) {
            details.add(String.format("Default subscription: %s(%s)", TextUtils.cyan((String)selectedSubscriptions.get(0).getName()), TextUtils.cyan((String)selectedSubscriptions.get(0).getId())));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getEntity().getEmail())) {
            details.add(String.format("Username: %s", TextUtils.cyan((String)this.getEntity().getEmail())));
        }
        return StringUtils.join((Object[])details.toArray(), (String)"\n");
    }

    private Subscription getSelectedSubscriptionById(String subscriptionId) {
        return this.getSelectedSubscriptions().stream().filter(s -> StringUtils.equalsIgnoreCase((CharSequence)subscriptionId, (CharSequence)s.getId())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot find subscription with id '%s'", subscriptionId)));
    }

    public Subscription getSubscription(String subscriptionId) {
        return this.getSubscriptions().stream().filter(s -> StringUtils.equalsIgnoreCase((CharSequence)subscriptionId, (CharSequence)s.getId())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot find subscription with id '%s'", subscriptionId)));
    }

    private static void selectSubscriptionInner(List<Subscription> subscriptions, List<String> subscriptionIds) {
        if (CollectionUtils.isNotEmpty(subscriptionIds) && CollectionUtils.isNotEmpty(subscriptions)) {
            subscriptions.forEach(s -> s.setSelected(Utils.containsIgnoreCase((List)subscriptionIds, (String)s.getId())));
        }
    }

    private void requireAuthenticated() {
        if (!this.entity.isAvailable()) {
            throw new AzureToolkitAuthenticationException("account is not available.");
        }
        if (this.credentialManager == null || this.entity.getTenantIds() == null || this.entity.getSubscriptions() == null) {
            throw new AzureToolkitAuthenticationException("you are not signed-in.");
        }
    }

    public AccountEntity getEntity() {
        return this.entity;
    }

    void setEnablePersistence(boolean enablePersistence) {
        this.enablePersistence = enablePersistence;
    }

    protected boolean isEnablePersistence() {
        return this.enablePersistence;
    }

    static {
        Account.ajc$preClinit();
    }

    static final /* synthetic */ void logout_aroundBody0(Account ajc$this, JoinPoint joinPoint) {
        if (ajc$this.entity != null) {
            ajc$this.entity = null;
            ((AzureAccount)Azure.az(AzureAccount.class)).logout();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Account.java", Account.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logout", "com.microsoft.azure.toolkit.lib.auth.Account", "", "", "", "void"), 96);
    }
}

