/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.function.handlers.artifact;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.blob.BlobContainerPublicAccessType;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DeployTarget;
import com.microsoft.azure.toolkit.lib.legacy.appservice.handlers.artifact.ArtifactHandlerBase;
import com.microsoft.azure.toolkit.lib.legacy.function.AzureStorageHelper;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.artifact.FunctionArtifactHelper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.time.Period;
import java.util.Date;
import javax.annotation.Nonnull;

public class MSDeployArtifactHandlerImpl
extends ArtifactHandlerBase {
    public static final String DEPLOYMENT_PACKAGE_CONTAINER = "java-functions-deployment-packages";
    public static final String CREATE_ZIP_START = "Step 1 of 4: Creating ZIP file...";
    public static final String CREATE_ZIP_DONE = "Successfully saved ZIP file at ";
    public static final String UPLOAD_PACKAGE_START = "Step 2 of 4: Uploading ZIP file to Azure Storage...";
    public static final String UPLOAD_PACKAGE_DONE = "Successfully uploaded ZIP file to ";
    public static final String DEPLOY_PACKAGE_START = "Step 3 of 4: Deploying Azure Function App with package...";
    public static final String DEPLOY_PACKAGE_DONE = "Successfully deployed Azure Function App.";
    public static final String DELETE_PACKAGE_START = "Step 4 of 4: Deleting deployment package from Azure Storage...";
    public static final String DELETE_PACKAGE_DONE = "Successfully deleted deployment package ";
    public static final String DELETE_PACKAGE_FAIL = "Failed to delete deployment package ";
    protected final String functionAppName;

    private MSDeployArtifactHandlerImpl(@Nonnull Builder builder) {
        super(builder);
        this.functionAppName = builder.functionAppName;
    }

    public void publish(DeployTarget target) throws AzureExecutionException {
        File zipPackage = this.createZipPackage();
        CloudStorageAccount storageAccount = FunctionArtifactHelper.getCloudStorageAccount(target);
        String blobName = this.getBlobName();
        String packageUri = this.uploadPackageToAzureStorage(zipPackage, storageAccount, blobName);
        this.deployWithPackageUri(target, packageUri, () -> this.deletePackageFromAzureStorage(storageAccount, blobName));
    }

    protected File createZipPackage() throws AzureExecutionException {
        Log.prompt((String)"");
        Log.prompt((String)CREATE_ZIP_START);
        File zipPackage = FunctionArtifactHelper.createFunctionArtifact(this.stagingDirectoryPath);
        Log.prompt((String)(CREATE_ZIP_DONE + this.stagingDirectoryPath.concat(".zip")));
        return zipPackage;
    }

    protected String getBlobName() {
        return this.functionAppName.concat(new SimpleDateFormat(".yyyyMMddHHmmssSSS").format(new Date())).concat(".zip");
    }

    protected String uploadPackageToAzureStorage(File zipPackage, CloudStorageAccount storageAccount, String blobName) throws AzureExecutionException {
        Log.prompt((String)UPLOAD_PACKAGE_START);
        CloudBlockBlob blob = AzureStorageHelper.uploadFileAsBlob(zipPackage, storageAccount, DEPLOYMENT_PACKAGE_CONTAINER, blobName, BlobContainerPublicAccessType.OFF);
        String packageUri = AzureStorageHelper.getSASToken((CloudBlob)blob, Period.ofDays(1));
        Log.prompt((String)(UPLOAD_PACKAGE_DONE + blob.getUri().toString()));
        return packageUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployWithPackageUri(DeployTarget target, String packageUri, Runnable onDeployFinish) {
        try {
            Log.prompt((String)DEPLOY_PACKAGE_START);
            target.msDeploy(packageUri, false);
            Log.prompt((String)DEPLOY_PACKAGE_DONE);
        }
        finally {
            onDeployFinish.run();
        }
    }

    protected void deletePackageFromAzureStorage(CloudStorageAccount storageAccount, String blobName) {
        try {
            Log.prompt((String)DELETE_PACKAGE_START);
            AzureStorageHelper.deleteBlob(storageAccount, DEPLOYMENT_PACKAGE_CONTAINER, blobName);
            Log.prompt((String)(DELETE_PACKAGE_DONE + blobName));
        }
        catch (Exception e) {
            Log.error((String)(DELETE_PACKAGE_FAIL + blobName));
        }
    }

    public static class Builder
    extends ArtifactHandlerBase.Builder<Builder> {
        private String functionAppName;

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MSDeployArtifactHandlerImpl build() {
            return new MSDeployArtifactHandlerImpl(this);
        }

        public Builder functionAppName(String value) {
            this.functionAppName = value;
            return this.self();
        }
    }
}

