/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.function.bindings;

import java.util.Locale;

public enum BindingEnum {
    BlobTrigger("blobTrigger", Direction.IN, true),
    BlobInput("blob", Direction.IN, true),
    BlobOutput("blob", Direction.OUT, true),
    CosmosDBInput("cosmosDB", Direction.IN),
    CosmosDBOutput("cosmosDB", Direction.OUT),
    CosmosDBTrigger("cosmosDBTrigger", Direction.IN),
    EventHubTrigger("eventHubTrigger", Direction.IN),
    EventHubOutput("eventHub", Direction.OUT),
    EventGridTrigger("eventGridTrigger", Direction.IN),
    EventGridOutput("eventGrid", Direction.OUT),
    HttpTrigger("httpTrigger", Direction.IN),
    HttpOutput("http", Direction.OUT),
    KafkaTrigger("kafkaTrigger", Direction.IN),
    KafkaOutput("kafka", Direction.OUT),
    QueueTrigger("queueTrigger", Direction.IN, true),
    QueueOutput("queue", Direction.OUT, true),
    SendGridOutput("sendGrid", Direction.OUT),
    ServiceBusQueueTrigger("serviceBusTrigger", Direction.IN),
    ServiceBusQueueOutput("serviceBus", Direction.OUT),
    ServiceBusTopicTrigger("serviceBusTrigger", Direction.IN),
    ServiceBusTopicOutput("serviceBus", Direction.OUT),
    TableInput("table", Direction.IN, true),
    TableOutput("table", Direction.OUT, true),
    TimerTrigger("timerTrigger", Direction.IN),
    TwilioSmsOutput("twilioSms", Direction.OUT),
    CustomBinding("customBinding", null),
    ExtendedCustomBinding(null, null);

    private String type;
    private Direction direction;
    private boolean isStorage;

    private BindingEnum(String type, Direction direction) {
        this.type = type;
        this.direction = direction;
    }

    private BindingEnum(String type, Direction direction, boolean isStorage) {
        this.type = type;
        this.direction = direction;
        this.isStorage = isStorage;
    }

    public String getType() {
        return this.type;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isStorage() {
        return this.isStorage;
    }

    static enum Direction {
        IN,
        OUT;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static Direction fromString(String direction) {
            for (Direction d : Direction.values()) {
                if (!d.toString().equalsIgnoreCase(direction)) continue;
                return d;
            }
            throw new RuntimeException("Invalid direction is provided");
        }
    }
}

