/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.appservice.handlers.artifact;

import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DeployTarget;
import com.microsoft.azure.toolkit.lib.legacy.appservice.handlers.artifact.ArtifactHandlerBase;
import java.io.File;
import org.zeroturnaround.zip.ZipUtil;

public class ZIPArtifactHandlerImpl
extends ArtifactHandlerBase {
    private static final int DEFAULT_MAX_RETRY_TIMES = 3;
    private static final String LOCAL_SETTINGS_FILE = "local.settings.json";

    protected ZIPArtifactHandlerImpl(Builder builder) {
        super(builder);
    }

    public void publish(DeployTarget target) throws AzureExecutionException {
        int retryCount;
        this.assureStagingDirectoryNotEmpty();
        File zipFile = this.getZipFile();
        Log.prompt((String)String.format("Trying to deploy artifact to %s...", target.getName()));
        for (retryCount = 0; retryCount < 3; ++retryCount) {
            try {
                target.zipDeploy(zipFile);
                Log.prompt((String)String.format("Successfully deployed the artifact to https://%s", target.getDefaultHostName()));
                return;
            }
            catch (Exception e) {
                Log.debug((String)String.format("Exception occurred when deploying the zip package: %s, retrying immediately (%d/%d)", e.getMessage(), retryCount, 3));
                continue;
            }
        }
        throw new AzureExecutionException(String.format("The zip deploy failed after %d times of retry.", retryCount));
    }

    protected File getZipFile() {
        File zipFile = new File(this.stagingDirectoryPath + ".zip");
        File stagingDirectory = new File(this.stagingDirectoryPath);
        ZipUtil.pack((File)stagingDirectory, (File)zipFile);
        ZipUtil.removeEntry((File)zipFile, (String)LOCAL_SETTINGS_FILE);
        return zipFile;
    }

    public static class Builder
    extends ArtifactHandlerBase.Builder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ZIPArtifactHandlerImpl build() {
            return new ZIPArtifactHandlerImpl(this);
        }
    }
}

