/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.appservice;

import com.microsoft.azure.management.appservice.AppSetting;
import com.microsoft.azure.management.appservice.PublishingProfile;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DeployTargetType;
import java.io.File;
import java.util.Map;
import javax.annotation.Nonnull;

public class DeployTarget<T extends WebAppBase> {
    protected DeployTargetType type;
    protected T app;

    public DeployTarget(@Nonnull T app, DeployTargetType type) {
        this.app = app;
        this.type = type;
    }

    public PublishingProfile getPublishingProfile() {
        return this.app.getPublishingProfile();
    }

    public String getName() {
        return this.app.name();
    }

    public String getType() {
        return this.type.toString();
    }

    public String getDefaultHostName() {
        return this.app.defaultHostName();
    }

    public Map<String, AppSetting> getAppSettings() {
        return this.app.getAppSettings();
    }

    public void zipDeploy(File file) {
        this.app.zipDeploy(file);
    }

    public void msDeploy(String packageUri, boolean deleteExistingDeploymentSlot) {
        this.app.deploy().withPackageUri(packageUri).withExistingDeploymentsDeleted(deleteExistingDeploymentSlot).execute();
    }

    public T getApp() {
        return this.app;
    }
}

