/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.appservice;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DockerImageType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class AppServiceUtils {
    private static final String SERVICE_PLAN_NOT_FOUND = "Failed to get App Service Plan.";
    private static final String UPDATE_APP_SERVICE_PLAN = "Updating App Service Plan...";
    private static final List<PricingTier> pricingTiers = new ArrayList<PricingTier>();

    public static AppServicePlan getAppServicePlan(String servicePlanName, Azure azureClient, String resourceGroup, String servicePlanResourceGroup) {
        if (StringUtils.isNotEmpty((CharSequence)servicePlanName)) {
            String servicePlanResGrp = AppServiceUtils.getAppServicePlanResourceGroup(resourceGroup, servicePlanResourceGroup);
            return (AppServicePlan)azureClient.appServices().appServicePlans().getByResourceGroup(servicePlanResGrp, servicePlanName);
        }
        return null;
    }

    public static String getAppServicePlanResourceGroup(String resourceGroup, String appServicePlanResGrp) {
        return StringUtils.isEmpty((CharSequence)appServicePlanResGrp) ? resourceGroup : appServicePlanResGrp;
    }

    public static String getAppServicePlanName(String servicePlanName) {
        return StringUtils.isEmpty((CharSequence)servicePlanName) ? AppServiceUtils.generateRandomServicePlanName() : servicePlanName;
    }

    private static String generateRandomServicePlanName() {
        return "ServicePlan" + UUID.randomUUID().toString().substring(0, 18);
    }

    public static PricingTier getPricingTierFromString(String pricingTierString) {
        for (PricingTier pricingTier : pricingTiers) {
            if (!pricingTier.toSkuDescription().size().equalsIgnoreCase(pricingTierString)) continue;
            return pricingTier;
        }
        return null;
    }

    public static String convertPricingTierToString(PricingTier pricingTier) {
        return pricingTier == null ? null : pricingTier.toSkuDescription().size();
    }

    public static List<PricingTier> getAvailablePricingTiers(OperatingSystem operatingSystem) {
        ArrayList<PricingTier> result = new ArrayList<PricingTier>(pricingTiers);
        if (operatingSystem == OperatingSystem.LINUX) {
            result.remove(PricingTier.PREMIUM_P1);
            result.remove(PricingTier.PREMIUM_P2);
            result.remove(PricingTier.PREMIUM_P3);
        }
        return result;
    }

    public static AppServicePlan getAppServicePlanByAppService(WebAppBase webApp) {
        return (AppServicePlan)((AppServiceManager)webApp.manager()).appServicePlans().getById(webApp.appServicePlanId());
    }

    public static AppServicePlan updateAppServicePlan(AppServicePlan appServicePlan, PricingTier pricingTier) throws AzureExecutionException {
        if (appServicePlan == null) {
            throw new AzureExecutionException(SERVICE_PLAN_NOT_FOUND);
        }
        if (pricingTier == null || pricingTier.equals((Object)appServicePlan.pricingTier())) {
            return appServicePlan;
        }
        Log.prompt((String)UPDATE_APP_SERVICE_PLAN);
        AppServicePlan.Update appServicePlanUpdate = (AppServicePlan.Update)appServicePlan.update();
        return (AppServicePlan)appServicePlanUpdate.withPricingTier(pricingTier).apply();
    }

    public static boolean isEqualAppServicePlan(AppServicePlan first, AppServicePlan second) {
        return first == null ? second == null : second != null && StringUtils.equals((CharSequence)first.id(), (CharSequence)second.id());
    }

    public static DockerImageType getDockerImageType(String imageName, boolean hasCredential, String registryUrl) {
        if (StringUtils.isEmpty((CharSequence)imageName)) {
            return DockerImageType.NONE;
        }
        boolean isCustomRegistry = StringUtils.isNotEmpty((CharSequence)registryUrl);
        if (isCustomRegistry) {
            return hasCredential ? DockerImageType.PRIVATE_REGISTRY : DockerImageType.UNKNOWN;
        }
        return hasCredential ? DockerImageType.PRIVATE_DOCKER_HUB : DockerImageType.PUBLIC_DOCKER_HUB;
    }

    public static RuntimeStack parseRuntimeStack(String linuxFxVersion) {
        if (StringUtils.isEmpty((CharSequence)linuxFxVersion)) {
            return null;
        }
        String[] segments = linuxFxVersion.split(Pattern.quote("|"));
        if (segments.length != 2) {
            return null;
        }
        return new RuntimeStack(segments[0], segments[1]);
    }

    public static boolean isDockerAppService(WebAppBase webapp) {
        String linuxFxVersion = webapp.linuxFxVersion();
        return StringUtils.containsIgnoreCase((CharSequence)linuxFxVersion, (CharSequence)"DOCKER|");
    }

    static {
        for (Field field : PricingTier.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                pricingTiers.add((PricingTier)field.get(null));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

