/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.utils;

import com.azure.resourcemanager.appservice.models.AppSetting;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.appservice.model.DeployType;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.io.File;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    public static Map<String, String> normalizeAppSettings(Map<String, AppSetting> input) {
        return input.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((AppSetting)entry.getValue()).value()));
    }

    public static String getSubscriptionId(String resourceId) {
        return ResourceId.fromString((String)resourceId).subscriptionId();
    }

    public static DeployType getDeployTypeByFileExtension(File file) {
        String fileExtensionName = FilenameUtils.getExtension((String)file.getName());
        switch (StringUtils.lowerCase((String)fileExtensionName)) {
            case "jar": {
                return DeployType.JAR;
            }
            case "war": {
                return DeployType.WAR;
            }
            case "ear": {
                return DeployType.EAR;
            }
            case "zip": {
                return DeployType.ZIP;
            }
        }
        throw new AzureToolkitRuntimeException("Unsupported file type, please set the deploy type.");
    }
}

