/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl.deploy;

import com.azure.resourcemanager.appservice.models.AppSetting;
import com.azure.resourcemanager.appservice.models.DeploymentSlotBase;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlot;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

class DeployUtils {
    private static final String INTERNAL_STORAGE_NOT_FOUND = "Application setting 'AzureWebJobsStorage' not found.";
    private static final String INTERNAL_STORAGE_KEY = "AzureWebJobsStorage";
    private static final String UNSUPPORTED_DEPLOYMENT_TARGET = "Unsupported deployment target, only function is supported";

    DeployUtils() {
    }

    static CloudStorageAccount getCloudStorageAccount(WebAppBase functionApp) {
        Map settingsMap = functionApp.getAppSettings();
        return Optional.ofNullable(settingsMap).map(map -> (AppSetting)map.get(INTERNAL_STORAGE_KEY)).map(AppSetting::value).filter(StringUtils::isNotEmpty).map(key -> {
            try {
                return CloudStorageAccount.parse((String)key);
            }
            catch (URISyntaxException | InvalidKeyException e) {
                throw new AzureToolkitRuntimeException("Cannot parse storage connection string due to error: " + e.getMessage(), (Throwable)e);
            }
        }).orElseThrow(() -> new AzureToolkitRuntimeException(INTERNAL_STORAGE_NOT_FOUND));
    }

    static void updateFunctionAppSetting(WebAppBase deployTarget, String key, String value) {
        if (deployTarget instanceof FunctionApp) {
            ((FunctionApp.Update)((FunctionApp)deployTarget).update()).withAppSetting(key, value).apply();
        } else if (deployTarget instanceof FunctionDeploymentSlot) {
            ((DeploymentSlotBase.Update)((FunctionDeploymentSlot)deployTarget).update()).withAppSetting(key, value).apply();
        } else {
            throw new AzureToolkitRuntimeException(UNSUPPORTED_DEPLOYMENT_TARGET);
        }
    }
}

