/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.DeployOptions;
import com.azure.resourcemanager.appservice.models.DeployType;
import com.azure.resourcemanager.appservice.models.WebApp;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServiceBaseEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServicePlanEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.WebAppDeploymentSlotEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.WebAppEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.service.AbstractAppServiceCreator;
import com.microsoft.azure.toolkit.lib.appservice.service.AbstractAppServiceUpdater;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebApp;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AbstractAppService;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.WebAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import io.jsonwebtoken.lang.Collections;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class WebApp
extends AbstractAppService<com.azure.resourcemanager.appservice.models.WebApp, WebAppEntity>
implements IWebApp {
    private static final ClientLogger LOGGER = new ClientLogger(WebApp.class);
    private static final String UNSUPPORTED_OPERATING_SYSTEM = "Unsupported operating system %s";
    private final AzureResourceManager azureClient;

    public WebApp(WebAppEntity entity, AzureResourceManager azureClient) {
        this.entity = entity;
        this.azureClient = azureClient;
    }

    @Override
    public IAppServicePlan plan() {
        return ((AzureAppService)Azure.az(AzureAppService.class)).appServicePlan(((com.azure.resourcemanager.appservice.models.WebApp)this.getRemoteResource()).appServicePlanId());
    }

    public WebAppCreator create() {
        return new WebAppCreator();
    }

    @Override
    @NotNull
    protected WebAppEntity getEntityFromRemoteResource(@NotNull com.azure.resourcemanager.appservice.models.WebApp remote) {
        return AppServiceUtils.fromWebApp((WebAppBase)remote);
    }

    @Override
    protected com.azure.resourcemanager.appservice.models.WebApp remote() {
        return StringUtils.isNotEmpty((CharSequence)((WebAppEntity)this.entity).getId()) ? (com.azure.resourcemanager.appservice.models.WebApp)this.azureClient.webApps().getById(((WebAppEntity)this.entity).getId()) : (com.azure.resourcemanager.appservice.models.WebApp)this.azureClient.webApps().getByResourceGroup(((WebAppEntity)this.entity).getResourceGroup(), ((WebAppEntity)this.entity).getName());
    }

    @Override
    public void delete() {
        this.azureClient.webApps().deleteById(((com.azure.resourcemanager.appservice.models.WebApp)this.getRemoteResource()).id());
    }

    @Override
    public void deploy(@Nonnull com.microsoft.azure.toolkit.lib.appservice.model.DeployType deployType, @Nonnull File targetFile, @Nullable String targetPath) {
        DeployOptions options = new DeployOptions().withPath(targetPath);
        LOGGER.info(String.format("Deploying (%s)[%s] %s ...", TextUtils.cyan((String)targetFile.toString()), TextUtils.cyan((String)deployType.toString()), StringUtils.isBlank((CharSequence)targetPath) ? "" : " to " + TextUtils.green((String)targetPath)));
        ((com.azure.resourcemanager.appservice.models.WebApp)this.getRemoteResource()).deploy(DeployType.fromString((String)deployType.getValue()), targetFile, options);
    }

    public WebAppUpdater update() {
        return new WebAppUpdater();
    }

    @Override
    public IWebAppDeploymentSlot deploymentSlot(String slotName) {
        AppServiceBaseEntity slotEntity = ((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)WebAppDeploymentSlotEntity.builder().name(slotName)).resourceGroup(((com.azure.resourcemanager.appservice.models.WebApp)this.getRemoteResource()).resourceGroupName())).webappName(((com.azure.resourcemanager.appservice.models.WebApp)this.getRemoteResource()).name())).build();
        return new WebAppDeploymentSlot((WebAppDeploymentSlotEntity)slotEntity, this.azureClient);
    }

    @Override
    public List<IWebAppDeploymentSlot> deploymentSlots() {
        return ((com.azure.resourcemanager.appservice.models.WebApp)this.getRemoteResource()).deploymentSlots().list().stream().map(slot -> new WebAppDeploymentSlot((WebAppDeploymentSlotEntity)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)WebAppDeploymentSlotEntity.builder().id(slot.id())).build(), this.azureClient)).collect(Collectors.toList());
    }

    @Override
    public void swap(String slotName) {
        ((com.azure.resourcemanager.appservice.models.WebApp)this.getRemoteResource()).swap(slotName);
    }

    public class WebAppUpdater
    extends AbstractAppServiceUpdater<WebApp> {
        public static final String CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS = "Can not update the operation system for existing app service";
        private boolean modified = false;

        public WebApp commit() {
            WebApp.Update update = (WebApp.Update)((com.azure.resourcemanager.appservice.models.WebApp)WebApp.this.getRemoteResource()).update();
            if (this.getAppServicePlan() != null && this.getAppServicePlan().isPresent()) {
                update = this.updateAppServicePlan(update, this.getAppServicePlan().get());
            }
            if (this.getRuntime() != null && this.getRuntime().isPresent()) {
                update = this.updateRuntime(update, this.getRuntime().get());
            }
            if (!Collections.isEmpty(this.getAppSettingsToAdd())) {
                this.modified = true;
                update.withAppSettings(this.getAppSettingsToAdd());
            }
            if (!Collections.isEmpty(this.getAppSettingsToRemove())) {
                this.modified = true;
                this.getAppSettingsToRemove().forEach(arg_0 -> ((WebApp.Update)update).withoutAppSetting(arg_0));
            }
            if (this.getDiagnosticConfig() != null && this.getDiagnosticConfig().isPresent()) {
                this.modified = true;
                AppServiceUtils.updateDiagnosticConfigurationForWebAppBase((WebAppBase.Update)update, this.getDiagnosticConfig().get());
            }
            if (this.modified) {
                WebApp.this.remote = (WebAppBase)update.apply();
            }
            WebApp.this.entity = AppServiceUtils.fromWebApp(WebApp.this.remote);
            return WebApp.this;
        }

        private WebApp.Update updateAppServicePlan(WebApp.Update update, AppServicePlanEntity newServicePlan) {
            String servicePlanId = ((com.azure.resourcemanager.appservice.models.WebApp)WebApp.this.getRemoteResource()).appServicePlanId();
            AppServicePlanEntity currentServicePlan = ((AzureAppService)Azure.az(AzureAppService.class)).appServicePlan(servicePlanId).entity();
            if (StringUtils.equalsIgnoreCase((CharSequence)currentServicePlan.getId(), (CharSequence)newServicePlan.getId()) || StringUtils.equalsIgnoreCase((CharSequence)currentServicePlan.getName(), (CharSequence)newServicePlan.getName()) && StringUtils.equalsIgnoreCase((CharSequence)currentServicePlan.getResourceGroup(), (CharSequence)newServicePlan.getResourceGroup())) {
                return update;
            }
            AppServicePlan newPlanServiceModel = AppServiceUtils.getAppServicePlan(newServicePlan, WebApp.this.azureClient);
            if (newPlanServiceModel == null) {
                throw new AzureToolkitRuntimeException("Target app service plan not exists");
            }
            this.modified = true;
            return update.withExistingAppServicePlan(newPlanServiceModel);
        }

        private WebApp.Update updateRuntime(WebApp.Update update, Runtime newRuntime) {
            Runtime current = WebApp.this.getRuntime();
            if (Objects.equals(current, newRuntime)) {
                return update;
            }
            if (newRuntime.getOperatingSystem() != null && current.getOperatingSystem() != newRuntime.getOperatingSystem()) {
                throw new AzureToolkitRuntimeException(CAN_NOT_UPDATE_EXISTING_APP_SERVICE_OS);
            }
            this.modified = true;
            OperatingSystem operatingSystem = (OperatingSystem)((Object)ObjectUtils.firstNonNull((Object[])new OperatingSystem[]{newRuntime.getOperatingSystem(), current.getOperatingSystem()}));
            switch (operatingSystem) {
                case LINUX: {
                    return update.withBuiltInImage(AppServiceUtils.toLinuxRuntimeStack(newRuntime));
                }
                case WINDOWS: {
                    return (WebApp.Update)update.withJavaVersion(AppServiceUtils.toWindowsJavaVersion(newRuntime)).withWebContainer(AppServiceUtils.toWindowsWebContainer(newRuntime));
                }
                case DOCKER: {
                    DockerConfiguration dockerConfiguration = this.getDockerConfiguration().get();
                    WebApp.UpdateStages.WithStartUpCommand withStartUpCommand = StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{dockerConfiguration.getUserName(), dockerConfiguration.getPassword()}) ? update.withPublicDockerHubImage(dockerConfiguration.getImage()) : (StringUtils.isEmpty((CharSequence)dockerConfiguration.getRegistryUrl()) ? update.withPrivateDockerHubImage(dockerConfiguration.getImage()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword()) : update.withPrivateRegistryImage(dockerConfiguration.getImage(), dockerConfiguration.getRegistryUrl()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword()));
                    return withStartUpCommand.withStartUpCommand(dockerConfiguration.getStartUpCommand());
                }
            }
            throw new AzureToolkitRuntimeException(String.format(WebApp.UNSUPPORTED_OPERATING_SYSTEM, new Object[]{newRuntime.getOperatingSystem()}));
        }
    }

    public class WebAppCreator
    extends AbstractAppServiceCreator<WebApp> {
        @Override
        public WebApp commit() {
            WebApp.DefinitionStages.WithCreate withCreate;
            WebApp.DefinitionStages.Blank blank = (WebApp.DefinitionStages.Blank)WebApp.this.azureClient.webApps().define(this.getName());
            Runtime runtime = this.getRuntime();
            AppServicePlan appServicePlan = AppServiceUtils.getAppServicePlan(this.getAppServicePlanEntity(), WebApp.this.azureClient);
            if (appServicePlan == null) {
                throw new AzureToolkitRuntimeException("Target app service plan not exists");
            }
            ResourceGroup resourceGroup = (ResourceGroup)WebApp.this.azureClient.resourceGroups().getByName(this.getResourceGroup());
            switch (runtime.getOperatingSystem()) {
                case LINUX: {
                    withCreate = this.createLinuxWebApp(blank, resourceGroup, appServicePlan, runtime);
                    break;
                }
                case WINDOWS: {
                    withCreate = this.createWindowsWebApp(blank, resourceGroup, appServicePlan, runtime);
                    break;
                }
                case DOCKER: {
                    DockerConfiguration dockerConfiguration = this.getDockerConfiguration().get();
                    withCreate = this.createDockerWebApp(blank, resourceGroup, appServicePlan, dockerConfiguration);
                    break;
                }
                default: {
                    throw new AzureToolkitRuntimeException(String.format(WebApp.UNSUPPORTED_OPERATING_SYSTEM, new Object[]{runtime.getOperatingSystem()}));
                }
            }
            if (this.getAppSettings() != null && this.getAppSettings().isPresent()) {
                withCreate.withAppSettings(this.getAppSettings().get());
            }
            if (this.getDiagnosticConfig() != null && this.getDiagnosticConfig().isPresent()) {
                AppServiceUtils.defineDiagnosticConfigurationForWebAppBase((WebAppBase.DefinitionStages.WithCreate)withCreate, this.getDiagnosticConfig().get());
            }
            WebApp.this.remote = (WebAppBase)withCreate.create();
            WebApp.this.entity = AppServiceUtils.fromWebApp(WebApp.this.remote);
            return WebApp.this;
        }

        WebApp.DefinitionStages.WithCreate createWindowsWebApp(WebApp.DefinitionStages.Blank blank, ResourceGroup resourceGroup, AppServicePlan appServicePlan, Runtime runtime) {
            return (WebApp.DefinitionStages.WithCreate)blank.withExistingWindowsPlan(appServicePlan).withExistingResourceGroup(resourceGroup).withJavaVersion(AppServiceUtils.toWindowsJavaVersion(runtime)).withWebContainer(AppServiceUtils.toWindowsWebContainer(runtime));
        }

        WebApp.DefinitionStages.WithCreate createLinuxWebApp(WebApp.DefinitionStages.Blank blank, ResourceGroup resourceGroup, AppServicePlan appServicePlan, Runtime runtime) {
            return blank.withExistingLinuxPlan(appServicePlan).withExistingResourceGroup(resourceGroup).withBuiltInImage(AppServiceUtils.toLinuxRuntimeStack(runtime));
        }

        WebApp.DefinitionStages.WithCreate createDockerWebApp(WebApp.DefinitionStages.Blank blank, ResourceGroup resourceGroup, AppServicePlan appServicePlan, DockerConfiguration dockerConfiguration) {
            WebApp.DefinitionStages.WithLinuxAppFramework withLinuxAppFramework = blank.withExistingLinuxPlan(appServicePlan).withExistingResourceGroup(resourceGroup);
            WebApp.DefinitionStages.WithStartUpCommand withStartUpCommand = StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{dockerConfiguration.getUserName(), dockerConfiguration.getPassword()}) ? withLinuxAppFramework.withPublicDockerHubImage(dockerConfiguration.getImage()) : (StringUtils.isEmpty((CharSequence)dockerConfiguration.getRegistryUrl()) ? withLinuxAppFramework.withPrivateDockerHubImage(dockerConfiguration.getImage()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword()) : withLinuxAppFramework.withPrivateRegistryImage(dockerConfiguration.getImage(), dockerConfiguration.getRegistryUrl()).withCredentials(dockerConfiguration.getUserName(), dockerConfiguration.getPassword()));
            return withStartUpCommand.withStartUpCommand(dockerConfiguration.getStartUpCommand());
        }
    }
}

