/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServiceBaseEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionDeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AbstractAppService;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.deploy.FTPFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.deploy.IFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.deploy.MSFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.deploy.RunFromBlobFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.deploy.RunFromZipFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.deploy.ZIPFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public abstract class FunctionAppBase<T extends WebAppBase, R extends AppServiceBaseEntity>
extends AbstractAppService<T, R>
implements IFunctionAppBase<R> {
    @Override
    public void deploy(File targetFile) {
        this.deploy(targetFile, this.getDefaultDeployType());
    }

    @Override
    public void deploy(File targetFile, FunctionDeployType functionDeployType) {
        this.getDeployHandlerByType(functionDeployType).deploy(targetFile, (WebAppBase)this.getRemoteResource());
    }

    protected FunctionDeployType getDefaultDeployType() {
        if (this.getRuntime().getOperatingSystem() == OperatingSystem.WINDOWS) {
            return FunctionDeployType.RUN_FROM_ZIP;
        }
        PricingTier pricingTier = ((AzureAppService)Azure.az(AzureAppService.class)).appServicePlan(this.getRemoteResource().appServicePlanId()).entity().getPricingTier();
        return StringUtils.equalsAnyIgnoreCase((CharSequence)pricingTier.getTier(), (CharSequence[])new CharSequence[]{"Dynamic", "ElasticPremium"}) ? FunctionDeployType.RUN_FROM_BLOB : FunctionDeployType.RUN_FROM_ZIP;
    }

    protected IFunctionDeployHandler getDeployHandlerByType(FunctionDeployType deployType) {
        switch (deployType) {
            case FTP: {
                return new FTPFunctionDeployHandler();
            }
            case ZIP: {
                return new ZIPFunctionDeployHandler();
            }
            case MSDEPLOY: {
                return new MSFunctionDeployHandler();
            }
            case RUN_FROM_ZIP: {
                return new RunFromZipFunctionDeployHandler();
            }
            case RUN_FROM_BLOB: {
                return new RunFromBlobFunctionDeployHandler();
            }
        }
        throw new AzureToolkitRuntimeException("Unsupported deployment type");
    }
}

