/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.azure.resourcemanager.appservice.models.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServicePlanEntity;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebApp;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class AppServicePlan
implements IAppServicePlan {
    private AppServicePlanEntity entity;
    private final AzureResourceManager azureClient;
    private com.azure.resourcemanager.appservice.models.AppServicePlan remote;

    public AppServicePlan(AppServicePlanEntity appServicePlanEntity, AzureResourceManager azureClient) {
        this.entity = appServicePlanEntity;
        this.azureClient = azureClient;
    }

    @Override
    public IAppServicePlan.Creator create() {
        return new AppServicePlanCreator();
    }

    public AppServicePlan refresh() {
        this.remote = this.remote();
        this.entity = Optional.ofNullable(this.remote).map(AppServiceUtils::fromAppServicePlan).orElseThrow(() -> new AzureToolkitRuntimeException("Target resource does not exist."));
        return this;
    }

    public String name() {
        return this.getRemoteResource().name();
    }

    public String id() {
        return this.getRemoteResource().id();
    }

    @Override
    public boolean exists() {
        try {
            return this.remote() != null;
        }
        catch (ManagementException e) {
            return false;
        }
    }

    @Override
    public AppServicePlanEntity entity() {
        if (this.remote == null) {
            this.refresh();
        }
        return this.entity;
    }

    @Override
    public List<IWebApp> webapps() {
        return ((AppServiceManager)this.getRemoteResource().manager()).webApps().list().stream().filter(webapp -> StringUtils.equals((CharSequence)webapp.appServicePlanId(), (CharSequence)this.getRemoteResource().id())).map(webapp -> new WebApp(AppServiceUtils.fromWebAppBasic(webapp), this.azureClient)).collect(Collectors.toList());
    }

    @Override
    public AppServicePlanUpdater update() {
        return new AppServicePlanUpdater();
    }

    private com.azure.resourcemanager.appservice.models.AppServicePlan remote() {
        return StringUtils.isNotEmpty((CharSequence)this.entity.getId()) ? (com.azure.resourcemanager.appservice.models.AppServicePlan)this.azureClient.appServicePlans().getById(this.entity.getId()) : (com.azure.resourcemanager.appservice.models.AppServicePlan)this.azureClient.appServicePlans().getByResourceGroup(this.entity.getResourceGroup(), this.entity.getName());
    }

    @Nonnull
    private com.azure.resourcemanager.appservice.models.AppServicePlan getRemoteResource() {
        if (this.remote == null) {
            this.refresh();
        }
        return Objects.requireNonNull(this.remote, "Target resource does not exist.");
    }

    public class AppServicePlanUpdater
    implements IAppServicePlan.Updater {
        private com.microsoft.azure.toolkit.lib.appservice.model.PricingTier pricingTier;

        @Override
        public AppServicePlanUpdater withPricingTier(com.microsoft.azure.toolkit.lib.appservice.model.PricingTier pricingTier) {
            this.pricingTier = pricingTier;
            return this;
        }

        @Override
        public AppServicePlan commit() {
            PricingTier newPricingTier;
            boolean modified = false;
            AppServicePlan.Update update = (AppServicePlan.Update)AppServicePlan.this.getRemoteResource().update();
            if (this.pricingTier != null && !Objects.equals(newPricingTier = AppServiceUtils.toPricingTier(this.pricingTier), AppServicePlan.this.getRemoteResource().pricingTier())) {
                modified = true;
                update = update.withPricingTier(newPricingTier);
            }
            if (modified) {
                AppServicePlan.this.remote = (com.azure.resourcemanager.appservice.models.AppServicePlan)update.apply();
            }
            AppServicePlan.this.entity = AppServiceUtils.fromAppServicePlan(AppServicePlan.this.remote);
            return AppServicePlan.this;
        }
    }

    public class AppServicePlanCreator
    implements IAppServicePlan.Creator {
        private String name;
        private Region region;
        private String resourceGroup;
        private com.microsoft.azure.toolkit.lib.appservice.model.PricingTier pricingTier;
        private com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem operatingSystem;

        @Override
        public IAppServicePlan.Creator withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public IAppServicePlan.Creator withRegion(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public IAppServicePlan.Creator withResourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
            return this;
        }

        @Override
        public IAppServicePlan.Creator withPricingTier(com.microsoft.azure.toolkit.lib.appservice.model.PricingTier pricingTier) {
            this.pricingTier = pricingTier;
            return this;
        }

        @Override
        public IAppServicePlan.Creator withOperatingSystem(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public IAppServicePlan commit() {
            AppServicePlan.this.remote = (com.azure.resourcemanager.appservice.models.AppServicePlan)((AppServicePlan.DefinitionStages.WithPricingTier)((AppServicePlan.DefinitionStages.WithGroup)((AppServicePlan.DefinitionStages.Blank)AppServicePlan.this.azureClient.appServicePlans().define(this.name)).withRegion(this.region.getName())).withExistingResourceGroup(this.resourceGroup)).withPricingTier(AppServiceUtils.toPricingTier(this.pricingTier)).withOperatingSystem(this.convertOS(this.operatingSystem)).create();
            AppServicePlan.this.entity = AppServiceUtils.fromAppServicePlan(AppServicePlan.this.remote);
            return AppServicePlan.this;
        }

        private OperatingSystem convertOS(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem operatingSystem) {
            return operatingSystem == com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.WINDOWS ? OperatingSystem.WINDOWS : OperatingSystem.LINUX;
        }
    }
}

