/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import org.apache.commons.lang3.StringUtils;

public class DockerConfiguration {
    private String image;
    private String registryUrl;
    private String userName;
    private String password;
    private String startUpCommand;

    public boolean isPublic() {
        return StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{this.userName, this.password});
    }

    protected DockerConfiguration(DockerConfigurationBuilder<?, ?> b) {
        this.image = ((DockerConfigurationBuilder)b).image;
        this.registryUrl = ((DockerConfigurationBuilder)b).registryUrl;
        this.userName = ((DockerConfigurationBuilder)b).userName;
        this.password = ((DockerConfigurationBuilder)b).password;
        this.startUpCommand = ((DockerConfigurationBuilder)b).startUpCommand;
    }

    public static DockerConfigurationBuilder<?, ?> builder() {
        return new DockerConfigurationBuilderImpl();
    }

    public String getImage() {
        return this.image;
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getStartUpCommand() {
        return this.startUpCommand;
    }

    private static final class DockerConfigurationBuilderImpl
    extends DockerConfigurationBuilder<DockerConfiguration, DockerConfigurationBuilderImpl> {
        private DockerConfigurationBuilderImpl() {
        }

        @Override
        protected DockerConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        public DockerConfiguration build() {
            return new DockerConfiguration(this);
        }
    }

    public static abstract class DockerConfigurationBuilder<C extends DockerConfiguration, B extends DockerConfigurationBuilder<C, B>> {
        private String image;
        private String registryUrl;
        private String userName;
        private String password;
        private String startUpCommand;

        protected abstract B self();

        public abstract C build();

        public B image(String image) {
            this.image = image;
            return this.self();
        }

        public B registryUrl(String registryUrl) {
            this.registryUrl = registryUrl;
            return this.self();
        }

        public B userName(String userName) {
            this.userName = userName;
            return this.self();
        }

        public B password(String password) {
            this.password = password;
            return this.self();
        }

        public B startUpCommand(String startUpCommand) {
            this.startUpCommand = startUpCommand;
            return this.self();
        }

        public String toString() {
            return "DockerConfiguration.DockerConfigurationBuilder(image=" + this.image + ", registryUrl=" + this.registryUrl + ", userName=" + this.userName + ", password=" + this.password + ", startUpCommand=" + this.startUpCommand + ")";
        }
    }
}

