/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.AzureService;
import com.microsoft.azure.toolkit.lib.SubscriptionScoped;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService$AjcClosure1;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServiceBaseEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServicePlanEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionAppEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.WebAppDeploymentSlotEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.WebAppEntity;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebApp;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.WebAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.entity.IAzureResourceEntity;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AzureAppService
extends SubscriptionScoped<AzureAppService>
implements AzureService {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public AzureAppService() {
        super(AzureAppService::new);
    }

    private AzureAppService(@Nonnull List<Subscription> subscriptions) {
        super(AzureAppService::new, subscriptions);
    }

    public IFunctionApp functionApp(String id) {
        AppServiceBaseEntity functionAppEntity = ((FunctionAppEntity.FunctionAppEntityBuilder)FunctionAppEntity.builder().id(id)).build();
        return this.functionApp((FunctionAppEntity)functionAppEntity);
    }

    public IFunctionApp functionApp(String resourceGroup, String name) {
        return this.functionApp(this.getDefaultSubscription().getId(), resourceGroup, name);
    }

    public IFunctionApp functionApp(String subscriptionId, String resourceGroup, String name) {
        AppServiceBaseEntity functionAppEntity = ((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)((FunctionAppEntity.FunctionAppEntityBuilder)FunctionAppEntity.builder().subscriptionId(subscriptionId)).resourceGroup(resourceGroup)).name(name)).build();
        return this.functionApp((FunctionAppEntity)functionAppEntity);
    }

    public IFunctionApp functionApp(FunctionAppEntity functionAppEntity) {
        String subscriptionId = this.getSubscriptionFromResourceEntity(functionAppEntity);
        return new FunctionApp(functionAppEntity, this.getAzureResourceManager(subscriptionId));
    }

    public List<IFunctionApp> functionApps() {
        return this.getSubscriptions().stream().map(subscription -> this.getAzureResourceManager(subscription.getId())).flatMap(azureResourceManager -> azureResourceManager.functionApps().list().stream()).filter(webAppBasic -> StringUtils.containsIgnoreCase((CharSequence)((SiteInner)webAppBasic.innerModel()).kind(), (CharSequence)"functionapp")).map(webAppBasic -> this.functionApp(webAppBasic.id())).collect(Collectors.toList());
    }

    public IWebApp webapp(String id) {
        AppServiceBaseEntity webAppEntity = ((WebAppEntity.WebAppEntityBuilder)WebAppEntity.builder().id(id)).build();
        return this.webapp((WebAppEntity)webAppEntity);
    }

    public IWebApp webapp(String resourceGroup, String name) {
        return this.webapp(this.getDefaultSubscription().getId(), resourceGroup, name);
    }

    public IWebApp webapp(String subscriptionId, String resourceGroup, String name) {
        AppServiceBaseEntity webAppEntity = ((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)((WebAppEntity.WebAppEntityBuilder)WebAppEntity.builder().subscriptionId(subscriptionId)).resourceGroup(resourceGroup)).name(name)).build();
        return this.webapp((WebAppEntity)webAppEntity);
    }

    public IWebApp webapp(WebAppEntity webAppEntity) {
        String subscriptionId = this.getSubscriptionFromResourceEntity(webAppEntity);
        return new WebApp(webAppEntity, this.getAzureResourceManager(subscriptionId));
    }

    public List<IWebApp> webapps() {
        return this.getSubscriptions().stream().map(subscription -> this.getAzureResourceManager(subscription.getId())).flatMap(azureResourceManager -> azureResourceManager.webApps().list().stream()).filter(webAppBasic -> !StringUtils.containsIgnoreCase((CharSequence)((SiteInner)webAppBasic.innerModel()).kind(), (CharSequence)"functionapp")).map(webAppBasic -> this.webapp(webAppBasic.id())).collect(Collectors.toList());
    }

    public IAppServicePlan appServicePlan(String id) {
        Object appServicePlanEntity = ((AppServicePlanEntity.AppServicePlanEntityBuilder)AppServicePlanEntity.builder().id(id)).build();
        return this.appServicePlan((AppServicePlanEntity)appServicePlanEntity);
    }

    public IAppServicePlan appServicePlan(String resourceGroup, String name) {
        return this.appServicePlan(this.getDefaultSubscription().getId(), resourceGroup, name);
    }

    public IAppServicePlan appServicePlan(String subscriptionId, String resourceGroup, String name) {
        Object appServicePlanEntity = ((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)AppServicePlanEntity.builder().subscriptionId(subscriptionId)).resourceGroup(resourceGroup)).name(name)).build();
        return this.appServicePlan((AppServicePlanEntity)appServicePlanEntity);
    }

    public IAppServicePlan appServicePlan(AppServicePlanEntity appServicePlanEntity) {
        String subscriptionId = this.getSubscriptionFromResourceEntity(appServicePlanEntity);
        return new AppServicePlan(appServicePlanEntity, this.getAzureResourceManager(subscriptionId));
    }

    public List<IAppServicePlan> appServicePlans() {
        return this.getSubscriptions().stream().map(subscription -> this.getAzureResourceManager(subscription.getId())).flatMap(azureResourceManager -> azureResourceManager.appServicePlans().list().stream()).map(appServicePlan -> this.appServicePlan(appServicePlan.id())).collect(Collectors.toList());
    }

    public IWebAppDeploymentSlot deploymentSlot(String id) {
        return this.deploymentSlot((WebAppDeploymentSlotEntity)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)WebAppDeploymentSlotEntity.builder().id(id)).build());
    }

    public IWebAppDeploymentSlot deploymentSlot(String resourceGroup, String appName, String slotName) {
        return this.deploymentSlot(this.getDefaultSubscription().getId(), resourceGroup, appName, slotName);
    }

    public IWebAppDeploymentSlot deploymentSlot(String subscriptionId, String resourceGroup, String appName, String slotName) {
        return this.deploymentSlot((WebAppDeploymentSlotEntity)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((AppServiceBaseEntity.AppServiceBaseEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)((WebAppDeploymentSlotEntity.WebAppDeploymentSlotEntityBuilder)WebAppDeploymentSlotEntity.builder().subscriptionId(subscriptionId)).resourceGroup(resourceGroup)).webappName(appName)).name(slotName)).build());
    }

    public IWebAppDeploymentSlot deploymentSlot(WebAppDeploymentSlotEntity deploymentSlot) {
        String subscriptionId = this.getSubscriptionFromResourceEntity(deploymentSlot);
        return new WebAppDeploymentSlot(deploymentSlot, this.getAzureResourceManager(subscriptionId));
    }

    @Cacheable(cacheName="AzureResourceManager", key="$subscriptionId")
    public AzureResourceManager getAzureResourceManager(String subscriptionId) {
        String string = subscriptionId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AzureAppService$AjcClosure1 azureAppService$AjcClosure1 = new AzureAppService$AjcClosure1(objectArray);
        return (AzureResourceManager)CacheManager.aspectOf().aroundCacheable(azureAppService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private HttpPipelinePolicy getUserAgentPolicy(String userAgent) {
        return (httpPipelineCallContext, httpPipelineNextPolicy) -> {
            String previousUserAgent = httpPipelineCallContext.getHttpRequest().getHeaders().getValue("User-Agent");
            httpPipelineCallContext.getHttpRequest().setHeader("User-Agent", String.format("%s %s", userAgent, previousUserAgent));
            return httpPipelineNextPolicy.process();
        };
    }

    private String getSubscriptionFromResourceEntity(@Nonnull IAzureResourceEntity resourceEntity) {
        if (StringUtils.isNotEmpty((CharSequence)resourceEntity.getId())) {
            return Utils.getSubscriptionId(resourceEntity.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)resourceEntity.getSubscriptionId())) {
            return resourceEntity.getSubscriptionId();
        }
        throw new AzureToolkitRuntimeException("Subscription id is required for this request.");
    }

    static {
        AzureAppService.ajc$preClinit();
    }

    static final /* synthetic */ AzureResourceManager getAzureResourceManager_aroundBody0(AzureAppService ajc$this, String subscriptionId, JoinPoint joinPoint) {
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        AzureConfiguration config = Azure.az().config();
        String userAgent = config.getUserAgent();
        HttpLogDetailLevel logLevel = Optional.ofNullable(config.getLogLevel()).map(HttpLogDetailLevel::valueOf).orElse(HttpLogDetailLevel.NONE);
        AzureProfile azureProfile = new AzureProfile(account.getEnvironment());
        return ((AzureResourceManager.Configurable)((AzureResourceManager.Configurable)AzureResourceManager.configure().withLogLevel(logLevel)).withPolicy(ajc$this.getUserAgentPolicy(userAgent))).authenticate(account.getTokenCredential(subscriptionId), azureProfile).withSubscription(subscriptionId);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AzureAppService.java", AzureAppService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAzureResourceManager", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "java.lang.String", "subscriptionId", "", "com.azure.resourcemanager.AzureResourceManager"), 157);
    }
}

