/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.function.handlers;

import com.microsoft.azure.toolkit.lib.common.utils.JsonUtils;
import com.microsoft.azure.toolkit.lib.legacy.function.bindings.Binding;
import com.microsoft.azure.toolkit.lib.legacy.function.bindings.BindingEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class McpAnnotationProcessor {
    private McpAnnotationProcessor() {
    }

    public static void processMcpAnnotations(List<Binding> bindings) {
        if (bindings == null || bindings.isEmpty()) {
            return;
        }
        ArrayList<Map<String, Object>> allProperties = new ArrayList<Map<String, Object>>();
        ArrayList<Binding> mcpTriggers = new ArrayList<Binding>();
        for (Binding binding : bindings) {
            BindingEnum bindingType = binding.getBindingEnum();
            if (bindingType == BindingEnum.McpToolProperty) {
                McpAnnotationProcessor.processPropertyBinding(binding, allProperties);
                continue;
            }
            if (bindingType != BindingEnum.McpToolTrigger) continue;
            McpAnnotationProcessor.patchMcpToolTrigger(binding);
            mcpTriggers.add(binding);
        }
        if (!allProperties.isEmpty() && !mcpTriggers.isEmpty()) {
            String toolPropertiesJson = JsonUtils.toJson(allProperties);
            for (Binding trigger : mcpTriggers) {
                trigger.setAttribute("toolProperties", toolPropertiesJson);
            }
        }
    }

    private static void patchMcpToolTrigger(Binding binding) {
        String name = (String)binding.getAttribute("name");
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            binding.setAttribute("toolName", name);
        }
    }

    private static void patchMcpToolProperty(Binding binding) {
        String name = (String)binding.getAttribute("name");
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            binding.setAttribute("propertyName", name);
        }
    }

    private static void processPropertyBinding(Binding binding, List<Map<String, Object>> allProperties) {
        McpAnnotationProcessor.patchMcpToolProperty(binding);
        Map<String, Object> propertyAttributes = McpAnnotationProcessor.createFilteredAttributesMap(binding);
        allProperties.add(propertyAttributes);
    }

    private static Map<String, Object> createFilteredAttributesMap(Binding binding) {
        HashMap<String, Object> propertyAttributes = new HashMap<String, Object>();
        Map<String, Object> bindingAttributes = binding.getBindingAttributes();
        for (Map.Entry<String, Object> entry : bindingAttributes.entrySet()) {
            if ("name".equals(entry.getKey())) continue;
            propertyAttributes.put(entry.getKey(), entry.getValue());
        }
        return propertyAttributes;
    }
}

