/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.function.bindings;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.microsoft.azure.toolkit.lib.legacy.function.bindings.BindingEnum;
import com.microsoft.azure.toolkit.lib.legacy.function.bindings.BindingSerializer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonSerialize(using=BindingSerializer.class)
public class Binding {
    protected BindingEnum bindingEnum = null;
    protected String type = null;
    protected BindingEnum.Direction direction = null;
    protected Map<String, Object> bindingAttributes = new HashMap<String, Object>();
    protected static Map<BindingEnum, List<String>> requiredAttributeMap = new HashMap<BindingEnum, List<String>>();

    public Binding(BindingEnum bindingEnum) {
        this.bindingEnum = bindingEnum;
        this.type = bindingEnum.getType();
        this.direction = bindingEnum.getDirection();
    }

    @Deprecated
    public Binding(BindingEnum bindingEnum, Annotation annotation) {
        this(bindingEnum);
        Class<? extends Annotation> annotationType = annotation.annotationType();
        try {
            for (Method propertyMethod : annotationType.getDeclaredMethods()) {
                Object value = propertyMethod.invoke((Object)annotation, new Object[0]);
                this.addProperties(value, propertyMethod);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Resolving binding attributes failed", e);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return (String)this.bindingAttributes.get("name");
    }

    public String getDirection() {
        if (this.direction != null) {
            return this.direction.toString();
        }
        throw new RuntimeException("Direction must be provided.");
    }

    public BindingEnum getBindingEnum() {
        return this.bindingEnum;
    }

    public Object getAttribute(String attributeName) {
        return this.bindingAttributes.get(attributeName);
    }

    public Map<String, Object> getBindingAttributes() {
        return this.bindingAttributes;
    }

    public void setName(String name) {
        this.bindingAttributes.put("name", name);
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        this.bindingAttributes.put(attributeName, attributeValue);
    }

    public String toString() {
        return "[ name: " + this.getName() + ", type: " + this.getType() + ", direction: " + this.getDirection() + " ]";
    }

    protected void addProperties(Object value, Method propertyMethod) {
        String propertyName = propertyMethod.getName();
        if (propertyName.equals("direction") && value instanceof String) {
            this.direction = BindingEnum.Direction.fromString((String)value);
            return;
        }
        if (propertyName.equals("type") && value instanceof String) {
            this.type = (String)value;
            return;
        }
        if (!value.equals(propertyMethod.getDefaultValue()) || requiredAttributeMap.get((Object)this.bindingEnum) != null && requiredAttributeMap.get((Object)this.bindingEnum).contains(propertyName)) {
            this.bindingAttributes.put(propertyName, value);
        }
    }

    static {
        requiredAttributeMap.put(BindingEnum.EventHubTrigger, Collections.singletonList("cardinality"));
        requiredAttributeMap.put(BindingEnum.HttpTrigger, Collections.singletonList("authLevel"));
        requiredAttributeMap.put(BindingEnum.McpToolProperty, Arrays.asList("isRequired", "description"));
        requiredAttributeMap.put(BindingEnum.McpToolTrigger, Collections.singletonList("description"));
    }
}

