/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.utils;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.resourcemanager.appservice.models.AppSetting;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.appservice.model.DeployType;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    private static final String CREATE_TEMP_FILE_FAIL = "Failed to create temp file %s.%s";

    public static Map<String, String> normalizeAppSettings(Map<String, AppSetting> input) {
        return input.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AppSetting)entry.getValue()).value()));
    }

    public static List<HttpPipelinePolicy> getPolicyFromPipeline(@Nonnull HttpPipeline httpPipeline, @Nullable Predicate<HttpPipelinePolicy> filter) {
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        int count = httpPipeline.getPolicyCount();
        for (int i = 0; i < count; ++i) {
            HttpPipelinePolicy policy = httpPipeline.getPolicy(i);
            if (filter != null && !filter.test(policy)) continue;
            policies.add(policy);
        }
        return policies;
    }

    public static String getSubscriptionId(String resourceId) {
        return ResourceId.fromString((String)resourceId).subscriptionId();
    }

    public static DeployType getDeployTypeByFileExtension(File file) {
        String fileExtensionName = FilenameUtils.getExtension((String)file.getName());
        switch (StringUtils.lowerCase((String)fileExtensionName)) {
            case "jar": {
                return DeployType.JAR;
            }
            case "war": {
                return DeployType.WAR;
            }
            case "ear": {
                return DeployType.EAR;
            }
            case "zip": {
                return DeployType.ZIP;
            }
        }
        throw new AzureToolkitRuntimeException("Unsupported file type, please set the deploy type.");
    }

    @Deprecated
    public static <T> T selectFirstOptionIfCurrentInvalid(String name, List<T> options, T value) {
        if (options.isEmpty()) {
            throw new AzureToolkitRuntimeException(String.format("No %s is available.", name));
        }
        return options.contains(value) ? value : options.get(0);
    }

    public static void throwForbidCreateResourceWarning(String resourceType, String name) {
        throw new AzureToolkitRuntimeException(String.format("%s(%s) cannot be found, if you want to create azure resources please remove command line arguments: `-Dazure.resource.create.skip=true` or `-DskipCreateAzureResource`.", resourceType, name));
    }

    public static String getDockerImageNameFromLinuxFxVersion(String linuxFxVersion) {
        String[] segments = linuxFxVersion.split(Pattern.quote("|"));
        if (segments.length != 2) {
            return null;
        }
        String image = segments[1];
        if (!image.contains("/")) {
            return image;
        }
        segments = image.split(Pattern.quote("/"));
        return segments[segments.length - 1].trim();
    }

    public static File createTempFile(String prefix, String suffix) throws AzureToolkitRuntimeException {
        try {
            File result = File.createTempFile(prefix, suffix);
            result.deleteOnExit();
            return result;
        }
        catch (IOException e) {
            throw new AzureToolkitRuntimeException(String.format(CREATE_TEMP_FILE_FAIL, prefix, suffix), e.getCause());
        }
    }
}

