/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.azure.resourcemanager.appservice.models.JavaVersion;
import com.azure.resourcemanager.appservice.models.WebAppMajorVersion;
import com.azure.resourcemanager.appservice.models.WebAppMinorVersion;
import com.azure.resourcemanager.appservice.models.WebAppRuntimeSettings;
import com.azure.resourcemanager.appservice.models.WebAppRuntimes;
import com.azure.resourcemanager.appservice.models.WebContainer;
import com.azure.resourcemanager.appservice.models.WindowsJavaContainerSettings;
import com.google.common.collect.Sets;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppRuntime;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class WebAppWindowsRuntime
implements WebAppRuntime {
    public static final WebAppWindowsRuntime JAVASE_JAVA21 = new WebAppWindowsRuntime("Java SE", "Java 21");
    public static final WebAppWindowsRuntime JAVASE_JAVA17 = new WebAppWindowsRuntime("Java SE", "Java 17");
    public static final WebAppWindowsRuntime JAVASE_JAVA11 = new WebAppWindowsRuntime("Java SE", "Java 11");
    public static final WebAppWindowsRuntime JAVASE_JAVA8 = new WebAppWindowsRuntime("Java SE", "Java 1.8");
    public static final WebAppWindowsRuntime TOMCAT101_JAVA21 = new WebAppWindowsRuntime("Tomcat 10.1", "Java 21");
    public static final WebAppWindowsRuntime TOMCAT101_JAVA17 = new WebAppWindowsRuntime("Tomcat 10.1", "Java 17");
    public static final WebAppWindowsRuntime TOMCAT101_JAVA11 = new WebAppWindowsRuntime("Tomcat 10.1", "Java 11");
    public static final WebAppWindowsRuntime TOMCAT101_JAVA8 = new WebAppWindowsRuntime("Tomcat 10.1", "Java 1.8");
    public static final WebAppWindowsRuntime TOMCAT10_JAVA21 = new WebAppWindowsRuntime("Tomcat 10.0", "Java 21");
    public static final WebAppWindowsRuntime TOMCAT10_JAVA17 = new WebAppWindowsRuntime("Tomcat 10.0", "Java 17");
    public static final WebAppWindowsRuntime TOMCAT10_JAVA11 = new WebAppWindowsRuntime("Tomcat 10.0", "Java 11");
    public static final WebAppWindowsRuntime TOMCAT10_JAVA8 = new WebAppWindowsRuntime("Tomcat 10.0", "Java 1.8");
    public static final WebAppWindowsRuntime TOMCAT9_JAVA21 = new WebAppWindowsRuntime("Tomcat 9.0", "Java 21");
    public static final WebAppWindowsRuntime TOMCAT9_JAVA17 = new WebAppWindowsRuntime("Tomcat 9.0", "Java 17");
    public static final WebAppWindowsRuntime TOMCAT9_JAVA11 = new WebAppWindowsRuntime("Tomcat 9.0", "Java 11");
    public static final WebAppWindowsRuntime TOMCAT9_JAVA8 = new WebAppWindowsRuntime("Tomcat 9.0", "Java 1.8");
    public static final WebAppWindowsRuntime TOMCAT85_JAVA21 = new WebAppWindowsRuntime("Tomcat 8.5", "Java 21");
    public static final WebAppWindowsRuntime TOMCAT85_JAVA17 = new WebAppWindowsRuntime("Tomcat 8.5", "Java 17");
    public static final WebAppWindowsRuntime TOMCAT85_JAVA11 = new WebAppWindowsRuntime("Tomcat 8.5", "Java 11");
    public static final WebAppWindowsRuntime TOMCAT85_JAVA8 = new WebAppWindowsRuntime("Tomcat 8.5", "Java 1.8");
    private static final AtomicReference<Boolean> loaded = new AtomicReference<Boolean>(Boolean.FALSE);
    private static final LinkedHashSet<WebAppWindowsRuntime> RUNTIMES = Sets.newLinkedHashSet(Arrays.asList(JAVASE_JAVA21, JAVASE_JAVA17, JAVASE_JAVA11, JAVASE_JAVA8, TOMCAT101_JAVA21, TOMCAT101_JAVA17, TOMCAT101_JAVA11, TOMCAT101_JAVA8, TOMCAT10_JAVA21, TOMCAT10_JAVA17, TOMCAT10_JAVA11, TOMCAT10_JAVA8, TOMCAT9_JAVA21, TOMCAT9_JAVA17, TOMCAT9_JAVA11, TOMCAT9_JAVA8, TOMCAT85_JAVA21, TOMCAT85_JAVA17, TOMCAT85_JAVA11, TOMCAT85_JAVA8));
    private final OperatingSystem operatingSystem = OperatingSystem.WINDOWS;
    private final String containerName;
    private final String containerVersionNumber;
    private final String javaVersionNumber;
    private final boolean deprecated;
    private final boolean hidden;
    private final boolean earlyAccess;
    private final boolean autoUpdate;
    private final boolean preview;
    @Nullable
    private final OffsetDateTime endOfLifeDate;

    private WebAppWindowsRuntime(@Nonnull WebAppMinorVersion webContainer, @Nonnull WebAppMinorVersion javaMinorVersion) {
        WindowsJavaContainerSettings containerSettings = webContainer.stackSettings().windowsContainerSettings();
        WebAppRuntimeSettings javaSettings = javaMinorVersion.stackSettings().windowsRuntimeSettings();
        this.deprecated = BooleanUtils.isTrue((Boolean)containerSettings.isDeprecated()) || BooleanUtils.isTrue((Boolean)javaSettings.isDeprecated());
        this.hidden = BooleanUtils.isTrue((Boolean)containerSettings.isHidden()) || BooleanUtils.isTrue((Boolean)javaSettings.isHidden());
        this.earlyAccess = BooleanUtils.isTrue((Boolean)containerSettings.isEarlyAccess()) || BooleanUtils.isTrue((Boolean)javaSettings.isEarlyAccess());
        this.autoUpdate = BooleanUtils.isTrue((Boolean)containerSettings.isAutoUpdate()) || BooleanUtils.isTrue((Boolean)javaSettings.isAutoUpdate());
        this.preview = BooleanUtils.isTrue((Boolean)containerSettings.isPreview()) || BooleanUtils.isTrue((Boolean)javaSettings.isPreview());
        OffsetDateTime javaEndOfLifeDate = javaSettings.endOfLifeDate();
        OffsetDateTime containerEndOfLifeDate = containerSettings.endOfLifeDate();
        this.endOfLifeDate = javaEndOfLifeDate == null ? containerEndOfLifeDate : (containerEndOfLifeDate == null ? javaEndOfLifeDate : (javaEndOfLifeDate.isAfter(containerEndOfLifeDate) ? containerEndOfLifeDate : javaEndOfLifeDate));
        this.containerName = containerSettings.javaContainer().toUpperCase();
        this.containerVersionNumber = StringUtils.equalsIgnoreCase((CharSequence)this.containerName, (CharSequence)"Java") ? "SE" : containerSettings.javaContainerVersion().toUpperCase();
        this.javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(javaSettings.runtimeVersion().toUpperCase());
    }

    private WebAppWindowsRuntime(@Nonnull WebAppMinorVersion javaMinorVersion) {
        WebAppRuntimeSettings javaSettings = javaMinorVersion.stackSettings().windowsRuntimeSettings();
        this.deprecated = BooleanUtils.isTrue((Boolean)javaSettings.isDeprecated());
        this.hidden = BooleanUtils.isTrue((Boolean)javaSettings.isHidden());
        this.earlyAccess = BooleanUtils.isTrue((Boolean)javaSettings.isEarlyAccess());
        this.autoUpdate = BooleanUtils.isTrue((Boolean)javaSettings.isAutoUpdate());
        this.preview = BooleanUtils.isTrue((Boolean)javaSettings.isPreview());
        this.endOfLifeDate = javaSettings.endOfLifeDate();
        this.containerName = "JAVA";
        this.containerVersionNumber = "SE";
        this.javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(javaSettings.runtimeVersion().toUpperCase());
    }

    private WebAppWindowsRuntime(Map<String, Object> webContainer, Map<String, Object> javaMinorVersion) {
        OffsetDateTime containerEndOfLifeDate;
        Map containerSettings = (Map)Utils.get(webContainer, (String)"$.stackSettings.windowsContainerSettings");
        Map javaSettings = (Map)Utils.get(javaMinorVersion, (String)"$.stackSettings.windowsRuntimeSettings");
        this.deprecated = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)containerSettings, (String)"$.isDeprecated"))) || BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)javaSettings, (String)"$.isDeprecated")));
        this.hidden = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)containerSettings, (String)"$.isHidden"))) || BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)javaSettings, (String)"$.isHidden")));
        this.earlyAccess = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)containerSettings, (String)"$.isEarlyAccess"))) || BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)javaSettings, (String)"$.isEarlyAccess")));
        this.autoUpdate = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)containerSettings, (String)"$.isAutoUpdate"))) || BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)javaSettings, (String)"$.isAutoUpdate")));
        this.preview = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)containerSettings, (String)"$.isPreview"))) || BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)javaSettings, (String)"$.isPreview")));
        CharSequence javaEndOfLifeDateStr = (CharSequence)Utils.get((Map)javaSettings, (String)"$.endOfLifeDate");
        CharSequence containerEndOfLifeDateStr = (CharSequence)Utils.get((Map)containerSettings, (String)"$.endOfLifeDate");
        OffsetDateTime javaEndOfLifeDate = StringUtils.isBlank((CharSequence)javaEndOfLifeDateStr) ? null : OffsetDateTime.parse(javaEndOfLifeDateStr, DateTimeFormatter.ISO_ZONED_DATE_TIME);
        OffsetDateTime offsetDateTime = containerEndOfLifeDate = StringUtils.isBlank((CharSequence)containerEndOfLifeDateStr) ? null : OffsetDateTime.parse(containerEndOfLifeDateStr, DateTimeFormatter.ISO_ZONED_DATE_TIME);
        this.endOfLifeDate = javaEndOfLifeDate == null ? containerEndOfLifeDate : (containerEndOfLifeDate == null ? javaEndOfLifeDate : (javaEndOfLifeDate.isAfter(containerEndOfLifeDate) ? containerEndOfLifeDate : javaEndOfLifeDate));
        this.containerName = ((String)Utils.get((Map)containerSettings, (String)"$.javaContainer")).toUpperCase();
        this.containerVersionNumber = StringUtils.equalsIgnoreCase((CharSequence)this.containerName, (CharSequence)"Java") ? "SE" : ((String)Utils.get((Map)containerSettings, (String)"$.javaContainerVersion")).toUpperCase();
        this.javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(((String)Utils.get((Map)javaSettings, (String)"$.runtimeVersion")).toUpperCase());
    }

    private WebAppWindowsRuntime(Map<String, Object> javaMinorVersion) {
        Map javaSettings = (Map)Utils.get(javaMinorVersion, (String)"$.stackSettings.windowsRuntimeSettings");
        this.deprecated = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)javaSettings, (String)"$.isDeprecated")));
        this.hidden = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)javaSettings, (String)"$.isHidden")));
        this.earlyAccess = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)javaSettings, (String)"$.isEarlyAccess")));
        this.autoUpdate = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)javaSettings, (String)"$.isAutoUpdate")));
        this.preview = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)javaSettings, (String)"$.isPreview")));
        CharSequence endOfLifeDateStr = (CharSequence)Utils.get((Map)javaSettings, (String)"$.endOfLifeDate");
        this.endOfLifeDate = StringUtils.isBlank((CharSequence)endOfLifeDateStr) ? null : OffsetDateTime.parse(endOfLifeDateStr, DateTimeFormatter.ISO_ZONED_DATE_TIME);
        this.containerName = "JAVA";
        this.containerVersionNumber = "SE";
        this.javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(((String)Utils.get((Map)javaSettings, (String)"$.runtimeVersion")).toUpperCase());
    }

    private WebAppWindowsRuntime(String containerUserText, String javaVersionUserText) {
        String[] containerParts = containerUserText.split(" ");
        String[] javaParts = javaVersionUserText.split(" ");
        this.deprecated = false;
        this.hidden = false;
        this.earlyAccess = false;
        this.autoUpdate = false;
        this.preview = false;
        this.endOfLifeDate = null;
        this.containerName = containerParts[0];
        this.containerVersionNumber = StringUtils.equalsIgnoreCase((CharSequence)this.containerName, (CharSequence)"Java") ? "SE" : containerParts[1].toUpperCase();
        this.javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(javaParts[1]);
    }

    @Override
    public WebContainer getWebContainer() {
        if ("SE".equalsIgnoreCase(this.getContainerVersionNumber())) {
            return WebContainer.fromString((String)String.format("java %d", this.getJavaMajorVersionNumber()));
        }
        return WebAppRuntime.super.getWebContainer();
    }

    @Nullable
    public static WebAppWindowsRuntime fromContainerAndJavaVersion(String containerName, String pContainerVersionNumber, JavaVersion javaVersion) {
        String containerVersionNumber = StringUtils.equalsIgnoreCase((CharSequence)containerName, (CharSequence)"java") ? "SE" : pContainerVersionNumber;
        return WebAppWindowsRuntime.getAllRuntimes().stream().filter(r -> StringUtils.equalsAnyIgnoreCase((CharSequence)javaVersion.toString(), (CharSequence[])new CharSequence[]{r.javaVersionNumber}) && StringUtils.equalsIgnoreCase((CharSequence)containerName, (CharSequence)r.containerName) && StringUtils.equalsIgnoreCase((CharSequence)containerVersionNumber, (CharSequence)r.containerVersionNumber)).findFirst().orElse(null);
    }

    @Nullable
    public static WebAppWindowsRuntime fromContainerAndJavaVersionUserText(String pContainerUserText, String pJavaVersionUserText) {
        if (StringUtils.isBlank((CharSequence)pJavaVersionUserText)) {
            pJavaVersionUserText = "Java 17";
            AzureMessager.getMessager().warning(AzureString.format((String)"The java version is not specified, use default version '%s'", (Object[])new Object[]{"Java 17"}));
        }
        String javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(pJavaVersionUserText);
        String containerUserText = StringUtils.startsWithIgnoreCase((CharSequence)pContainerUserText, (CharSequence)"java ") ? "Java SE" : pContainerUserText;
        return WebAppWindowsRuntime.getAllRuntimes().stream().filter(r -> StringUtils.equalsAnyIgnoreCase((CharSequence)javaVersionNumber, (CharSequence[])new CharSequence[]{r.javaVersionNumber}) && StringUtils.equalsIgnoreCase((CharSequence)containerUserText, (CharSequence)String.format("%s %s", r.containerName, r.containerVersionNumber))).findFirst().orElse(null);
    }

    public static List<WebAppWindowsRuntime> getAllRuntimes() {
        WebAppRuntime.tryLoadingAllRuntimes();
        return new ArrayList<WebAppWindowsRuntime>(RUNTIMES);
    }

    @Nonnull
    public static List<WebAppWindowsRuntime> getMajorRuntimes() {
        return WebAppWindowsRuntime.getAllRuntimes().stream().filter(r -> !r.isDeprecated() && !r.isHidden() && r.isMajorVersion()).collect(Collectors.toList());
    }

    public static boolean isLoaded() {
        return loaded.get() == Boolean.TRUE;
    }

    public static boolean isLoading() {
        return loaded.get() == null;
    }

    public static void loadAllWebAppWindowsRuntimes(List<WebAppMajorVersion> javaVersions, List<WebAppMajorVersion> containerVersions) {
        if (!loaded.compareAndSet(Boolean.FALSE, null)) {
            return;
        }
        RUNTIMES.clear();
        for (WebAppMajorVersion javaMajorVersion : javaVersions) {
            for (WebAppMinorVersion javaMinorVersion : javaMajorVersion.minorVersions()) {
                if (!Optional.ofNullable(javaMinorVersion).map(WebAppMinorVersion::stackSettings).map(WebAppRuntimes::windowsRuntimeSettings).map(WebAppRuntimeSettings::runtimeVersion).isPresent()) continue;
                for (WebAppMajorVersion containerMajorVersion : containerVersions) {
                    if (StringUtils.startsWithIgnoreCase((CharSequence)containerMajorVersion.value(), (CharSequence)"java")) {
                        RUNTIMES.add(new WebAppWindowsRuntime(javaMinorVersion));
                        continue;
                    }
                    for (WebAppMinorVersion containerMinorVersion : containerMajorVersion.minorVersions()) {
                        if (!Optional.ofNullable(containerMinorVersion).map(WebAppMinorVersion::stackSettings).map(WebAppRuntimes::windowsContainerSettings).map(WindowsJavaContainerSettings::javaContainer).isPresent()) continue;
                        RUNTIMES.add(new WebAppWindowsRuntime(containerMinorVersion, javaMinorVersion));
                    }
                }
            }
        }
        loaded.compareAndSet(null, Boolean.TRUE);
    }

    public static void loadAllWebAppWindowsRuntimesFromMap(List<Map<String, Object>> javaVersions, List<Map<String, Object>> containerVersions) {
        if (!loaded.compareAndSet(Boolean.FALSE, null)) {
            return;
        }
        RUNTIMES.clear();
        for (Map<String, Object> javaMajorVersion : javaVersions) {
            for (Map javaMinorVersion : (List)Utils.get(javaMajorVersion, (String)"$.minorVersions")) {
                if (!Objects.nonNull(Utils.get((Map)javaMinorVersion, (String)"$.stackSettings.windowsRuntimeSettings.runtimeVersion"))) continue;
                for (Map<String, Object> containerMajorVersion : containerVersions) {
                    if (StringUtils.startsWithIgnoreCase((CharSequence)((CharSequence)containerMajorVersion.get("value")), (CharSequence)"java")) {
                        RUNTIMES.add(new WebAppWindowsRuntime(javaMinorVersion));
                        continue;
                    }
                    for (Map containerMinorVersion : (List)Utils.get(containerMajorVersion, (String)"$.minorVersions")) {
                        if (!Objects.nonNull(Utils.get((Map)containerMinorVersion, (String)"$.stackSettings.windowsContainerSettings.javaContainer"))) continue;
                        RUNTIMES.add(new WebAppWindowsRuntime(containerMinorVersion, javaMinorVersion));
                    }
                }
            }
        }
        loaded.compareAndSet(null, Boolean.TRUE);
    }

    public String toString() {
        return String.format("Windows | %s | %s", this.getContainerUserText(), this.getJavaVersionUserText());
    }

    @Override
    @Generated
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    @Generated
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    @Generated
    public String getContainerVersionNumber() {
        return this.containerVersionNumber;
    }

    @Override
    @Generated
    public String getJavaVersionNumber() {
        return this.javaVersionNumber;
    }

    @Override
    @Generated
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    @Generated
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    @Generated
    public boolean isEarlyAccess() {
        return this.earlyAccess;
    }

    @Override
    @Generated
    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    @Override
    @Generated
    public boolean isPreview() {
        return this.preview;
    }

    @Override
    @Nullable
    @Generated
    public OffsetDateTime getEndOfLifeDate() {
        return this.endOfLifeDate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebAppWindowsRuntime)) {
            return false;
        }
        WebAppWindowsRuntime other = (WebAppWindowsRuntime)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OperatingSystem this$operatingSystem = this.getOperatingSystem();
        OperatingSystem other$operatingSystem = other.getOperatingSystem();
        if (this$operatingSystem == null ? other$operatingSystem != null : !((Object)((Object)this$operatingSystem)).equals((Object)other$operatingSystem)) {
            return false;
        }
        String this$containerName = this.getContainerName();
        String other$containerName = other.getContainerName();
        if (this$containerName == null ? other$containerName != null : !this$containerName.equals(other$containerName)) {
            return false;
        }
        String this$containerVersionNumber = this.getContainerVersionNumber();
        String other$containerVersionNumber = other.getContainerVersionNumber();
        if (this$containerVersionNumber == null ? other$containerVersionNumber != null : !this$containerVersionNumber.equals(other$containerVersionNumber)) {
            return false;
        }
        String this$javaVersionNumber = this.getJavaVersionNumber();
        String other$javaVersionNumber = other.getJavaVersionNumber();
        return !(this$javaVersionNumber == null ? other$javaVersionNumber != null : !this$javaVersionNumber.equals(other$javaVersionNumber));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WebAppWindowsRuntime;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OperatingSystem $operatingSystem = this.getOperatingSystem();
        result = result * 59 + ($operatingSystem == null ? 43 : ((Object)((Object)$operatingSystem)).hashCode());
        String $containerName = this.getContainerName();
        result = result * 59 + ($containerName == null ? 43 : $containerName.hashCode());
        String $containerVersionNumber = this.getContainerVersionNumber();
        result = result * 59 + ($containerVersionNumber == null ? 43 : $containerVersionNumber.hashCode());
        String $javaVersionNumber = this.getJavaVersionNumber();
        result = result * 59 + ($javaVersionNumber == null ? 43 : $javaVersionNumber.hashCode());
        return result;
    }
}

