/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class DeploymentBuildStatus {
    public static final DeploymentBuildStatus TIMED_OUT = new DeploymentBuildStatus("TimedOut");
    public static final DeploymentBuildStatus RUNTIME_FAILED = new DeploymentBuildStatus("RuntimeFailed");
    public static final DeploymentBuildStatus BUILD_ABORTED = new DeploymentBuildStatus("BuildAborted");
    public static final DeploymentBuildStatus BUILD_FAILED = new DeploymentBuildStatus("BuildFailed");
    public static final DeploymentBuildStatus BUILD_REQUEST_RECEIVED = new DeploymentBuildStatus("BuildRequestReceived");
    public static final DeploymentBuildStatus BUILD_PENDING = new DeploymentBuildStatus("BuildPending");
    public static final DeploymentBuildStatus BUILD_IN_PROGRESS = new DeploymentBuildStatus("BuildInProgress");
    public static final DeploymentBuildStatus BUILD_SUCCESSFUL = new DeploymentBuildStatus("BuildSuccessful");
    public static final DeploymentBuildStatus POST_BUILD_RESTART_REQUIRED = new DeploymentBuildStatus("PostBuildRestartRequired");
    public static final DeploymentBuildStatus START_POLLING = new DeploymentBuildStatus("StartPolling");
    public static final DeploymentBuildStatus START_POLLING_WITH_RESTART = new DeploymentBuildStatus("StartPollingWithRestart");
    public static final DeploymentBuildStatus RUNTIME_STARTING = new DeploymentBuildStatus("RuntimeStarting");
    public static final DeploymentBuildStatus RUNTIME_SUCCESSFUL = new DeploymentBuildStatus("RuntimeSuccessful");
    private static final Set<DeploymentBuildStatus> SUCCEED_STATUS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new DeploymentBuildStatus[]{RUNTIME_SUCCESSFUL}));
    private static final Set<DeploymentBuildStatus> TIMEOUT_STATUS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new DeploymentBuildStatus[]{TIMED_OUT}));
    private static final Set<DeploymentBuildStatus> FAILED_STATUS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new DeploymentBuildStatus[]{RUNTIME_FAILED, BUILD_ABORTED, BUILD_FAILED}));
    private static final Set<DeploymentBuildStatus> RUNNING_STATUS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new DeploymentBuildStatus[]{BUILD_REQUEST_RECEIVED, BUILD_PENDING, BUILD_IN_PROGRESS, BUILD_SUCCESSFUL, POST_BUILD_RESTART_REQUIRED, START_POLLING, START_POLLING_WITH_RESTART, RUNTIME_STARTING}));
    private static final Set<DeploymentBuildStatus> VALUES = Stream.of(SUCCEED_STATUS, FAILED_STATUS, TIMEOUT_STATUS, RUNNING_STATUS).flatMap(Collection::stream).collect(Collectors.toSet());
    private String value;

    public boolean isSucceed() {
        return SUCCEED_STATUS.contains(this);
    }

    public boolean isRunning() {
        return RUNNING_STATUS.contains(this);
    }

    public boolean isFailed() {
        return FAILED_STATUS.contains(this);
    }

    public boolean isTimeout() {
        return TIMEOUT_STATUS.contains(this);
    }

    public boolean isUnknownStatus() {
        return !VALUES.contains(this);
    }

    public static DeploymentBuildStatus fromString(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return VALUES.stream().filter(status -> StringUtils.equals((CharSequence)value, (CharSequence)status.getValue())).findFirst().orElseGet(() -> new DeploymentBuildStatus(value));
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    private DeploymentBuildStatus(String value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeploymentBuildStatus)) {
            return false;
        }
        DeploymentBuildStatus other = (DeploymentBuildStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeploymentBuildStatus;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

