/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.ResourceConfig;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;

public class ContainerAppFunctionConfiguration {
    protected Integer minReplicas;
    protected Integer maxReplicas;
    protected Double cpu;
    protected String memory;
    protected String workloadProfileMame;

    public static ContainerAppFunctionConfiguration fromFunctionApp(@Nonnull FunctionApp app) {
        String workloadProfile = Optional.ofNullable((SiteInner)app.innerModel()).map(SiteInner::workloadProfileName).orElse(null);
        ResourceConfig resourceConfig = Optional.ofNullable((SiteInner)app.innerModel()).map(SiteInner::resourceConfig).orElse(null);
        Double cpu = Optional.ofNullable(resourceConfig).map(ResourceConfig::cpu).orElse(null);
        String memory = Optional.ofNullable(resourceConfig).map(ResourceConfig::memory).orElse(null);
        return ContainerAppFunctionConfiguration.builder().minReplicas(app.minReplicas()).minReplicas(app.maxReplicas()).workloadProfileMame(workloadProfile).cpu(cpu).memory(memory).build();
    }

    @Generated
    public static ContainerAppFunctionConfigurationBuilder builder() {
        return new ContainerAppFunctionConfigurationBuilder();
    }

    @Generated
    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    @Generated
    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    @Generated
    public Double getCpu() {
        return this.cpu;
    }

    @Generated
    public String getMemory() {
        return this.memory;
    }

    @Generated
    public String getWorkloadProfileMame() {
        return this.workloadProfileMame;
    }

    @Generated
    public void setMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
    }

    @Generated
    public void setMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
    }

    @Generated
    public void setCpu(Double cpu) {
        this.cpu = cpu;
    }

    @Generated
    public void setMemory(String memory) {
        this.memory = memory;
    }

    @Generated
    public void setWorkloadProfileMame(String workloadProfileMame) {
        this.workloadProfileMame = workloadProfileMame;
    }

    @Generated
    public ContainerAppFunctionConfiguration() {
    }

    @Generated
    public ContainerAppFunctionConfiguration(Integer minReplicas, Integer maxReplicas, Double cpu, String memory, String workloadProfileMame) {
        this.minReplicas = minReplicas;
        this.maxReplicas = maxReplicas;
        this.cpu = cpu;
        this.memory = memory;
        this.workloadProfileMame = workloadProfileMame;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerAppFunctionConfiguration)) {
            return false;
        }
        ContainerAppFunctionConfiguration other = (ContainerAppFunctionConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$minReplicas = this.getMinReplicas();
        Integer other$minReplicas = other.getMinReplicas();
        if (this$minReplicas == null ? other$minReplicas != null : !((Object)this$minReplicas).equals(other$minReplicas)) {
            return false;
        }
        Integer this$maxReplicas = this.getMaxReplicas();
        Integer other$maxReplicas = other.getMaxReplicas();
        if (this$maxReplicas == null ? other$maxReplicas != null : !((Object)this$maxReplicas).equals(other$maxReplicas)) {
            return false;
        }
        Double this$cpu = this.getCpu();
        Double other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !((Object)this$cpu).equals(other$cpu)) {
            return false;
        }
        String this$memory = this.getMemory();
        String other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !this$memory.equals(other$memory)) {
            return false;
        }
        String this$workloadProfileMame = this.getWorkloadProfileMame();
        String other$workloadProfileMame = other.getWorkloadProfileMame();
        return !(this$workloadProfileMame == null ? other$workloadProfileMame != null : !this$workloadProfileMame.equals(other$workloadProfileMame));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContainerAppFunctionConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minReplicas = this.getMinReplicas();
        result = result * 59 + ($minReplicas == null ? 43 : ((Object)$minReplicas).hashCode());
        Integer $maxReplicas = this.getMaxReplicas();
        result = result * 59 + ($maxReplicas == null ? 43 : ((Object)$maxReplicas).hashCode());
        Double $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : ((Object)$cpu).hashCode());
        String $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : $memory.hashCode());
        String $workloadProfileMame = this.getWorkloadProfileMame();
        result = result * 59 + ($workloadProfileMame == null ? 43 : $workloadProfileMame.hashCode());
        return result;
    }

    @Generated
    public static class ContainerAppFunctionConfigurationBuilder {
        @Generated
        private Integer minReplicas;
        @Generated
        private Integer maxReplicas;
        @Generated
        private Double cpu;
        @Generated
        private String memory;
        @Generated
        private String workloadProfileMame;

        @Generated
        ContainerAppFunctionConfigurationBuilder() {
        }

        @Generated
        public ContainerAppFunctionConfigurationBuilder minReplicas(Integer minReplicas) {
            this.minReplicas = minReplicas;
            return this;
        }

        @Generated
        public ContainerAppFunctionConfigurationBuilder maxReplicas(Integer maxReplicas) {
            this.maxReplicas = maxReplicas;
            return this;
        }

        @Generated
        public ContainerAppFunctionConfigurationBuilder cpu(Double cpu) {
            this.cpu = cpu;
            return this;
        }

        @Generated
        public ContainerAppFunctionConfigurationBuilder memory(String memory) {
            this.memory = memory;
            return this;
        }

        @Generated
        public ContainerAppFunctionConfigurationBuilder workloadProfileMame(String workloadProfileMame) {
            this.workloadProfileMame = workloadProfileMame;
            return this;
        }

        @Generated
        public ContainerAppFunctionConfiguration build() {
            return new ContainerAppFunctionConfiguration(this.minReplicas, this.maxReplicas, this.cpu, this.memory, this.workloadProfileMame);
        }

        @Generated
        public String toString() {
            return "ContainerAppFunctionConfiguration.ContainerAppFunctionConfigurationBuilder(minReplicas=" + this.minReplicas + ", maxReplicas=" + this.maxReplicas + ", cpu=" + this.cpu + ", memory=" + this.memory + ", workloadProfileMame=" + this.workloadProfileMame + ")";
        }
    }
}

