/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function.core;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.ClassUtils;
import com.microsoft.azure.toolkit.lib.appservice.function.core.ExtendedCustomBinding;
import com.microsoft.azure.toolkit.lib.appservice.function.core.FunctionAnnotation;
import com.microsoft.azure.toolkit.lib.appservice.function.core.FunctionMethod;
import com.microsoft.azure.toolkit.lib.appservice.function.core.FunctionProject;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.utils.JsonUtils;
import com.microsoft.azure.toolkit.lib.legacy.function.bindings.Binding;
import com.microsoft.azure.toolkit.lib.legacy.function.bindings.BindingEnum;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.FunctionConfiguration;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.Retry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AzureFunctionPackagerBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AzureFunctionPackagerBase.class);
    private static final List<String> CUSTOM_BINDING_RESERVED_PROPERTIES = Arrays.asList("type", "name", "direction");
    private static final String MULTI_RETRY_ANNOTATION = "Fixed delay retry and exponential backoff retry are not compatible, please use either of them for one trigger";
    private static final Map<BindingEnum, List<String>> REQUIRED_ATTRIBUTE_MAP = new HashMap<BindingEnum, List<String>>();

    AzureFunctionPackagerBase() {
    }

    public FunctionConfiguration generateConfiguration(FunctionProject project, FunctionMethod method) {
        FunctionConfiguration config = new FunctionConfiguration();
        List<Binding> bindings = config.getBindings();
        this.processParameterAnnotations(method, bindings);
        this.processMethodAnnotations(method, bindings);
        this.patchStorageBinding(method, bindings);
        config.setRetry(this.getRetryConfigurationFromMethod(method));
        config.setEntryPoint(method.toString());
        config.setScriptFile("../" + project.getArtifactFile().getName());
        return config;
    }

    protected Map<String, FunctionConfiguration> generateConfigurationsInner(FunctionProject project, List<FunctionMethod> methods) {
        HashMap<String, FunctionConfiguration> configMap = new HashMap<String, FunctionConfiguration>();
        for (FunctionMethod method : methods) {
            FunctionAnnotation functionAnnotation = method.getAnnotation("com.microsoft.azure.functions.annotation.FunctionName");
            if (functionAnnotation == null) continue;
            String functionName = functionAnnotation.getStringValue("value", false);
            this.validateFunctionName(configMap.keySet(), functionName);
            log.debug("Starting processing function : " + functionName);
            configMap.put(functionName, this.generateConfiguration(project, method));
        }
        return configMap;
    }

    private void patchStorageBinding(FunctionMethod method, List<Binding> bindings) {
        Optional<FunctionAnnotation> storageAccount = method.getAnnotations().stream().filter(annotation -> annotation.isAnnotationType("com.microsoft.azure.functions.annotation.StorageAccount")).findFirst();
        if (storageAccount.isPresent()) {
            log.debug("StorageAccount annotation found.");
            String connectionString = storageAccount.get().getStringValue("value", true);
            bindings.stream().filter(binding -> binding.getBindingEnum().isStorage()).filter(binding -> StringUtils.isEmpty((CharSequence)((String)binding.getAttribute("connection")))).forEach(binding -> binding.setAttribute("connection", connectionString));
        } else {
            log.debug("No StorageAccount annotation found.");
        }
    }

    private void processMethodAnnotations(FunctionMethod method, List<Binding> bindings) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)method.getReturnTypeName(), (CharSequence)"void")) {
            bindings.addAll(this.parseAnnotations(method.getAnnotations(), this::parseMethodAnnotation));
            if (bindings.stream().anyMatch(b -> b.getBindingEnum() == BindingEnum.HttpTrigger) && bindings.stream().noneMatch(b -> b.getName().equalsIgnoreCase("$return"))) {
                bindings.add(this.getHTTPOutBinding());
            }
        }
    }

    private Binding parseMethodAnnotation(FunctionAnnotation annotation) {
        Binding ret = this.parseParameterAnnotation(annotation);
        if (ret != null) {
            ret.setName("$return");
        }
        return ret;
    }

    private void processParameterAnnotations(FunctionMethod method, List<Binding> bindings) {
        for (FunctionAnnotation[] paramAnnotations : method.getParameterAnnotations()) {
            bindings.addAll(this.parseAnnotations(Arrays.asList(paramAnnotations), this::parseParameterAnnotation));
        }
    }

    private List<Binding> parseAnnotations(List<FunctionAnnotation> annotationBindings, Function<FunctionAnnotation, Binding> annotationParser) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (FunctionAnnotation annotation : annotationBindings) {
            Binding binding = annotationParser.apply(annotation);
            if (binding == null) continue;
            log.debug("Adding binding: " + binding);
            bindings.add(binding);
        }
        return bindings;
    }

    private Binding createBinding(BindingEnum bindingEnum, FunctionAnnotation annotationBinding) {
        Binding binding = new Binding(bindingEnum);
        annotationBinding.getPropertiesWithRequiredProperties(REQUIRED_ATTRIBUTE_MAP.get((Object)bindingEnum)).forEach(binding::setAttribute);
        return binding;
    }

    private Binding parseParameterAnnotation(FunctionAnnotation annotation) {
        return this.getBinding(annotation);
    }

    private void validateFunctionName(Set<String> nameSet, String functionName) {
        if (StringUtils.isEmpty((CharSequence)functionName)) {
            throw new AzureToolkitRuntimeException("Azure Functions name cannot be empty.");
        }
        if (nameSet.stream().anyMatch(n -> StringUtils.equalsIgnoreCase((CharSequence)n, (CharSequence)functionName))) {
            throw new AzureToolkitRuntimeException("Found duplicate Azure Function: " + functionName);
        }
    }

    private Binding getBinding(FunctionAnnotation annotation) {
        String fqn = annotation.getAnnotationClassName();
        BindingEnum annotationEnum = Arrays.stream(BindingEnum.values()).filter(bindingEnum -> StringUtils.equalsIgnoreCase((CharSequence)bindingEnum.name(), (CharSequence)ClassUtils.getShortClassName((String)fqn))).findFirst().orElse(null);
        FunctionAnnotation customBindingAnnotation = annotation.getAnnotationClass().getAnnotation("com.microsoft.azure.functions.annotation.CustomBinding");
        if (customBindingAnnotation != null) {
            Map<String, Object> annotationProperties = customBindingAnnotation.getPropertiesWithRequiredProperties(CUSTOM_BINDING_RESERVED_PROPERTIES);
            Map<String, Object> customBindingProperties = annotation.getPropertiesWithRequiredProperties(CUSTOM_BINDING_RESERVED_PROPERTIES);
            customBindingProperties.putAll(annotationProperties);
            Map<String, Object> userDefined = annotation.getDeclaredAnnotationProperties();
            return this.createCustomBinding(customBindingProperties, userDefined);
        }
        if (annotation.isAnnotationType("com.microsoft.azure.functions.annotation.CustomBinding")) {
            Map<String, Object> customBindingProperties = annotation.getPropertiesWithRequiredProperties(CUSTOM_BINDING_RESERVED_PROPERTIES);
            return this.createCustomBinding(customBindingProperties, null);
        }
        if (annotationEnum != null) {
            return this.createBinding(annotationEnum, annotation);
        }
        return null;
    }

    private Binding createCustomBinding(Map<String, Object> map1, Map<String, Object> map2) {
        HashMap<String, Object> mergedMap = new HashMap<String, Object>(map1);
        if (map2 != null) {
            mergedMap.putAll(map2);
        }
        ExtendedCustomBinding extendBinding = new ExtendedCustomBinding((String)mergedMap.get("name"), (String)mergedMap.get("direction"), (String)mergedMap.get("type"));
        mergedMap.forEach((name, value) -> {
            if (!CUSTOM_BINDING_RESERVED_PROPERTIES.contains(name)) {
                extendBinding.setAttribute((String)name, value);
            }
        });
        return extendBinding;
    }

    private Binding getHTTPOutBinding() {
        Binding result = new Binding(BindingEnum.HttpOutput);
        result.setName("$return");
        return result;
    }

    private Retry getRetryConfigurationFromMethod(FunctionMethod method) {
        FunctionAnnotation fixedDelayRetry = method.getAnnotation("com.microsoft.azure.functions.annotation.FixedDelayRetry");
        FunctionAnnotation exponentialBackoffRetry = method.getAnnotation("com.microsoft.azure.functions.annotation.ExponentialBackoffRetry");
        if (fixedDelayRetry != null && exponentialBackoffRetry != null) {
            throw new AzureToolkitRuntimeException(MULTI_RETRY_ANNOTATION);
        }
        if (fixedDelayRetry != null) {
            return this.createRetryFromMap(fixedDelayRetry.getAllAnnotationProperties());
        }
        if (exponentialBackoffRetry != null) {
            return this.createRetryFromMap(exponentialBackoffRetry.getAllAnnotationProperties());
        }
        return null;
    }

    private Retry createRetryFromMap(Map<String, Object> map) {
        return (Retry)JsonUtils.fromJson((String)JsonUtils.toJson(map), Retry.class);
    }

    static {
        REQUIRED_ATTRIBUTE_MAP.put(BindingEnum.EventHubTrigger, Collections.singletonList("cardinality"));
        REQUIRED_ATTRIBUTE_MAP.put(BindingEnum.HttpTrigger, Collections.singletonList("authLevel"));
    }
}

