/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.entity;

import com.microsoft.azure.toolkit.lib.common.action.Action;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FunctionEntity {
    public static final Action.Id<FunctionEntity> TRIGGER_FUNCTION = Action.Id.of((String)"user/function.trigger_func.trigger");
    public static final Action.Id<FunctionEntity> TRIGGER_FUNCTION_IN_BROWSER = Action.Id.of((String)"user/function.trigger_func_in_browser.trigger");
    public static final String HTTP_TRIGGER = "httptrigger";
    private final String triggerId;
    private final String functionAppId;
    private final String name;
    private final String scriptFile;
    private final String entryPoint;
    private final String triggerUrl;
    private final List<BindingEntity> bindingList;

    @Nullable
    public BindingEntity getTrigger() {
        if (CollectionUtils.isEmpty(this.bindingList)) {
            return null;
        }
        return this.bindingList.stream().filter(bindingResource -> StringUtils.equalsIgnoreCase((CharSequence)bindingResource.getDirection(), (CharSequence)"in") && StringUtils.containsIgnoreCase((CharSequence)bindingResource.getType(), (CharSequence)"trigger")).findFirst().orElse(null);
    }

    public boolean isHttpTrigger() {
        String triggerType = Optional.ofNullable(this.getTrigger()).map(functionTrigger -> functionTrigger.getProperty("type")).orElse(null);
        return StringUtils.equalsIgnoreCase((CharSequence)triggerType, (CharSequence)HTTP_TRIGGER);
    }

    @Generated
    protected FunctionEntity(FunctionEntityBuilder<?, ?> b) {
        this.triggerId = ((FunctionEntityBuilder)b).triggerId;
        this.functionAppId = ((FunctionEntityBuilder)b).functionAppId;
        this.name = ((FunctionEntityBuilder)b).name;
        this.scriptFile = ((FunctionEntityBuilder)b).scriptFile;
        this.entryPoint = ((FunctionEntityBuilder)b).entryPoint;
        this.triggerUrl = ((FunctionEntityBuilder)b).triggerUrl;
        this.bindingList = ((FunctionEntityBuilder)b).bindingList;
    }

    @Generated
    public static FunctionEntityBuilder<?, ?> builder() {
        return new FunctionEntityBuilderImpl();
    }

    @Generated
    public String getTriggerId() {
        return this.triggerId;
    }

    @Generated
    public String getFunctionAppId() {
        return this.functionAppId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getScriptFile() {
        return this.scriptFile;
    }

    @Generated
    public String getEntryPoint() {
        return this.entryPoint;
    }

    @Generated
    public String getTriggerUrl() {
        return this.triggerUrl;
    }

    @Generated
    public List<BindingEntity> getBindingList() {
        return this.bindingList;
    }

    public static class BindingEntity {
        private final String type;
        private final String direction;
        private final String name;
        private final Map<String, String> properties;

        public String getProperty(String key) {
            return Optional.ofNullable(this.properties).map(map -> (String)map.get(key)).orElse(null);
        }

        @Generated
        protected BindingEntity(BindingEntityBuilder<?, ?> b) {
            this.type = ((BindingEntityBuilder)b).type;
            this.direction = ((BindingEntityBuilder)b).direction;
            this.name = ((BindingEntityBuilder)b).name;
            this.properties = ((BindingEntityBuilder)b).properties;
        }

        @Generated
        public static BindingEntityBuilder<?, ?> builder() {
            return new BindingEntityBuilderImpl();
        }

        @Generated
        public BindingEntityBuilder<?, ?> toBuilder() {
            return new BindingEntityBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getDirection() {
            return this.direction;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Map<String, String> getProperties() {
            return this.properties;
        }

        @Generated
        public static abstract class BindingEntityBuilder<C extends BindingEntity, B extends BindingEntityBuilder<C, B>> {
            @Generated
            private String type;
            @Generated
            private String direction;
            @Generated
            private String name;
            @Generated
            private Map<String, String> properties;

            @Generated
            protected B $fillValuesFrom(C instance) {
                BindingEntityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(BindingEntity instance, BindingEntityBuilder<?, ?> b) {
                b.type(instance.type);
                b.direction(instance.direction);
                b.name(instance.name);
                b.properties(instance.properties);
            }

            @Generated
            public B type(String type) {
                this.type = type;
                return this.self();
            }

            @Generated
            public B direction(String direction) {
                this.direction = direction;
                return this.self();
            }

            @Generated
            public B name(String name) {
                this.name = name;
                return this.self();
            }

            @Generated
            public B properties(Map<String, String> properties) {
                this.properties = properties;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "FunctionEntity.BindingEntity.BindingEntityBuilder(type=" + this.type + ", direction=" + this.direction + ", name=" + this.name + ", properties=" + this.properties + ")";
            }
        }

        @Generated
        private static final class BindingEntityBuilderImpl
        extends BindingEntityBuilder<BindingEntity, BindingEntityBuilderImpl> {
            @Generated
            private BindingEntityBuilderImpl() {
            }

            @Override
            @Generated
            protected BindingEntityBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public BindingEntity build() {
                return new BindingEntity(this);
            }
        }
    }

    @Generated
    public static abstract class FunctionEntityBuilder<C extends FunctionEntity, B extends FunctionEntityBuilder<C, B>> {
        @Generated
        private String triggerId;
        @Generated
        private String functionAppId;
        @Generated
        private String name;
        @Generated
        private String scriptFile;
        @Generated
        private String entryPoint;
        @Generated
        private String triggerUrl;
        @Generated
        private List<BindingEntity> bindingList;

        @Generated
        public B triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this.self();
        }

        @Generated
        public B functionAppId(String functionAppId) {
            this.functionAppId = functionAppId;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B scriptFile(String scriptFile) {
            this.scriptFile = scriptFile;
            return this.self();
        }

        @Generated
        public B entryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
            return this.self();
        }

        @Generated
        public B triggerUrl(String triggerUrl) {
            this.triggerUrl = triggerUrl;
            return this.self();
        }

        @Generated
        public B bindingList(List<BindingEntity> bindingList) {
            this.bindingList = bindingList;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "FunctionEntity.FunctionEntityBuilder(triggerId=" + this.triggerId + ", functionAppId=" + this.functionAppId + ", name=" + this.name + ", scriptFile=" + this.scriptFile + ", entryPoint=" + this.entryPoint + ", triggerUrl=" + this.triggerUrl + ", bindingList=" + this.bindingList + ")";
        }
    }

    @Generated
    private static final class FunctionEntityBuilderImpl
    extends FunctionEntityBuilder<FunctionEntity, FunctionEntityBuilderImpl> {
        @Generated
        private FunctionEntityBuilderImpl() {
        }

        @Override
        @Generated
        protected FunctionEntityBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FunctionEntity build() {
            return new FunctionEntity(this);
        }
    }
}

