/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.function.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.cache.Preload;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.FunctionExtensionVersion;
import com.microsoft.azure.toolkit.lib.legacy.function.template.BindingConfiguration;
import com.microsoft.azure.toolkit.lib.legacy.function.template.BindingTemplate;
import com.microsoft.azure.toolkit.lib.legacy.function.template.BindingsTemplate;
import com.microsoft.azure.toolkit.lib.legacy.function.template.FunctionTemplate;
import com.microsoft.azure.toolkit.lib.legacy.function.template.FunctionTemplates;
import com.microsoft.azure.toolkit.lib.legacy.function.utils.FunctionUtils$AjcClosure1;
import com.microsoft.azure.toolkit.lib.legacy.function.utils.FunctionUtils$AjcClosure3;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class FunctionUtils {
    private static final String LOAD_TEMPLATES_FAIL = "Failed to load all function templates.";
    private static final String LOAD_BINDING_TEMPLATES_FAIL = "Failed to load function binding template.";
    private static final Pattern VERSION_PATTERN;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public static FunctionExtensionVersion parseFunctionExtensionVersion(String version) {
        return Arrays.stream(FunctionExtensionVersion.values()).filter(versionEnum -> StringUtils.equalsIgnoreCase((CharSequence)versionEnum.getVersion(), (CharSequence)version) || StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(versionEnum.getValue()), (CharSequence)version)).findFirst().orElse(FunctionExtensionVersion.UNKNOWN);
    }

    public static FunctionExtensionVersion parseFunctionExtensionVersionFromHostJson(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        return matcher.find() ? FunctionUtils.parseFunctionExtensionVersion(matcher.group(1)) : null;
    }

    @Nullable
    public static BindingTemplate loadBindingTemplate(String type) {
        return FunctionUtils.loadBindingTemplate(new BindingConfiguration(type, "in"));
    }

    @Nullable
    public static BindingTemplate loadBindingTemplate(@Nonnull BindingConfiguration conf) {
        return Optional.ofNullable(FunctionUtils.loadBindingsTemplate()).map(template -> template.getBindingTemplate(conf)).orElse(null);
    }

    @Nullable
    @Cacheable(value="function-bindings")
    public static BindingsTemplate loadBindingsTemplate() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        FunctionUtils$AjcClosure1 functionUtils$AjcClosure1 = new FunctionUtils$AjcClosure1(objectArray);
        return (BindingsTemplate)CacheManager.aspectOf().aroundCacheable(functionUtils$AjcClosure1.linkClosureAndJoinPoint(65536));
    }

    @Nonnull
    @Preload
    @Cacheable(value="function-templates")
    public static List<FunctionTemplate> loadAllFunctionTemplates() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        FunctionUtils$AjcClosure3 functionUtils$AjcClosure3 = new FunctionUtils$AjcClosure3(objectArray);
        return (List)CacheManager.aspectOf().aroundCacheable(functionUtils$AjcClosure3.linkClosureAndJoinPoint(65536));
    }

    static {
        FunctionUtils.ajc$preClinit();
        VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+|\\*)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final /* synthetic */ BindingsTemplate loadBindingsTemplate_aroundBody0(JoinPoint joinPoint) {
        try (InputStream is = FunctionUtils.class.getResourceAsStream("/bindings.json");){
            String bindingsJsonStr = IOUtils.toString((InputStream)Objects.requireNonNull(is), (Charset)StandardCharsets.UTF_8);
            BindingsTemplate bindingsTemplate = (BindingsTemplate)new ObjectMapper().readValue(bindingsJsonStr, BindingsTemplate.class);
            return bindingsTemplate;
        }
        catch (IOException e) {
            AzureMessager.getMessager().warning(LOAD_BINDING_TEMPLATES_FAIL);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final /* synthetic */ List loadAllFunctionTemplates_aroundBody2(JoinPoint joinPoint) {
        try (InputStream is = FunctionUtils.class.getResourceAsStream("/templates.json");){
            String templatesJsonStr = IOUtils.toString((InputStream)Objects.requireNonNull(is), (Charset)StandardCharsets.UTF_8);
            FunctionTemplates templates = (FunctionTemplates)new ObjectMapper().readValue(templatesJsonStr, FunctionTemplates.class);
            BindingsTemplate bindings = FunctionUtils.loadBindingsTemplate();
            List<FunctionTemplate> result = Optional.ofNullable(templates).map(FunctionTemplates::getTemplates).orElse(Collections.emptyList());
            result.forEach(template -> Optional.ofNullable(bindings).map(binding -> binding.getBindingTemplate(template.getBindingConfiguration())).ifPresent(template::setBinding));
            List<FunctionTemplate> list = result;
            return list;
        }
        catch (Exception e) {
            throw new AzureToolkitRuntimeException(LOAD_TEMPLATES_FAIL, (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FunctionUtils.java", FunctionUtils.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "loadBindingsTemplate", "com.microsoft.azure.toolkit.lib.legacy.function.utils.FunctionUtils", "", "", "", "com.microsoft.azure.toolkit.lib.legacy.function.template.BindingsTemplate"), 69);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "loadAllFunctionTemplates", "com.microsoft.azure.toolkit.lib.legacy.function.utils.FunctionUtils", "", "", "", "java.util.List"), 83);
    }
}

