/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.webapp;

import com.azure.resourcemanager.appservice.models.WebAppBasic;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppBase;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDeploymentSlotModule;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppModule;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.servicelinker.ServiceLinkerConsumer;
import com.microsoft.azure.toolkit.lib.servicelinker.ServiceLinkerModule;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class WebApp
extends WebAppBase<WebApp, AppServiceServiceSubscription, com.azure.resourcemanager.appservice.models.WebApp>
implements Deletable,
ServiceLinkerConsumer {
    @Nonnull
    private final WebAppDeploymentSlotModule deploymentModule;
    private final ServiceLinkerModule linkerModule;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    protected WebApp(@Nonnull WebApp origin) {
        super(origin);
        this.deploymentModule = origin.deploymentModule;
        this.linkerModule = origin.linkerModule;
    }

    protected WebApp(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull WebAppModule module) {
        super(name, resourceGroupName, module);
        this.deploymentModule = new WebAppDeploymentSlotModule(this);
        this.linkerModule = new ServiceLinkerModule(this.getId(), (ServiceLinkerConsumer)this);
    }

    protected WebApp(@Nonnull WebAppBasic remote, @Nonnull WebAppModule module) {
        super(remote.name(), remote.resourceGroupName(), module);
        this.deploymentModule = new WebAppDeploymentSlotModule(this);
        this.linkerModule = new ServiceLinkerModule(this.getId(), (ServiceLinkerConsumer)this);
    }

    @AzureOperation(name="azure/webapp.swap_slot.app|slot", params={"this.getName()", "slotName"})
    public void swap(String slotName) {
        String string = slotName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> {
                ((com.azure.resourcemanager.appservice.models.WebApp)Objects.requireNonNull(this.getRemote())).swap(slotName);
                AzureMessager.getMessager().info(AzureString.format((String)"Swap deployment slot %s into production successfully", (Object[])new Object[]{slotName}));
            }, "Updating");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Arrays.asList(this.deploymentModule, this.linkerModule);
    }

    @Nonnull
    public WebAppDeploymentSlotModule slots() {
        return this.deploymentModule;
    }

    public ServiceLinkerModule getServiceLinkerModule() {
        return this.linkerModule;
    }

    @Nullable
    protected com.azure.resourcemanager.appservice.models.WebApp doModify(@Nonnull Callable<com.azure.resourcemanager.appservice.models.WebApp> body, @Nullable String status) {
        return (com.azure.resourcemanager.appservice.models.WebApp)super.doModify(body, status);
    }

    @Nonnull
    public WebAppDeploymentSlotModule getDeploymentModule() {
        return this.deploymentModule;
    }

    public ServiceLinkerModule getLinkerModule() {
        return this.linkerModule;
    }

    static {
        WebApp.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WebApp.java", WebApp.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "swap", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp", "java.lang.String", "slotName", "", "void"), 55);
    }
}

