/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.function.configurations;

import com.microsoft.azure.toolkit.lib.appservice.function.core.FunctionAnnotation;
import com.microsoft.azure.toolkit.lib.appservice.function.impl.DefaultFunctionProject;
import java.lang.annotation.Annotation;

public class Retry {
    private String strategy;
    private int maxRetryCount;
    private String delayInterval;
    private String minimumInterval;
    private String maximumInterval;

    public static Retry createFixedDelayRetryFromAnnotation(FunctionAnnotation annotation) {
        return ((RetryBuilder)((RetryBuilder)((RetryBuilder)Retry.builder().strategy(annotation.getStringValue("strategy", true))).maxRetryCount((Integer)annotation.get("maxRetryCount", true))).delayInterval(annotation.getStringValue("delayInterval", true))).build();
    }

    public static Retry createFixedDelayRetryFromAnnotation(Annotation fixedDelayRetry) {
        return Retry.createFixedDelayRetryFromAnnotation(DefaultFunctionProject.create(fixedDelayRetry));
    }

    public static Retry createExponentialBackoffRetryFromAnnotation(FunctionAnnotation annotation) {
        return ((RetryBuilder)((RetryBuilder)((RetryBuilder)((RetryBuilder)Retry.builder().strategy(annotation.getStringValue("strategy", true))).maxRetryCount((Integer)annotation.get("maxRetryCount", true))).minimumInterval(annotation.getStringValue("minimumInterval", true))).maximumInterval(annotation.getStringValue("maximumInterval", true))).build();
    }

    public static Retry createExponentialBackoffRetryFromAnnotation(Annotation exponentialBackoffRetry) {
        return Retry.createExponentialBackoffRetryFromAnnotation(DefaultFunctionProject.create(exponentialBackoffRetry));
    }

    protected Retry(RetryBuilder<?, ?> b) {
        this.strategy = ((RetryBuilder)b).strategy;
        this.maxRetryCount = ((RetryBuilder)b).maxRetryCount;
        this.delayInterval = ((RetryBuilder)b).delayInterval;
        this.minimumInterval = ((RetryBuilder)b).minimumInterval;
        this.maximumInterval = ((RetryBuilder)b).maximumInterval;
    }

    public static RetryBuilder<?, ?> builder() {
        return new RetryBuilderImpl();
    }

    public RetryBuilder<?, ?> toBuilder() {
        return new RetryBuilderImpl().$fillValuesFrom(this);
    }

    public String getStrategy() {
        return this.strategy;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public String getDelayInterval() {
        return this.delayInterval;
    }

    public String getMinimumInterval() {
        return this.minimumInterval;
    }

    public String getMaximumInterval() {
        return this.maximumInterval;
    }

    public static abstract class RetryBuilder<C extends Retry, B extends RetryBuilder<C, B>> {
        private String strategy;
        private int maxRetryCount;
        private String delayInterval;
        private String minimumInterval;
        private String maximumInterval;

        protected B $fillValuesFrom(C instance) {
            RetryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(Retry instance, RetryBuilder<?, ?> b) {
            b.strategy(instance.strategy);
            b.maxRetryCount(instance.maxRetryCount);
            b.delayInterval(instance.delayInterval);
            b.minimumInterval(instance.minimumInterval);
            b.maximumInterval(instance.maximumInterval);
        }

        protected abstract B self();

        public abstract C build();

        public B strategy(String strategy) {
            this.strategy = strategy;
            return this.self();
        }

        public B maxRetryCount(int maxRetryCount) {
            this.maxRetryCount = maxRetryCount;
            return this.self();
        }

        public B delayInterval(String delayInterval) {
            this.delayInterval = delayInterval;
            return this.self();
        }

        public B minimumInterval(String minimumInterval) {
            this.minimumInterval = minimumInterval;
            return this.self();
        }

        public B maximumInterval(String maximumInterval) {
            this.maximumInterval = maximumInterval;
            return this.self();
        }

        public String toString() {
            return "Retry.RetryBuilder(strategy=" + this.strategy + ", maxRetryCount=" + this.maxRetryCount + ", delayInterval=" + this.delayInterval + ", minimumInterval=" + this.minimumInterval + ", maximumInterval=" + this.maximumInterval + ")";
        }
    }

    private static final class RetryBuilderImpl
    extends RetryBuilder<Retry, RetryBuilderImpl> {
        private RetryBuilderImpl() {
        }

        @Override
        protected RetryBuilderImpl self() {
            return this;
        }

        @Override
        public Retry build() {
            return new Retry(this);
        }
    }
}

