/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.task;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServicePlanConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.DeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppDockerRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppLinuxRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppWindowsRuntime;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlanDraft;
import com.microsoft.azure.toolkit.lib.appservice.task.DeployWebAppTask;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.appservice.webapp.AzureWebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppBase;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDeploymentSlotDraft;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDraft;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.Availability;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.resource.task.CreateResourceGroupTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateOrUpdateWebAppTask
extends AzureTask<WebAppBase<?, ?, ?>> {
    private static final Logger log;
    private static final String CREATE_NEW_WEB_APP = "createNewWebApp";
    private static final String WEBAPP_NOT_EXIST_FOR_SLOT = "Target Web App does not exist. Please make sure the Web App name is correct.";
    private final AppServiceConfig config;
    private final List<AzureTask<?>> subTasks;
    private boolean skipCreateAzureResource;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public CreateOrUpdateWebAppTask(AppServiceConfig config) {
        this.config = config;
        this.subTasks = this.initTasks();
    }

    private List<AzureTask<?>> initTasks() {
        ArrayList tasks = new ArrayList();
        AzureString title = AzureString.format((String)"Create new web app({0})", (Object[])new Object[]{this.config.appName()});
        tasks.add(new AzureTask(title, () -> {
            WebAppBase<?, ?, ?> app = this.createOrUpdateResource();
            Optional.ofNullable(this.config.file()).map(file -> new DeployWebAppTask(app, Collections.singletonList(((WebAppArtifact.WebAppArtifactBuilder)((WebAppArtifact.WebAppArtifactBuilder)WebAppArtifact.builder().file((File)file)).deployType(DeployType.getDeployTypeFromFile(file))).build()))).ifPresent(DeployWebAppTask::doExecute);
            return app;
        }));
        return tasks;
    }

    private WebAppBase<?, ?, ?> createOrUpdateResource() {
        AzureWebApp az = (AzureWebApp)Azure.az(AzureWebApp.class);
        WebApp target = (WebApp)az.webApps(this.config.subscriptionId()).getOrDraft(this.config.appName(), this.config.resourceGroup());
        if (!this.isDeployToDeploymentSlot()) {
            if (!target.exists()) {
                Availability result;
                if (this.skipCreateAzureResource) {
                    Utils.throwForbidCreateResourceWarning("Web app", this.config.appName());
                }
                if (!(result = Objects.requireNonNull((AppServiceServiceSubscription)az.get(this.config.subscriptionId(), null)).checkNameAvailability(this.config.appName())).isAvailable()) {
                    throw new AzureToolkitRuntimeException(AzureString.format((String)"Cannot create webapp {0} due to error: {1}", (Object[])new Object[]{this.config.appName(), result.getUnavailabilityReason()}).getString());
                }
                return this.create();
            }
            return this.update(target);
        }
        if (!target.exists()) {
            throw new AzureToolkitRuntimeException(WEBAPP_NOT_EXIST_FOR_SLOT);
        }
        WebAppDeploymentSlotDraft slotDraft = (WebAppDeploymentSlotDraft)target.slots().updateOrCreate(this.config.deploymentSlotName(), this.config.resourceGroup());
        boolean slotExists = slotDraft.exists();
        if (!slotExists && this.skipCreateAzureResource) {
            Utils.throwForbidCreateResourceWarning("Deployment slot", this.config.deploymentSlotName());
        }
        return slotExists ? this.updateDeploymentSlot(slotDraft) : this.createDeploymentSlot(slotDraft);
    }

    @AzureOperation(name="azure/webapp.create_app.app", params={"this.config.appName()"})
    private WebApp create() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            OperationContext.action().setTelemetryProperty(CREATE_NEW_WEB_APP, String.valueOf(true));
            Region region = this.config.region();
            AppServicePlanConfig planConfig = FunctionAppConfig.getServicePlanConfig(this.config);
            new CreateResourceGroupTask(this.config.subscriptionId(), this.config.resourceGroup(), region).doExecute();
            AppServicePlanDraft planDraft = (AppServicePlanDraft)((AzureAppService)Azure.az(AzureAppService.class)).plans(planConfig.getSubscriptionId()).updateOrCreate(planConfig.getName(), planConfig.getResourceGroupName());
            planDraft.setPlanConfig(planConfig);
            WebAppDraft appDraft = (WebAppDraft)((AzureWebApp)Azure.az(AzureWebApp.class)).webApps(this.config.subscriptionId()).create(this.config.appName(), this.config.resourceGroup());
            appDraft.setAppServicePlan((AppServicePlan)planDraft.commit());
            appDraft.setRuntime(this.getRuntime(this.config.runtime()));
            appDraft.setDiagnosticConfig(this.config.diagnosticConfig());
            appDraft.setDockerConfiguration(this.getDockerConfiguration(this.config.runtime()));
            appDraft.setAppSettings(this.config.appSettings());
            WebApp webApp = (WebApp)appDraft.createIfNotExist();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/webapp.update_app.app", params={"this.config.appName()"})
    private WebApp update(WebApp webApp) {
        WebApp webApp2 = webApp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)webApp2);
        try {
            AppServicePlanDraft planDraft;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            WebAppDraft draft = (WebAppDraft)webApp.update();
            WebAppRuntime runtime = this.getRuntime(this.config.runtime());
            AppServicePlanConfig planConfig = AppServiceConfig.getServicePlanConfig(this.config);
            AppServicePlanDraft appServicePlanDraft = planDraft = StringUtils.isBlank((CharSequence)planConfig.getName()) ? null : (AppServicePlanDraft)((AzureAppService)Azure.az(AzureAppService.class)).plans(planConfig.getSubscriptionId()).updateOrCreate(planConfig.getName(), planConfig.getResourceGroupName());
            if (this.skipCreateAzureResource && Objects.nonNull(planDraft) && !planDraft.exists()) {
                Utils.throwForbidCreateResourceWarning("Service plan", planConfig.getResourceGroupName() + "/" + planConfig.getName());
            }
            Optional.ofNullable(planDraft).ifPresent(plan -> {
                plan.setPlanConfig(planConfig);
                draft.setAppServicePlan((AppServicePlan)plan.commit());
            });
            draft.setRuntime(runtime);
            draft.setDockerConfiguration(this.getDockerConfiguration(this.config.runtime()));
            draft.setAppSettings((Map)ObjectUtils.firstNonNull((Object[])new Map[]{this.config.appSettings(), new HashMap()}));
            draft.setDiagnosticConfig(this.config.diagnosticConfig());
            draft.removeAppSettings(this.config.appSettingsToRemove());
            WebApp webApp3 = (WebApp)draft.updateIfExist();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webApp3;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="internal/webapp.create_slot.slot|app", params={"this.config.deploymentSlotName()", "this.config.appName()"})
    private WebAppDeploymentSlot createDeploymentSlot(WebAppDeploymentSlotDraft draft) {
        WebAppDeploymentSlotDraft webAppDeploymentSlotDraft = draft;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)webAppDeploymentSlotDraft);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            draft.setRuntime(this.getRuntime(this.config.runtime()));
            draft.setDockerConfiguration(this.getDockerConfiguration(this.config.runtime()));
            draft.setAppSettings(this.config.appSettings());
            draft.removeAppSettings(this.config.appSettingsToRemove());
            draft.setDiagnosticConfig(this.config.diagnosticConfig());
            draft.setConfigurationSource(this.config.deploymentSlotConfigurationSource());
            WebAppDeploymentSlot webAppDeploymentSlot = (WebAppDeploymentSlot)draft.commit();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webAppDeploymentSlot;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="internal/webapp.update_slot.slot|app", params={"this.config.deploymentSlotName()", "this.config.appName()"})
    private WebAppDeploymentSlot updateDeploymentSlot(WebAppDeploymentSlotDraft draft) {
        WebAppDeploymentSlotDraft webAppDeploymentSlotDraft = draft;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)webAppDeploymentSlotDraft);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            draft.setRuntime(this.getRuntime(this.config.runtime()));
            draft.setDockerConfiguration(this.getDockerConfiguration(this.config.runtime()));
            draft.setDiagnosticConfig(this.config.diagnosticConfig());
            draft.setAppSettings(this.config.appSettings());
            draft.removeAppSettings(this.config.appSettingsToRemove());
            WebAppDeploymentSlot webAppDeploymentSlot = (WebAppDeploymentSlot)draft.commit();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webAppDeploymentSlot;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private boolean isDeployToDeploymentSlot() {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.config.deploymentSlotName()});
    }

    private DockerConfiguration getDockerConfiguration(RuntimeConfig runtime) {
        if (runtime != null && OperatingSystem.DOCKER == runtime.os()) {
            return ((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)DockerConfiguration.builder().userName(runtime.username())).password(runtime.password())).registryUrl(runtime.registryUrl())).image(runtime.image())).startUpCommand(runtime.startUpCommand())).build();
        }
        return null;
    }

    private WebAppRuntime getRuntime(RuntimeConfig runtimeConfig) {
        if (runtimeConfig == null) {
            return null;
        }
        OperatingSystem os = runtimeConfig.os();
        WebAppRuntime runtime = null;
        if (os == OperatingSystem.DOCKER) {
            runtime = WebAppDockerRuntime.INSTANCE;
        } else if (os == OperatingSystem.LINUX) {
            runtime = WebAppLinuxRuntime.fromContainerAndJavaVersionUserText(runtimeConfig.webContainer(), runtimeConfig.javaVersion());
        } else if (os == OperatingSystem.WINDOWS) {
            runtime = WebAppWindowsRuntime.fromContainerAndJavaVersionUserText(runtimeConfig.webContainer(), runtimeConfig.javaVersion());
        }
        if (Objects.isNull(runtime) && (Objects.nonNull((Object)os) || StringUtils.isNotBlank((CharSequence)runtimeConfig.webContainer()) || StringUtils.isNotBlank((CharSequence)runtimeConfig.javaVersion()))) {
            throw new AzureToolkitRuntimeException("invalid runtime configuration, please refer to https://aka.ms/maven_webapp_runtime for valid values");
        }
        return runtime;
    }

    @AzureOperation(name="internal/webapp.create_update_app.app", params={"this.config.appName()"})
    public WebAppBase<?, ?, ?> doExecute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Object result = null;
            for (AzureTask<?> task : this.subTasks) {
                try {
                    result = task.getBody().call();
                }
                catch (AzureToolkitRuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new AzureToolkitRuntimeException(e);
                }
            }
            WebAppBase webAppBase = result;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webAppBase;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public void setSkipCreateAzureResource(boolean skipCreateAzureResource) {
        this.skipCreateAzureResource = skipCreateAzureResource;
    }

    static {
        CreateOrUpdateWebAppTask.ajc$preClinit();
        log = LoggerFactory.getLogger(CreateOrUpdateWebAppTask.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CreateOrUpdateWebAppTask.java", CreateOrUpdateWebAppTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "create", "com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateWebAppTask", "", "", "", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp"), 112);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "update", "com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateWebAppTask", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp", "webApp", "", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp"), 133);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createDeploymentSlot", "com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateWebAppTask", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDeploymentSlotDraft", "draft", "", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDeploymentSlot"), 157);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateDeploymentSlot", "com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateWebAppTask", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDeploymentSlotDraft", "draft", "", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDeploymentSlot"), 168);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doExecute", "com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateWebAppTask", "", "", "", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppBase"), 216);
    }
}

