/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.azure.resourcemanager.appservice.models.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public interface Runtime {
    public static final String FUNCTION_UPGRADE_RUNTIME_LINK = "https://aka.ms/javatooling/function.upgrade_runtime";

    public OperatingSystem getOperatingSystem();

    public String getDisplayName();

    @Nonnull
    public String getJavaVersionNumber();

    default public String getJavaVersionUserText() {
        if (this.isDocker()) {
            return "";
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)this.getJavaVersionNumber(), (CharSequence[])new CharSequence[]{"1.8", "8"})) {
            return "Java 8";
        }
        return String.format("Java %s", this.getJavaVersionNumber());
    }

    default public JavaVersion getJavaVersion() {
        if (this.isDocker()) {
            return JavaVersion.fromString((String)"docker");
        }
        return JavaVersion.fromString((String)this.getJavaVersionNumber());
    }

    default public int getJavaMajorVersionNumber() {
        if (this.isDocker()) {
            return 0;
        }
        String v = this.getJavaVersionNumber();
        return Runtime.getJavaMajorVersionNumber(v);
    }

    default public boolean isDeprecated() {
        return false;
    }

    default public boolean isHidden() {
        return false;
    }

    default public boolean isEarlyAccess() {
        return false;
    }

    default public boolean isAutoUpdate() {
        return false;
    }

    default public boolean isPreview() {
        return false;
    }

    @Nullable
    default public OffsetDateTime getEndOfLifeDate() {
        return null;
    }

    default public boolean isMajorVersion() {
        return true;
    }

    default public boolean isWindows() {
        return this.getOperatingSystem() == OperatingSystem.WINDOWS;
    }

    default public boolean isLinux() {
        return this.getOperatingSystem() == OperatingSystem.LINUX;
    }

    default public boolean isDocker() {
        return this.getOperatingSystem() == OperatingSystem.DOCKER;
    }

    public static int getJavaMajorVersionNumber(String javaVersionUserText) {
        String v = StringUtils.replaceIgnoreCase((String)javaVersionUserText, (String)"java", (String)"").trim();
        String[] parts = v.split("\\.", 3);
        return Integer.parseInt(StringUtils.startsWithIgnoreCase((CharSequence)v, (CharSequence)"1.") ? parts[1] : parts[0]);
    }

    public static String extractAndFormalizeJavaVersionNumber(String javaVersion) {
        javaVersion = StringUtils.replaceIgnoreCase((String)javaVersion, (String)"java", (String)"").trim();
        String string = javaVersion = StringUtils.equalsAny((CharSequence)javaVersion, (CharSequence[])new CharSequence[]{"8", "7"}) ? "1." + javaVersion : javaVersion;
        if (javaVersion.contains("u")) {
            String[] parts = javaVersion.split("u", 2);
            return String.format("1.%s.0_%s", parts[0], parts[1]);
        }
        return javaVersion;
    }

    public static void tryWarningDeprecation(@Nonnull AppServiceAppBase<?, ?, ?> app) {
        Runtime runtime = app.getRuntime();
        AzureString message = null;
        if (Objects.nonNull(runtime)) {
            String link;
            String string = link = runtime instanceof FunctionAppRuntime ? String.format(" refer to %s", FUNCTION_UPGRADE_RUNTIME_LINK) : "";
            if (runtime.isHidden() || runtime.isDeprecated()) {
                message = Objects.nonNull(runtime.getEndOfLifeDate()) ? AzureString.format((String)("The runtime of your app \"%s\" has reached EOL on %s and is no longer supported, please upgrade it." + link), (Object[])new Object[]{runtime.toString(), runtime.getEndOfLifeDate().format(DateTimeFormatter.ISO_DATE)}) : AzureString.format((String)("The runtime of your app \"%s\" has reached EOL and is no longer supported, please upgrade it." + link), (Object[])new Object[]{runtime.toString()});
            } else if (runtime.isEarlyAccess()) {
                message = AzureString.format((String)("The runtime of your app \"%s\" is early access, please be careful to use it in production environment." + link), (Object[])new Object[]{runtime.toString()});
            } else if (runtime.isPreview()) {
                message = AzureString.format((String)("The runtime of your app \"%s\" is preview, please be careful to use it in production environment." + link), (Object[])new Object[]{runtime.toString()});
            } else if (Objects.nonNull(runtime.getEndOfLifeDate()) && runtime.getEndOfLifeDate().minusMonths(6L).isBefore(OffsetDateTime.now())) {
                message = AzureString.format((String)("The runtime of your app \"%s\" will reach EOL on %s and will no longer be supported, please upgrade it." + link), (Object[])new Object[]{runtime.toString(), runtime.getEndOfLifeDate().format(DateTimeFormatter.ISO_DATE)});
            }
        }
        if (Objects.nonNull(message)) {
            Action openUrl = AzureActionManager.getInstance().getAction(Action.OPEN_URL);
            Action action = app.exists() && Objects.nonNull(openUrl) ? openUrl.bind((Object)String.format("%s/configuration", app.getPortalUrl())).withLabel("Configure in Azure Portal") : null;
            AzureMessager.getMessager().warning(message, new Object[]{action});
        }
    }
}

