/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.azure.resourcemanager.appservice.models.FunctionAppMajorVersion;
import com.azure.resourcemanager.appservice.models.FunctionAppMinorVersion;
import com.azure.resourcemanager.appservice.models.FunctionAppRuntimeSettings;
import com.azure.resourcemanager.appservice.models.FunctionAppRuntimes;
import com.azure.resourcemanager.appservice.models.JavaVersion;
import com.google.common.collect.Sets;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class FunctionAppWindowsRuntime
implements FunctionAppRuntime {
    public static final FunctionAppWindowsRuntime FUNCTION_JAVA17 = new FunctionAppWindowsRuntime("Java 17");
    public static final FunctionAppWindowsRuntime FUNCTION_JAVA11 = new FunctionAppWindowsRuntime("Java 11");
    public static final FunctionAppWindowsRuntime FUNCTION_JAVA8 = new FunctionAppWindowsRuntime("Java 1.8");
    private static final LinkedHashSet<FunctionAppWindowsRuntime> RUNTIMES = Sets.newLinkedHashSet(Arrays.asList(FUNCTION_JAVA17, FUNCTION_JAVA11, FUNCTION_JAVA8));
    private static final AtomicReference<Boolean> loaded = new AtomicReference<Boolean>(Boolean.FALSE);
    private final OperatingSystem operatingSystem = OperatingSystem.WINDOWS;
    @Nonnull
    private final String javaVersionNumber;
    private final boolean deprecated;
    private final boolean hidden;
    private final boolean earlyAccess;
    private final boolean autoUpdate;
    private final boolean preview;
    @Nullable
    private final OffsetDateTime endOfLifeDate;

    private FunctionAppWindowsRuntime(@Nonnull FunctionAppMinorVersion javaVersion) {
        FunctionAppRuntimeSettings settings = javaVersion.stackSettings().windowsRuntimeSettings();
        this.javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(settings.runtimeVersion());
        this.deprecated = BooleanUtils.isTrue((Boolean)settings.isDeprecated());
        this.hidden = BooleanUtils.isTrue((Boolean)settings.isHidden());
        this.earlyAccess = BooleanUtils.isTrue((Boolean)settings.isEarlyAccess());
        this.autoUpdate = BooleanUtils.isTrue((Boolean)settings.isAutoUpdate());
        this.preview = BooleanUtils.isTrue((Boolean)settings.isPreview());
        this.endOfLifeDate = settings.endOfLifeDate();
    }

    private FunctionAppWindowsRuntime(@Nonnull Map<String, Object> javaVersion) {
        Map settings = (Map)Utils.get(javaVersion, (String)"$.stackSettings.windowsRuntimeSettings");
        this.javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(Objects.requireNonNull((String)Utils.get((Map)settings, (String)"$.runtimeVersion")));
        this.deprecated = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)settings, (String)"$.isDeprecated")));
        this.hidden = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)settings, (String)"$.isHidden")));
        this.earlyAccess = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)settings, (String)"$.isEarlyAccess")));
        this.autoUpdate = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)settings, (String)"$.isAutoUpdate")));
        this.preview = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)settings, (String)"$.isPreview")));
        CharSequence endOfLifeDateStr = (CharSequence)Utils.get((Map)settings, (String)"$.endOfLifeDate");
        this.endOfLifeDate = StringUtils.isBlank((CharSequence)endOfLifeDateStr) ? null : OffsetDateTime.parse(endOfLifeDateStr, DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    private FunctionAppWindowsRuntime(@Nonnull String javaVersionUserText) {
        String[] javaParts = javaVersionUserText.split(" ");
        this.javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(javaParts[1]);
        this.deprecated = false;
        this.hidden = false;
        this.earlyAccess = false;
        this.autoUpdate = false;
        this.preview = false;
        this.endOfLifeDate = null;
    }

    @Nullable
    public static FunctionAppWindowsRuntime fromJavaVersion(JavaVersion javaVersion) {
        return FunctionAppWindowsRuntime.getAllRuntimes().stream().filter(runtime -> StringUtils.equalsIgnoreCase((CharSequence)runtime.javaVersionNumber, (CharSequence)javaVersion.toString())).findFirst().orElse(null);
    }

    @Nullable
    public static FunctionAppWindowsRuntime fromJavaVersionUserText(String v) {
        if (StringUtils.isBlank((CharSequence)v)) {
            v = "Java 17";
            AzureMessager.getMessager().warning(AzureString.format((String)"The java version is not specified, use default version '%s'", (Object[])new Object[]{"Java 17"}));
        }
        return FunctionAppWindowsRuntime.fromJavaVersion(JavaVersion.fromString((String)Runtime.extractAndFormalizeJavaVersionNumber(v)));
    }

    public static List<FunctionAppWindowsRuntime> getAllRuntimes() {
        FunctionAppRuntime.tryLoadingAllRuntimes();
        return new ArrayList<FunctionAppWindowsRuntime>(RUNTIMES);
    }

    @Nonnull
    public static List<FunctionAppWindowsRuntime> getMajorRuntimes() {
        return FunctionAppWindowsRuntime.getAllRuntimes().stream().filter(r -> !r.isDeprecated() && !r.isHidden() && r.isMajorVersion()).collect(Collectors.toList());
    }

    public static boolean isLoaded() {
        return loaded.get() == Boolean.TRUE;
    }

    public static boolean isLoading() {
        return loaded.get() == null;
    }

    public static void loadAllFunctionAppWindowsRuntimes(List<FunctionAppMajorVersion> javaVersions) {
        if (!loaded.compareAndSet(Boolean.FALSE, null)) {
            return;
        }
        List<FunctionAppMinorVersion> javaMinorVersions = javaVersions.stream().flatMap(majorVersion -> majorVersion.minorVersions().stream()).collect(Collectors.toList());
        RUNTIMES.clear();
        javaMinorVersions.forEach(javaMinorVersion -> Optional.ofNullable(javaMinorVersion).map(FunctionAppMinorVersion::stackSettings).map(FunctionAppRuntimes::windowsRuntimeSettings).map(FunctionAppRuntimeSettings::runtimeVersion).ifPresent(s -> RUNTIMES.add(new FunctionAppWindowsRuntime((FunctionAppMinorVersion)javaMinorVersion))));
        loaded.compareAndSet(null, Boolean.TRUE);
    }

    public static void loadAllFunctionAppWindowsRuntimesFromMap(List<Map<String, Object>> javaVersions) {
        if (!loaded.compareAndSet(Boolean.FALSE, null)) {
            return;
        }
        RUNTIMES.clear();
        RUNTIMES.addAll(FunctionAppWindowsRuntime.getWindowsRuntimeFromMap(javaVersions));
        loaded.compareAndSet(null, Boolean.TRUE);
    }

    public static List<FunctionAppWindowsRuntime> getWindowsRuntimeFromMap(List<Map<String, Object>> javaVersions) {
        List javaMinorVersions = javaVersions.stream().flatMap(majorVersion -> ((List)Utils.get((Map)majorVersion, (String)"$.minorVersions")).stream()).collect(Collectors.toList());
        return javaMinorVersions.stream().map(javaMinorVersion -> {
            String runtimeVersion = (String)Utils.get((Map)javaMinorVersion, (String)"$.stackSettings.windowsRuntimeSettings.runtimeVersion");
            return StringUtils.isNotBlank((CharSequence)runtimeVersion) ? new FunctionAppWindowsRuntime((Map<String, Object>)javaMinorVersion) : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String toString() {
        return String.format("Windows | %s", this.getJavaVersionUserText());
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    @Nonnull
    public String getJavaVersionNumber() {
        return this.javaVersionNumber;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isEarlyAccess() {
        return this.earlyAccess;
    }

    @Override
    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    @Override
    public boolean isPreview() {
        return this.preview;
    }

    @Override
    @Nullable
    public OffsetDateTime getEndOfLifeDate() {
        return this.endOfLifeDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionAppWindowsRuntime)) {
            return false;
        }
        FunctionAppWindowsRuntime other = (FunctionAppWindowsRuntime)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OperatingSystem this$operatingSystem = this.getOperatingSystem();
        OperatingSystem other$operatingSystem = other.getOperatingSystem();
        if (this$operatingSystem == null ? other$operatingSystem != null : !((Object)((Object)this$operatingSystem)).equals((Object)other$operatingSystem)) {
            return false;
        }
        String this$javaVersionNumber = this.getJavaVersionNumber();
        String other$javaVersionNumber = other.getJavaVersionNumber();
        return !(this$javaVersionNumber == null ? other$javaVersionNumber != null : !this$javaVersionNumber.equals(other$javaVersionNumber));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunctionAppWindowsRuntime;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OperatingSystem $operatingSystem = this.getOperatingSystem();
        result = result * 59 + ($operatingSystem == null ? 43 : ((Object)((Object)$operatingSystem)).hashCode());
        String $javaVersionNumber = this.getJavaVersionNumber();
        result = result * 59 + ($javaVersionNumber == null ? 43 : $javaVersionNumber.hashCode());
        return result;
    }
}

