/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlot;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlotBasic;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlots;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceResourceModule;
import com.microsoft.azure.toolkit.lib.appservice.IDeploymentSlotModule;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlotDraft;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FunctionAppDeploymentSlotModule
extends AppServiceResourceModule<FunctionAppDeploymentSlot, FunctionApp, FunctionDeploymentSlot>
implements IDeploymentSlotModule<FunctionAppDeploymentSlot, FunctionApp, FunctionDeploymentSlot> {
    public static final String NAME = "slots";

    public FunctionAppDeploymentSlotModule(@Nonnull FunctionApp parent) {
        super(NAME, parent);
    }

    public FunctionDeploymentSlots getClient() {
        return Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)((FunctionApp)this.parent).getRemote()).map(com.azure.resourcemanager.appservice.models.FunctionApp::deploymentSlots).orElse(null);
    }

    @Nonnull
    protected FunctionAppDeploymentSlotDraft newDraftForCreate(@Nonnull String name, @Nullable String resourceGroupName) {
        return new FunctionAppDeploymentSlotDraft(name, this);
    }

    @Nonnull
    protected FunctionAppDeploymentSlotDraft newDraftForUpdate(@Nonnull FunctionAppDeploymentSlot origin) {
        return new FunctionAppDeploymentSlotDraft(origin);
    }

    @Nonnull
    protected FunctionAppDeploymentSlot newResource(@Nonnull FunctionDeploymentSlot remote) {
        return new FunctionAppDeploymentSlot((FunctionDeploymentSlotBasic)remote, this);
    }

    @Nonnull
    protected FunctionAppDeploymentSlot newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new FunctionAppDeploymentSlot(name, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Deployment slot";
    }

    @Override
    protected List<String> loadResourceIdsFromAzure() {
        return Optional.ofNullable(this.getClient()).map(client -> client.list().stream().map(HasId::id).collect(Collectors.toList())).orElse(Collections.emptyList());
    }
}

