/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebAppsClient;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SitePatchResourceInner;
import com.azure.resourcemanager.appservice.models.DeploymentSlotBase;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlotModule;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.FlexConsumptionConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionAppDeploymentSlotDraft
extends FunctionAppDeploymentSlot
implements AzResource.Draft<FunctionAppDeploymentSlot, FunctionDeploymentSlot> {
    private static final Logger log;
    private static final String CREATE_NEW_DEPLOYMENT_SLOT = "createNewDeploymentSlot";
    public static final String CONFIGURATION_SOURCE_NEW = "new";
    public static final String CONFIGURATION_SOURCE_PARENT = "parent";
    private static final String CONFIGURATION_SOURCE_DOES_NOT_EXISTS = "Target slot configuration source does not exists in current app";
    private static final String FAILED_TO_GET_CONFIGURATION_SOURCE = "Failed to get configuration source slot";
    @Nullable
    private final FunctionAppDeploymentSlot origin;
    @Nullable
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    protected FunctionAppDeploymentSlotDraft(@Nonnull String name, @Nonnull FunctionAppDeploymentSlotModule module) {
        super(name, module);
        this.origin = null;
    }

    protected FunctionAppDeploymentSlotDraft(@Nonnull FunctionAppDeploymentSlot origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.config = null;
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    @Nonnull
    @AzureOperation(name="azure/function.create_deployment_slot.slot", params={"this.getName()"})
    public FunctionDeploymentSlot createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            boolean updateFlexConsumptionConfiguration;
            FunctionDeploymentSlot.DefinitionStages.WithCreate withCreate;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Runtime.tryWarningDeprecation(this);
            OperationContext.action().setTelemetryProperty(CREATE_NEW_DEPLOYMENT_SLOT, String.valueOf(true));
            OperationContext.action().setTelemetryProperty("subscriptionId", this.getSubscriptionId());
            Optional.ofNullable(this.getRegion()).ifPresent(region -> OperationContext.action().setTelemetryProperty("region", region.getLabel()));
            Optional.ofNullable(this.getRuntime()).ifPresent(runtime -> OperationContext.action().setTelemetryProperty("runtime", runtime.getDisplayName()));
            Optional.ofNullable(this.getRuntime()).map(Runtime::getOperatingSystem).ifPresent(os -> OperationContext.action().setTelemetryProperty("os", os.getValue()));
            Optional.ofNullable(this.getRuntime()).map(Runtime::getJavaVersionUserText).ifPresent(javaVersion -> OperationContext.action().setTelemetryProperty("javaVersion", javaVersion));
            String name = this.getName();
            Map<String, String> newAppSettings = this.getAppSettings();
            DiagnosticConfig newDiagnosticConfig = this.getDiagnosticConfig();
            String newConfigurationSource = this.getConfigurationSource();
            FlexConsumptionConfiguration newFlexConsumptionConfiguration = this.getFlexConsumptionConfiguration();
            String source = StringUtils.isBlank((CharSequence)newConfigurationSource) ? CONFIGURATION_SOURCE_PARENT : StringUtils.lowerCase((String)newConfigurationSource);
            com.azure.resourcemanager.appservice.models.FunctionApp functionApp = Objects.requireNonNull((com.azure.resourcemanager.appservice.models.FunctionApp)((FunctionApp)this.getParent()).getRemote());
            FunctionDeploymentSlot.DefinitionStages.Blank blank = (FunctionDeploymentSlot.DefinitionStages.Blank)functionApp.deploymentSlots().define(this.getName());
            if (CONFIGURATION_SOURCE_NEW.equals(source)) {
                withCreate = blank.withBrandNewConfiguration();
            } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)source, (CharSequence[])new CharSequence[]{CONFIGURATION_SOURCE_PARENT, ((FunctionApp)this.getParent()).getName()})) {
                withCreate = blank.withConfigurationFromParent();
            } else {
                try {
                    FunctionDeploymentSlot sourceSlot = (FunctionDeploymentSlot)functionApp.deploymentSlots().getByName(newConfigurationSource);
                    Objects.requireNonNull(sourceSlot, CONFIGURATION_SOURCE_DOES_NOT_EXISTS);
                    withCreate = blank.withConfigurationFromDeploymentSlot(sourceSlot);
                }
                catch (ManagementException e) {
                    throw new AzureToolkitRuntimeException(FAILED_TO_GET_CONFIGURATION_SOURCE, (Throwable)e);
                }
            }
            if (MapUtils.isNotEmpty(newAppSettings)) {
                withCreate.withAppSettings(newAppSettings);
            }
            if (Objects.nonNull(newDiagnosticConfig)) {
                AppServiceUtils.defineDiagnosticConfigurationForWebAppBase(withCreate, newDiagnosticConfig);
            }
            boolean bl = updateFlexConsumptionConfiguration = Objects.nonNull(newFlexConsumptionConfiguration) && Objects.requireNonNull(((FunctionApp)this.getParent()).getAppServicePlan()).getPricingTier().isFlexConsumption();
            if (updateFlexConsumptionConfiguration) {
                ((SiteInner)((com.azure.resourcemanager.appservice.models.FunctionApp)withCreate).innerModel()).withContainerSize(newFlexConsumptionConfiguration.getInstanceSize());
            }
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating Function App deployment slot ({0})...", (Object[])new Object[]{name}));
            Consumer<Throwable> throwableConsumer = arg_0 -> ((IAzureMessager)messager).error(arg_0);
            Context context = new Context((Object)"reactor.onErrorDropped.local", throwableConsumer);
            FunctionDeploymentSlot slot = Objects.requireNonNull((FunctionDeploymentSlot)this.doModify(() -> {
                FunctionDeploymentSlot functionDeploymentSlot = (FunctionDeploymentSlot)withCreate.create(context);
                if (updateFlexConsumptionConfiguration) {
                    FunctionAppDeploymentSlotDraft.updateFlexConsumptionConfiguration(functionDeploymentSlot, newFlexConsumptionConfiguration);
                }
                return functionDeploymentSlot;
            }, "Creating"));
            FunctionAppRuntime runtime2 = this.getRuntime();
            boolean isRuntimeModified = Objects.nonNull(runtime2) && !Objects.equals(runtime2, ((FunctionApp)this.getParent()).getRuntime()) || Objects.nonNull(this.getDockerConfiguration());
            this.ensureConfig().setAppSettings(null);
            this.ensureConfig().setDiagnosticConfig(null);
            if (isRuntimeModified) {
                slot = this.updateResourceInAzure(slot);
            }
            if (this.isRemoteDebugEnabled() && CONFIGURATION_SOURCE_PARENT.equals(source)) {
                this.disableRemoteDebug();
            }
            messager.success(AzureString.format((String)"Function App deployment slot ({0}) is successfully created", (Object[])new Object[]{name}));
            FunctionDeploymentSlot functionDeploymentSlot = slot;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return functionDeploymentSlot;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/function.update_deployment_slot.slot", params={"this.getName()"})
    public FunctionDeploymentSlot updateResourceInAzure(@Nonnull FunctionDeploymentSlot remote) {
        FunctionDeploymentSlot functionDeploymentSlot = remote;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)functionDeploymentSlot);
        try {
            boolean modified;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Runtime.tryWarningDeprecation(this);
            Map<String, String> oldAppSettings = Utils.normalizeAppSettings(remote.getAppSettings());
            Map<String, String> settingsToAdd = this.ensureConfig().getAppSettings();
            if (ObjectUtils.allNotNull((Object[])new Object[]{oldAppSettings, settingsToAdd})) {
                settingsToAdd.entrySet().removeAll(oldAppSettings.entrySet());
            }
            Set settingsToRemove = Optional.ofNullable(this.ensureConfig().getAppSettingsToRemove()).map(set -> set.stream().filter(oldAppSettings::containsKey).collect(Collectors.toSet())).orElse(Collections.emptySet());
            FunctionAppRuntime newRuntime = this.ensureConfig().getRuntime();
            DockerConfiguration newDockerConfig = this.ensureConfig().getDockerConfiguration();
            DiagnosticConfig oldDiagnosticConfig = super.getDiagnosticConfig();
            DiagnosticConfig newDiagnosticConfig = this.ensureConfig().getDiagnosticConfig();
            FlexConsumptionConfiguration newFlexConsumptionConfiguration = this.ensureConfig().getFlexConsumptionConfiguration();
            FlexConsumptionConfiguration oldFlexConsumptionConfiguration = super.getFlexConsumptionConfiguration();
            FunctionAppRuntime oldRuntime = super.getRuntime();
            boolean isRuntimeModified = (Objects.isNull(oldRuntime) || !oldRuntime.isDocker()) && Objects.nonNull(newRuntime) && !Objects.equals(newRuntime, oldRuntime);
            boolean isDockerConfigurationModified = Objects.nonNull(oldRuntime) && oldRuntime.isDocker() && Objects.nonNull(newDockerConfig);
            boolean isAppSettingsModified = MapUtils.isNotEmpty(settingsToAdd) || CollectionUtils.isNotEmpty(settingsToRemove);
            boolean isDiagnosticConfigModified = Objects.nonNull(newDiagnosticConfig) && !Objects.equals(newDiagnosticConfig, oldDiagnosticConfig);
            boolean flexConsumptionModified = ((FunctionApp)this.getParent()).getAppServicePlan().getPricingTier().isFlexConsumption() && Objects.nonNull(newFlexConsumptionConfiguration) && !Objects.equals(newFlexConsumptionConfiguration, oldFlexConsumptionConfiguration);
            boolean bl = modified = isDiagnosticConfigModified || isAppSettingsModified || isRuntimeModified || isDockerConfigurationModified || flexConsumptionModified;
            if (modified) {
                DeploymentSlotBase.Update update = (DeploymentSlotBase.Update)remote.update();
                Optional.ofNullable(settingsToAdd).filter(ignore -> isAppSettingsModified).ifPresent(arg_0 -> ((DeploymentSlotBase.Update)update).withAppSettings(arg_0));
                Optional.ofNullable(settingsToRemove).filter(ignore -> isAppSettingsModified).ifPresent(s -> s.forEach(arg_0 -> ((DeploymentSlotBase.Update)update).withoutAppSetting(arg_0)));
                Optional.ofNullable(newRuntime).filter(ignore -> isRuntimeModified).ifPresent(r -> this.updateRuntime((DeploymentSlotBase.Update<?>)update, (Runtime)r));
                Optional.ofNullable(newDockerConfig).filter(ignore -> isDockerConfigurationModified).ifPresent(dockerConfiguration -> this.updateDockerConfiguration((DeploymentSlotBase.Update<?>)update, (DockerConfiguration)dockerConfiguration));
                Optional.ofNullable(newDiagnosticConfig).filter(ignore -> isDiagnosticConfigModified).ifPresent(diagnosticConfig -> AppServiceUtils.updateDiagnosticConfigurationForWebAppBase(update, diagnosticConfig));
                IAzureMessager messager = AzureMessager.getMessager();
                messager.info(AzureString.format((String)"Start updating Function App deployment slot({0})...", (Object[])new Object[]{remote.name()}));
                remote = (FunctionDeploymentSlot)update.apply();
                if (flexConsumptionModified) {
                    FunctionAppDeploymentSlotDraft.updateFlexConsumptionConfiguration(remote, newFlexConsumptionConfiguration);
                }
                messager.success(AzureString.format((String)"Function app deployment slot({0}) is successfully updated", (Object[])new Object[]{remote.name()}));
            }
            FunctionDeploymentSlot functionDeploymentSlot2 = remote;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return functionDeploymentSlot2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void updateRuntime(@Nonnull DeploymentSlotBase.Update<?> update, @Nonnull Runtime newRuntime) {
        Optional<OperatingSystem> oldOp = Optional.ofNullable(super.getRuntime()).map(Runtime::getOperatingSystem);
        if (newRuntime.getOperatingSystem() != null && oldOp.filter(r -> r != newRuntime.getOperatingSystem()).isPresent()) {
            throw new AzureToolkitRuntimeException("Can not update the operation system of an existing app");
        }
        OperatingSystem operatingSystem = (OperatingSystem)((Object)ObjectUtils.firstNonNull((Object[])new OperatingSystem[]{newRuntime.getOperatingSystem(), oldOp.orElse(null)}));
        if (operatingSystem == OperatingSystem.LINUX) {
            AzureMessager.getMessager().warning("Update runtime is not supported for Linux app service");
        } else if (operatingSystem == OperatingSystem.WINDOWS) {
            update.withJavaVersion(newRuntime.getJavaVersion()).withWebContainer(null);
        } else {
            if (operatingSystem == OperatingSystem.DOCKER) {
                return;
            }
            throw new AzureToolkitRuntimeException(String.format("Unsupported operating system %s", new Object[]{newRuntime.getOperatingSystem()}));
        }
    }

    private void updateDockerConfiguration(@Nonnull DeploymentSlotBase.Update<?> update, @Nonnull DockerConfiguration newConfig) {
        DeploymentSlotBase.Update draft = StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{newConfig.getUserName(), newConfig.getPassword()}) ? update.withPublicDockerHubImage(newConfig.getImage()) : (StringUtils.isEmpty((CharSequence)newConfig.getRegistryUrl()) ? update.withPrivateDockerHubImage(newConfig.getImage()).withCredentials(newConfig.getUserName(), newConfig.getPassword()) : update.withPrivateRegistryImage(newConfig.getImage(), newConfig.getRegistryUrl()).withCredentials(newConfig.getUserName(), newConfig.getPassword()));
        draft.withStartUpCommand(newConfig.getStartUpCommand());
    }

    public void setConfigurationSource(String source) {
        this.ensureConfig().setConfigurationSource(source);
    }

    @Nullable
    public String getConfigurationSource() {
        return Optional.ofNullable(this.config).map(Config::getConfigurationSource).orElse(null);
    }

    public void setAppSettings(Map<String, String> appSettings) {
        this.ensureConfig().setAppSettings(appSettings);
    }

    public void removeAppSettings(Set<String> keys) {
        this.ensureConfig().getAppSettingsToRemove().addAll((Collection)ObjectUtils.firstNonNull((Object[])new Set[]{keys, Collections.emptySet()}));
    }

    @Override
    @Nullable
    public Map<String, String> getAppSettings() {
        return Optional.ofNullable(this.config).map(Config::getAppSettings).orElseGet(() -> super.getAppSettings());
    }

    public void removeAppSetting(String key) {
        this.ensureConfig().getAppSettingsToRemove().add(key);
    }

    @Nullable
    public Set<String> getAppSettingsToRemove() {
        return Optional.ofNullable(this.config).map(Config::getAppSettingsToRemove).orElse(new HashSet());
    }

    public void setDiagnosticConfig(DiagnosticConfig config) {
        this.ensureConfig().setDiagnosticConfig(config);
    }

    @Override
    @Nullable
    public DiagnosticConfig getDiagnosticConfig() {
        return Optional.ofNullable(this.config).map(Config::getDiagnosticConfig).orElseGet(() -> super.getDiagnosticConfig());
    }

    @Override
    @Nullable
    public FunctionAppRuntime getRuntime() {
        return Optional.ofNullable(this.config).map(Config::getRuntime).orElseGet(() -> super.getRuntime());
    }

    public void setRuntime(FunctionAppRuntime runtime) {
        this.ensureConfig().setRuntime(runtime);
    }

    public void setDockerConfiguration(DockerConfiguration dockerConfiguration) {
        this.ensureConfig().setDockerConfiguration(dockerConfiguration);
    }

    @Nullable
    public DockerConfiguration getDockerConfiguration() {
        return Optional.ofNullable(this.config).map(Config::getDockerConfiguration).orElse(null);
    }

    public void setFlexConsumptionConfiguration(FlexConsumptionConfiguration flexConsumptionConfiguration) {
        this.ensureConfig().setFlexConsumptionConfiguration(flexConsumptionConfiguration);
    }

    @Override
    @Nullable
    public FlexConsumptionConfiguration getFlexConsumptionConfiguration() {
        return Optional.ofNullable(this.config).map(Config::getFlexConsumptionConfiguration).orElseGet(() -> super.getFlexConsumptionConfiguration());
    }

    public boolean isModified() {
        boolean notModified = Objects.isNull(this.config) || StringUtils.isBlank((CharSequence)this.config.getConfigurationSource()) && CollectionUtils.isEmpty(this.config.getAppSettingsToRemove()) && Objects.isNull(this.getDockerConfiguration()) && Objects.equals(this.getDiagnosticConfig(), super.getDiagnosticConfig()) && Objects.equals(this.getAppSettings(), super.getAppSettings()) && Objects.equals(this.getRuntime(), super.getRuntime()) && Objects.equals(this.getFlexConsumptionConfiguration(), super.getFlexConsumptionConfiguration());
        return !notModified;
    }

    private static void updateFlexConsumptionConfiguration(FunctionDeploymentSlot slot, FlexConsumptionConfiguration flexConfiguration) {
        String name = String.format("%s/slots/%s", ((com.azure.resourcemanager.appservice.models.FunctionApp)slot.parent()).name(), slot.name());
        WebAppsClient webApps = ((WebSiteManagementClient)((AppServiceManager)slot.manager()).serviceClient()).getWebApps();
        if (ObjectUtils.anyNotNull((Object[])new Object[]{flexConfiguration.getMaximumInstances(), flexConfiguration.getAlwaysReadyInstances()})) {
            SiteConfigResourceInner configuration = webApps.getConfiguration(slot.resourceGroupName(), name);
            if (!Objects.equals(flexConfiguration.getMaximumInstances(), configuration.functionAppScaleLimit()) || !Objects.equals(flexConfiguration.getAlwaysReadyInstances(), configuration.minimumElasticInstanceCount())) {
                configuration.withFunctionAppScaleLimit(flexConfiguration.getMaximumInstances());
                webApps.updateConfiguration(slot.resourceGroupName(), name, configuration);
            }
        }
        if (!Objects.equals(((SiteInner)slot.innerModel()).containerSize(), flexConfiguration.getInstanceSize())) {
            webApps.updateWithResponseAsync(slot.resourceGroupName(), name, new SitePatchResourceInner().withContainerSize(flexConfiguration.getInstanceSize())).block();
        }
    }

    @Nullable
    public FunctionAppDeploymentSlot getOrigin() {
        return this.origin;
    }

    static {
        FunctionAppDeploymentSlotDraft.ajc$preClinit();
        log = LoggerFactory.getLogger(FunctionAppDeploymentSlotDraft.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FunctionAppDeploymentSlotDraft.java", FunctionAppDeploymentSlotDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlotDraft", "", "", "", "com.azure.resourcemanager.appservice.models.FunctionDeploymentSlot"), 93);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlotDraft", "com.azure.resourcemanager.appservice.models.FunctionDeploymentSlot", "remote", "", "com.azure.resourcemanager.appservice.models.FunctionDeploymentSlot"), 169);
    }

    @Nullable
    private static class Config {
        private FunctionAppRuntime runtime;
        private DockerConfiguration dockerConfiguration;
        private String configurationSource;
        private DiagnosticConfig diagnosticConfig = null;
        private Set<String> appSettingsToRemove = new HashSet<String>();
        private Map<String, String> appSettings = null;
        private FlexConsumptionConfiguration flexConsumptionConfiguration;

        public FunctionAppRuntime getRuntime() {
            return this.runtime;
        }

        public DockerConfiguration getDockerConfiguration() {
            return this.dockerConfiguration;
        }

        public String getConfigurationSource() {
            return this.configurationSource;
        }

        public DiagnosticConfig getDiagnosticConfig() {
            return this.diagnosticConfig;
        }

        public Set<String> getAppSettingsToRemove() {
            return this.appSettingsToRemove;
        }

        public Map<String, String> getAppSettings() {
            return this.appSettings;
        }

        public FlexConsumptionConfiguration getFlexConsumptionConfiguration() {
            return this.flexConsumptionConfiguration;
        }

        public void setRuntime(FunctionAppRuntime runtime) {
            this.runtime = runtime;
        }

        public void setDockerConfiguration(DockerConfiguration dockerConfiguration) {
            this.dockerConfiguration = dockerConfiguration;
        }

        public void setConfigurationSource(String configurationSource) {
            this.configurationSource = configurationSource;
        }

        public void setDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
            this.diagnosticConfig = diagnosticConfig;
        }

        public void setAppSettingsToRemove(Set<String> appSettingsToRemove) {
            this.appSettingsToRemove = appSettingsToRemove;
        }

        public void setAppSettings(Map<String, String> appSettings) {
            this.appSettings = appSettings;
        }

        public void setFlexConsumptionConfiguration(FlexConsumptionConfiguration flexConsumptionConfiguration) {
            this.flexConsumptionConfiguration = flexConsumptionConfiguration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FunctionAppRuntime this$runtime = this.getRuntime();
            FunctionAppRuntime other$runtime = other.getRuntime();
            if (this$runtime == null ? other$runtime != null : !this$runtime.equals(other$runtime)) {
                return false;
            }
            DockerConfiguration this$dockerConfiguration = this.getDockerConfiguration();
            DockerConfiguration other$dockerConfiguration = other.getDockerConfiguration();
            if (this$dockerConfiguration == null ? other$dockerConfiguration != null : !((Object)this$dockerConfiguration).equals(other$dockerConfiguration)) {
                return false;
            }
            String this$configurationSource = this.getConfigurationSource();
            String other$configurationSource = other.getConfigurationSource();
            if (this$configurationSource == null ? other$configurationSource != null : !this$configurationSource.equals(other$configurationSource)) {
                return false;
            }
            DiagnosticConfig this$diagnosticConfig = this.getDiagnosticConfig();
            DiagnosticConfig other$diagnosticConfig = other.getDiagnosticConfig();
            if (this$diagnosticConfig == null ? other$diagnosticConfig != null : !((Object)this$diagnosticConfig).equals(other$diagnosticConfig)) {
                return false;
            }
            Set<String> this$appSettingsToRemove = this.getAppSettingsToRemove();
            Set<String> other$appSettingsToRemove = other.getAppSettingsToRemove();
            if (this$appSettingsToRemove == null ? other$appSettingsToRemove != null : !((Object)this$appSettingsToRemove).equals(other$appSettingsToRemove)) {
                return false;
            }
            Map<String, String> this$appSettings = this.getAppSettings();
            Map<String, String> other$appSettings = other.getAppSettings();
            if (this$appSettings == null ? other$appSettings != null : !((Object)this$appSettings).equals(other$appSettings)) {
                return false;
            }
            FlexConsumptionConfiguration this$flexConsumptionConfiguration = this.getFlexConsumptionConfiguration();
            FlexConsumptionConfiguration other$flexConsumptionConfiguration = other.getFlexConsumptionConfiguration();
            return !(this$flexConsumptionConfiguration == null ? other$flexConsumptionConfiguration != null : !((Object)this$flexConsumptionConfiguration).equals(other$flexConsumptionConfiguration));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FunctionAppRuntime $runtime = this.getRuntime();
            result = result * 59 + ($runtime == null ? 43 : $runtime.hashCode());
            DockerConfiguration $dockerConfiguration = this.getDockerConfiguration();
            result = result * 59 + ($dockerConfiguration == null ? 43 : ((Object)$dockerConfiguration).hashCode());
            String $configurationSource = this.getConfigurationSource();
            result = result * 59 + ($configurationSource == null ? 43 : $configurationSource.hashCode());
            DiagnosticConfig $diagnosticConfig = this.getDiagnosticConfig();
            result = result * 59 + ($diagnosticConfig == null ? 43 : ((Object)$diagnosticConfig).hashCode());
            Set<String> $appSettingsToRemove = this.getAppSettingsToRemove();
            result = result * 59 + ($appSettingsToRemove == null ? 43 : ((Object)$appSettingsToRemove).hashCode());
            Map<String, String> $appSettings = this.getAppSettings();
            result = result * 59 + ($appSettings == null ? 43 : ((Object)$appSettings).hashCode());
            FlexConsumptionConfiguration $flexConsumptionConfiguration = this.getFlexConsumptionConfiguration();
            result = result * 59 + ($flexConsumptionConfiguration == null ? 43 : ((Object)$flexConsumptionConfiguration).hashCode());
            return result;
        }

        public String toString() {
            return "FunctionAppDeploymentSlotDraft.Config(runtime=" + this.getRuntime() + ", dockerConfiguration=" + this.getDockerConfiguration() + ", configurationSource=" + this.getConfigurationSource() + ", diagnosticConfig=" + this.getDiagnosticConfig() + ", appSettingsToRemove=" + this.getAppSettingsToRemove() + ", appSettings=" + this.getAppSettings() + ", flexConsumptionConfiguration=" + this.getFlexConsumptionConfiguration() + ")";
        }
    }
}

