/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.models.JavaVersion;
import com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.azure.resourcemanager.appservice.models.PlatformArchitecture;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.deploy.FTPFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.deploy.FlexFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.deploy.IFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.deploy.MSFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.deploy.RunFromBlobFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.deploy.RunFromZipFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.deploy.ZIPFunctionDeployHandler;
import com.microsoft.azure.toolkit.lib.appservice.file.AzureFunctionsAdminClient;
import com.microsoft.azure.toolkit.lib.appservice.file.IFileClient;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.FlexConsumptionConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppDockerRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppLinuxRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppWindowsRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionDeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Mono;

public abstract class FunctionAppBase<T extends FunctionAppBase<T, P, F>, P extends AbstractAzResource<P, ?, ?>, F extends WebAppBase>
extends AppServiceAppBase<T, P, F> {
    private static final String FUNCTION_DEPLOY_TYPE = "functionDeployType";
    public static final String JAVA_OPTS = "JAVA_OPTS";
    public static final String HTTP_PLATFORM_DEBUG_PORT = "HTTP_PLATFORM_DEBUG_PORT";
    public static final String PREFER_IPV_4_STACK_TRUE = "-Djava.net.preferIPv4Stack=true";
    public static final String XDEBUG = "-Xdebug";
    public static final String XRUNJDWP = "-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=127.0.0.1:%s";
    public static final String DEFAULT_REMOTE_DEBUG_PORT = "8898";
    public static final String DEFAULT_REMOTE_DEBUG_JAVA_OPTS = "-Djava.net.preferIPv4Stack=true -Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=127.0.0.1:%s";
    private Boolean isEnableRemoteDebugging = null;
    private AzureFunctionsAdminClient fileClient;

    protected FunctionAppBase(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull AbstractAzResourceModule<T, P, F> module) {
        super(name, resourceGroupName, module);
    }

    protected FunctionAppBase(@Nonnull String name, @Nonnull AbstractAzResourceModule<T, P, F> module) {
        super(name, module);
    }

    protected FunctionAppBase(@Nonnull T origin) {
        super(origin);
    }

    public void deploy(File targetFile) {
        this.deploy(targetFile, this.getDefaultDeployType());
    }

    public void deploy(File targetFile, FunctionDeployType functionDeployType) {
        OperationContext.action().setTelemetryProperty(FUNCTION_DEPLOY_TYPE, functionDeployType.name());
        this.getDeployHandlerByType(functionDeployType).deploy(targetFile, this);
    }

    public AzureFunctionsAdminClient getAdminClient() {
        if (this.fileClient == null) {
            this.fileClient = Optional.ofNullable((WebAppBase)this.getRemote()).map(r -> AzureFunctionsAdminClient.getClient(r, this)).orElse(null);
        }
        return this.fileClient;
    }

    @Override
    public FunctionAppRuntime getRuntime() {
        return Optional.ofNullable((WebAppBase)this.getRemote()).map(r -> {
            if (r.operatingSystem() == OperatingSystem.WINDOWS) {
                JavaVersion javaVersion = r.javaVersion();
                return FunctionAppWindowsRuntime.fromJavaVersion(javaVersion);
            }
            String fxString = r.linuxFxVersion();
            if (StringUtils.isEmpty((CharSequence)fxString)) {
                boolean isFlexConsumption = Optional.ofNullable(this.getAppServicePlan()).map(AppServicePlan::getPricingTier).map(PricingTier::isFlexConsumption).orElse(false);
                return isFlexConsumption ? this.getFlexConsumptionRuntime() : null;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)fxString, (CharSequence)"docker")) {
                return FunctionAppDockerRuntime.INSTANCE;
            }
            return FunctionAppLinuxRuntime.fromFxString(fxString);
        }).orElse(null);
    }

    private FunctionAppRuntime getFlexConsumptionRuntime() {
        FunctionAppConfig config = this.getFlexConsumptionAppConfig();
        return Optional.ofNullable(config).map(FunctionAppConfig::getRuntime).map(FunctionAppConfig.FunctionsRuntime::getVersion).map(FunctionAppLinuxRuntime::fromJavaVersionUserText).orElse(null);
    }

    @Override
    @Nullable
    protected IFileClient getFileClient() {
        boolean isLinuxJavaFunction = Optional.ofNullable(this.getRuntime()).map(Runtime::isLinux).orElse(false);
        boolean isConsumption = Optional.ofNullable(this.getAppServicePlan()).map(AppServicePlan::getPricingTier).map(pricingTier -> pricingTier.isConsumption() || pricingTier.isFlexConsumption()).orElse(false);
        return isLinuxJavaFunction && isConsumption ? this.getAdminClient() : super.getFileClient();
    }

    protected FunctionDeployType getDefaultDeployType() {
        PricingTier pricingTier = Optional.ofNullable(this.getAppServicePlan()).map(AppServicePlan::getPricingTier).orElse(PricingTier.PREMIUM_P1V2);
        com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem os = Optional.ofNullable(this.getRuntime()).map(Runtime::getOperatingSystem).orElse(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.LINUX);
        if (pricingTier.isFlexConsumption()) {
            return FunctionDeployType.FLEX;
        }
        if (os == com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.WINDOWS) {
            return FunctionDeployType.RUN_FROM_ZIP;
        }
        return StringUtils.equalsAnyIgnoreCase((CharSequence)pricingTier.getTier(), (CharSequence[])new CharSequence[]{"Dynamic", "ElasticPremium"}) ? FunctionDeployType.RUN_FROM_BLOB : FunctionDeployType.RUN_FROM_ZIP;
    }

    protected IFunctionDeployHandler getDeployHandlerByType(FunctionDeployType deployType) {
        switch (deployType) {
            case FLEX: {
                return new FlexFunctionDeployHandler();
            }
            case FTP: {
                return new FTPFunctionDeployHandler();
            }
            case ZIP: {
                return new ZIPFunctionDeployHandler();
            }
            case MSDEPLOY: {
                return new MSFunctionDeployHandler();
            }
            case RUN_FROM_ZIP: {
                return new RunFromZipFunctionDeployHandler();
            }
            case RUN_FROM_BLOB: {
                return new RunFromBlobFunctionDeployHandler();
            }
        }
        throw new AzureToolkitRuntimeException("Unsupported deployment type");
    }

    public abstract String getMasterKey();

    public boolean isRemoteDebugEnabled() {
        if (this.isEnableRemoteDebugging == null) {
            this.isEnableRemoteDebugging = this.getIsRemoteDebuggingEnabled();
        }
        return this.isEnableRemoteDebugging;
    }

    public abstract void enableRemoteDebug();

    public abstract void disableRemoteDebug();

    public void ping() {
        this.getAdminClient().ping();
    }

    protected String getRemoteDebugPort() {
        return DEFAULT_REMOTE_DEBUG_PORT;
    }

    public String getJavaOptsWithRemoteDebugDisabled(Map<String, String> appSettings) {
        String javaOpts = appSettings.get(JAVA_OPTS);
        if (StringUtils.isEmpty((CharSequence)javaOpts)) {
            return String.format("", new Object[0]);
        }
        return Arrays.stream(javaOpts.split(" ")).filter(opts -> !StringUtils.containsAnyIgnoreCase((CharSequence)opts, (CharSequence[])new CharSequence[]{PREFER_IPV_4_STACK_TRUE, XDEBUG, "-Xrunjdwp"})).collect(Collectors.joining(" "));
    }

    public String getJavaOptsWithRemoteDebugEnabled(Map<String, String> appSettings, String debugPort) {
        String javaOpts = appSettings.get(JAVA_OPTS);
        if (StringUtils.isEmpty((CharSequence)javaOpts)) {
            return String.format(DEFAULT_REMOTE_DEBUG_JAVA_OPTS, debugPort);
        }
        ArrayList<String> jvmOptions = new ArrayList<String>(Arrays.asList(javaOpts.split(" ")));
        String jdwp = String.format(XRUNJDWP, debugPort);
        for (String configuration : Arrays.asList(PREFER_IPV_4_STACK_TRUE, XDEBUG, jdwp)) {
            if (jvmOptions.contains(configuration)) continue;
            jvmOptions.add(configuration);
        }
        return String.join((CharSequence)" ", jvmOptions);
    }

    public FunctionAppConfig getFlexConsumptionAppConfig() {
        return Optional.ofNullable((WebAppBase)this.getRemote()).map(this::getFlexConfigFromRemote).orElse(null);
    }

    protected FunctionAppConfig getFlexConfigFromRemote(@Nonnull WebAppBase remote) {
        FunctionAppConfig functionAppConfig;
        block8: {
            HttpPipeline httpPipeline = ((AppServiceManager)remote.manager()).httpPipeline();
            String targetUrl = this.getRawRequestEndpoint(remote);
            HttpRequest request = new HttpRequest(HttpMethod.GET, targetUrl).setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
            HttpResponse block = (HttpResponse)httpPipeline.send(request).block();
            try {
                String content = Optional.ofNullable(block).map(HttpResponse::getBodyAsString).map(Mono::block).orElse("");
                SerializerAdapter adapter = SerializerFactory.createDefaultManagementSerializerAdapter();
                ObjectNode functionNode = (ObjectNode)adapter.deserialize(content, ObjectNode.class, SerializerEncoding.JSON);
                JsonNode configNode = Optional.ofNullable(functionNode.get("properties")).map(propertiesNode -> propertiesNode.get("functionAppConfig")).orElse(null);
                FunctionAppConfig functionAppConfig2 = functionAppConfig = Objects.isNull(configNode) ? null : (FunctionAppConfig)adapter.deserialize(configNode.toPrettyString(), FunctionAppConfig.class, SerializerEncoding.JSON);
                if (block == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (block != null) {
                        try {
                            block.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return null;
                }
            }
            block.close();
        }
        return functionAppConfig;
    }

    public String getRawRequestEndpoint(@Nonnull WebAppBase functionApp) {
        AppServiceManager manager = (AppServiceManager)functionApp.manager();
        WebSiteManagementClient client = (WebSiteManagementClient)manager.serviceClient();
        String endpoint = client.getEndpoint();
        String apiVersion = "2023-12-01";
        String subscriptionId = client.getSubscriptionId();
        return endpoint + String.format("subscriptions/%s/resourceGroups/%s/providers/Microsoft.Web/sites/%s?api-version=%s", subscriptionId, functionApp.resourceGroupName(), functionApp.name(), "2023-12-01");
    }

    @Nullable
    public FlexConsumptionConfiguration getFlexConsumptionConfiguration() {
        return FlexConsumptionConfiguration.fromFunctionAppBase(this);
    }

    protected void updateAdditionalProperties(@Nullable F newRemote, @Nullable F oldRemote) {
        super.updateAdditionalProperties(newRemote, oldRemote);
        this.isEnableRemoteDebugging = Objects.nonNull(newRemote) ? Boolean.valueOf(this.getIsRemoteDebuggingEnabled()) : null;
    }

    private boolean getIsRemoteDebuggingEnabled() {
        WebAppBase remote = (WebAppBase)this.getRemote();
        if (Objects.isNull(remote)) {
            return false;
        }
        Map<String, String> appSettings = Optional.ofNullable(this.getAppSettings()).orElse(Collections.emptyMap());
        boolean configEnabled = remote.webSocketsEnabled() && remote.platformArchitecture() == PlatformArchitecture.X64;
        boolean appSettingsEnabled = appSettings.containsKey(HTTP_PLATFORM_DEBUG_PORT) && StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)appSettings.get(JAVA_OPTS)), (CharSequence)this.getJavaOptsWithRemoteDebugEnabled(appSettings, (String)appSettings.get(HTTP_PLATFORM_DEBUG_PORT)));
        return configEnabled && appSettingsEnabled;
    }

    @Override
    public boolean isStreamingLogSupported() {
        com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem operatingSystem = Optional.ofNullable(this.getRuntime()).map(Runtime::getOperatingSystem).orElse(null);
        boolean isEnableApplicationLog = Optional.ofNullable(this.getDiagnosticConfig()).map(DiagnosticConfig::isEnableApplicationLog).orElse(false);
        return operatingSystem != com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.LINUX && isEnableApplicationLog;
    }
}

