/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.FunctionAppBasic;
import com.azure.resourcemanager.appservice.models.PlatformArchitecture;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionEntity;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlotModule;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppModule;
import com.microsoft.azure.toolkit.lib.appservice.model.ContainerAppFunctionConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerApps;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerAppsServiceSubscription;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public class FunctionApp
extends FunctionAppBase<FunctionApp, AppServiceServiceSubscription, com.azure.resourcemanager.appservice.models.FunctionApp>
implements Deletable {
    @Nonnull
    private final FunctionAppDeploymentSlotModule deploymentModule;
    private static final String SYNC_TRIGGERS = "Syncing triggers and fetching function information";
    private static final String UNABLE_TO_LIST_NONE_ANONYMOUS_HTTP_TRIGGERS = "Some http trigger urls cannot be displayed because they are non-anonymous. To access the non-anonymous triggers, please refer to https://aka.ms/azure-functions-key.";
    private static final String HTTP_TRIGGER_URLS = "HTTP Trigger Urls:";
    private static final String NO_ANONYMOUS_HTTP_TRIGGER = "No anonymous HTTP Triggers found in deployed function app, skip list triggers.";
    private static final String AUTH_LEVEL = "authLevel";
    private static final String HTTP_TRIGGER = "httpTrigger";
    private static final int SYNC_FUNCTION_MAX_ATTEMPTS = 5;
    private static final int SYNC_FUNCTION_DELAY = 1;
    private static final String LIST_TRIGGERS = "Querying triggers...";
    private static final String LIST_TRIGGERS_WITH_RETRY = "Querying triggers (Attempt {0}/{1})...";
    private static final String NO_TRIGGERS_FOUNDED = "No triggers found in deployed function app, please try recompile the project by `mvn clean package` and deploy again.";
    private static final int LIST_TRIGGERS_MAX_RETRY = 5;
    private static final int LIST_TRIGGERS_RETRY_PERIOD_IN_SECONDS = 10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    protected FunctionApp(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull FunctionAppModule module) {
        super(name, resourceGroupName, module);
        this.deploymentModule = new FunctionAppDeploymentSlotModule(this);
    }

    protected FunctionApp(@Nonnull FunctionApp origin) {
        super(origin);
        this.deploymentModule = origin.deploymentModule;
    }

    protected FunctionApp(@Nonnull FunctionAppBasic remote, @Nonnull FunctionAppModule module) {
        super(remote.name(), remote.resourceGroupName(), module);
        this.deploymentModule = new FunctionAppDeploymentSlotModule(this);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.deploymentModule);
    }

    @Override
    @Nullable
    public String getMasterKey() {
        return Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemote()).map(com.azure.resourcemanager.appservice.models.FunctionApp::getMasterKey).orElse(null);
    }

    @Override
    @AzureOperation(name="azure/function.enable_remote_debugging.app", params={"this.getName()"})
    public void enableRemoteDebug() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Map appSettings = Optional.ofNullable(this.getAppSettings()).orElseGet(HashMap::new);
            String debugPort = appSettings.getOrDefault("HTTP_PLATFORM_DEBUG_PORT", this.getRemoteDebugPort());
            this.doModify(() -> (com.azure.resourcemanager.appservice.models.FunctionApp)((FunctionApp.Update)Objects.requireNonNull((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemote()).update()).withWebSocketsEnabled(true).withPlatformArchitecture(PlatformArchitecture.X64).withAppSetting("HTTP_PLATFORM_DEBUG_PORT", appSettings.getOrDefault("HTTP_PLATFORM_DEBUG_PORT", this.getRemoteDebugPort())).withAppSetting("JAVA_OPTS", this.getJavaOptsWithRemoteDebugEnabled(appSettings, debugPort)).apply(), "Updating");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @AzureOperation(name="azure/function.disable_remote_debugging.app", params={"this.getName()"})
    public void disableRemoteDebug() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Map<String, String> appSettings = Objects.requireNonNull(this.getAppSettings());
            String javaOpts = this.getJavaOptsWithRemoteDebugDisabled(appSettings);
            this.doModify(() -> {
                if (StringUtils.isEmpty((CharSequence)javaOpts)) {
                    ((FunctionApp.Update)Objects.requireNonNull((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemote()).update()).withoutAppSetting("HTTP_PLATFORM_DEBUG_PORT").withoutAppSetting("JAVA_OPTS").apply();
                } else {
                    ((FunctionApp.Update)Objects.requireNonNull((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemote()).update()).withoutAppSetting("HTTP_PLATFORM_DEBUG_PORT").withAppSetting("JAVA_OPTS", javaOpts).apply();
                }
            }, "Updating");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nullable
    public Map<String, String> getAppSettings() {
        if (StringUtils.isBlank((CharSequence)this.getEnvironmentId())) {
            return super.getAppSettings();
        }
        return Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemote()).map(remote -> ((WebSiteManagementClient)((AppServiceManager)remote.manager()).serviceClient()).getWebApps().listApplicationSettings(this.getResourceGroupName(), this.getName()).properties()).orElse(null);
    }

    @Nonnull
    public List<FunctionEntity> listFunctions(boolean ... force) {
        return Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemote()).map(r -> r.listFunctions().stream().map(envelope -> AppServiceUtils.fromFunctionAppEnvelope(envelope, this.getId())).filter(Objects::nonNull).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @AzureOperation(name="azure/function.trigger_function.func", params={"functionName"})
    public void triggerFunction(String functionName, Object input) {
        String string = functionName;
        Object object = input;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)object);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemote()).ifPresent(r -> r.triggerFunction(functionName, input));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/function.swap_slot.app|slot", params={"this.getName()", "slotName"})
    public void swap(String slotName) {
        String string = slotName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.doModify(() -> {
                Objects.requireNonNull((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemote()).swap(slotName);
                AzureMessager.getMessager().info(AzureString.format((String)"Swap deployment slot %s into production successfully", (Object[])new Object[]{slotName}));
            }, "Updating");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public void syncTriggers() {
        Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemote()).ifPresent(com.azure.resourcemanager.appservice.models.FunctionApp::syncTriggers);
    }

    @Nonnull
    public Map<String, String> listFunctionKeys(String functionName) {
        return Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemote()).map(r -> r.listFunctionKeys(functionName)).orElseGet(HashMap::new);
    }

    @Nonnull
    public FunctionAppDeploymentSlotModule slots() {
        return this.deploymentModule;
    }

    public void listHTTPTriggerUrls() throws Exception {
        IAzureMessager messager = AzureMessager.getMessager();
        this.trySyncTriggers();
        List<FunctionEntity> triggers = this.trySyncListFunctions();
        List httpFunction = triggers.stream().filter(function -> function.getTrigger() != null && StringUtils.equalsIgnoreCase((CharSequence)function.getTrigger().getType(), (CharSequence)HTTP_TRIGGER)).collect(Collectors.toList());
        List<FunctionEntity> anonymousTriggers = httpFunction.stream().filter(bindingResource -> bindingResource.getTrigger() != null && StringUtils.equalsIgnoreCase((CharSequence)bindingResource.getTrigger().getProperty(AUTH_LEVEL), (CharSequence)"ANONYMOUS")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(httpFunction) || CollectionUtils.isEmpty(anonymousTriggers)) {
            messager.info(NO_ANONYMOUS_HTTP_TRIGGER);
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(HTTP_TRIGGER_URLS).append(System.lineSeparator());
        anonymousTriggers.forEach(trigger -> builder.append(String.format("\t %s : %s", trigger.getName(), trigger.getTriggerUrl())).append(System.lineSeparator()));
        if (anonymousTriggers.size() < httpFunction.size()) {
            builder.append(UNABLE_TO_LIST_NONE_ANONYMOUS_HTTP_TRIGGERS);
        }
        messager.info(builder.toString());
    }

    private void trySyncTriggers() throws InterruptedException {
        AzureMessager.getMessager().info(SYNC_TRIGGERS);
        Thread.sleep(5000L);
        Mono.fromRunnable(() -> {
            block2: {
                try {
                    this.syncTriggers();
                }
                catch (ManagementException e) {
                    if (e.getResponse().getStatusCode() == 200) break block2;
                    throw e;
                }
            }
        }).subscribeOn(Schedulers.boundedElastic()).retryWhen((Retry)Retry.fixedDelay((long)4L, (Duration)Duration.ofSeconds(1L))).block();
    }

    private List<FunctionEntity> trySyncListFunctions() {
        int[] count = new int[]{0};
        IAzureMessager messager = AzureMessager.getMessager();
        return (List)Mono.fromCallable(() -> {
            int n = count[0];
            count[0] = n + 1;
            AzureString message = n == 0 ? AzureString.fromString((String)LIST_TRIGGERS) : AzureString.format((String)LIST_TRIGGERS_WITH_RETRY, (Object[])new Object[]{count[0], 5});
            messager.info(message);
            return Optional.of(this.listFunctions(new boolean[0])).filter(CollectionUtils::isNotEmpty).orElseThrow(() -> new AzureToolkitRuntimeException(NO_TRIGGERS_FOUNDED));
        }).subscribeOn(Schedulers.boundedElastic()).retryWhen((Retry)Retry.fixedDelay((long)4L, (Duration)Duration.ofSeconds(10L))).block();
    }

    @Nullable
    protected com.azure.resourcemanager.appservice.models.FunctionApp doModify(@Nonnull Callable<com.azure.resourcemanager.appservice.models.FunctionApp> body, @Nullable String status) {
        return (com.azure.resourcemanager.appservice.models.FunctionApp)super.doModify(body, status);
    }

    public String getEnvironmentId() {
        return Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemote()).map(com.azure.resourcemanager.appservice.models.FunctionApp::managedEnvironmentId).orElse(null);
    }

    @Override
    @NotNull
    protected String loadStatus(@NotNull WebAppBase remote) {
        if (remote instanceof com.azure.resourcemanager.appservice.models.FunctionApp) {
            String environmentId = ((com.azure.resourcemanager.appservice.models.FunctionApp)remote).managedEnvironmentId();
            if (StringUtils.isBlank((CharSequence)environmentId)) {
                return super.loadStatus(remote);
            }
            ResourceId resourceId = ResourceId.fromString((String)environmentId);
            return ((AzureContainerAppsServiceSubscription)((AzureContainerApps)Azure.az(AzureContainerApps.class)).forSubscription(resourceId.subscriptionId())).containerApps().list().stream().filter(app -> StringUtils.equalsIgnoreCase((CharSequence)app.getManagedBy(), (CharSequence)this.getId())).map(AbstractAzResource::getStatus).findFirst().orElseGet(() -> super.loadStatus(remote));
        }
        return super.loadStatus(remote);
    }

    public ContainerAppsEnvironment getEnvironment() {
        return Optional.ofNullable(this.getEnvironmentId()).filter(StringUtils::isNotBlank).map(id -> (ContainerAppsEnvironment)((AzureContainerApps)Azure.az(AzureContainerApps.class)).getById(id)).orElse(null);
    }

    public ContainerAppFunctionConfiguration getContainerConfiguration() {
        return Optional.ofNullable((com.azure.resourcemanager.appservice.models.FunctionApp)this.getRemote()).map(ContainerAppFunctionConfiguration::fromFunctionApp).orElse(null);
    }

    @Nonnull
    public FunctionAppDeploymentSlotModule getDeploymentModule() {
        return this.deploymentModule;
    }

    static {
        FunctionApp.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FunctionApp.java", FunctionApp.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "enableRemoteDebug", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp", "", "", "", "void"), 107);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "disableRemoteDebug", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp", "", "", "", "void"), 119);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "triggerFunction", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp", "java.lang.String:java.lang.Object", "functionName:input", "", "void"), 152);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "swap", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp", "java.lang.String", "slotName", "", "void"), 157);
    }
}

