/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.config;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServicePlanConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.DeploymentSlotConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.FlexConsumptionConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceConfigUtils;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupDraft;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AppServiceConfig {
    private String subscriptionId;
    private String resourceGroup;
    private Region region;
    private PricingTier pricingTier;
    private String appName;
    private String servicePlanResourceGroup;
    private String servicePlanName;
    private RuntimeConfig runtime;
    private Map<String, String> appSettings;
    private Set<String> appSettingsToRemove;
    private DeploymentSlotConfig slotConfig;
    private DiagnosticConfig diagnosticConfig;
    private File file;

    public String deploymentSlotName() {
        return Optional.ofNullable(this.slotConfig).map(DeploymentSlotConfig::getName).orElse(null);
    }

    public AppServiceConfig deploymentSlotName(String deploymentSlotName) {
        this.slotConfig = Optional.ofNullable(this.slotConfig).orElseGet(DeploymentSlotConfig::new);
        this.slotConfig.setName(deploymentSlotName);
        return this;
    }

    public String deploymentSlotConfigurationSource() {
        return Optional.ofNullable(this.slotConfig).map(DeploymentSlotConfig::getConfigurationSource).orElse(null);
    }

    public AppServiceConfig deploymentSlotConfigurationSource(String source) {
        this.slotConfig = Optional.ofNullable(this.slotConfig).orElseGet(DeploymentSlotConfig::new);
        this.slotConfig.setConfigurationSource(source);
        return this;
    }

    public static AppServicePlanConfig getServicePlanConfig(@Nonnull AppServiceConfig config) {
        return AppServicePlanConfig.builder().subscriptionId(config.subscriptionId()).resourceGroupName((String)StringUtils.firstNonBlank((CharSequence[])new String[]{config.servicePlanResourceGroup(), config.resourceGroup()})).name(config.servicePlanName()).region(config.region()).os(Optional.ofNullable(config.runtime).map(RuntimeConfig::os).orElse(null)).pricingTier(config.pricingTier()).build();
    }

    @Nullable
    public static ResourceGroup getResourceGroup(@Nonnull AppServiceConfig config) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{config.getSubscriptionId(), config.getResourceGroup()})) {
            return null;
        }
        ResourceGroup rg = (ResourceGroup)((AzureResources)Azure.az(AzureResources.class)).groups(config.subscriptionId()).getOrDraft(config.resourceGroup(), config.resourceGroup());
        if (rg.isDraftForCreating()) {
            ResourceGroupDraft draft = (ResourceGroupDraft)rg;
            draft.setRegion(config.region());
            return draft;
        }
        return rg;
    }

    public static AppServiceConfig buildDefaultWebAppConfig(String resourceGroup, String appName, String packaging) {
        WebAppRuntime defaultRuntime = StringUtils.equalsIgnoreCase((CharSequence)packaging, (CharSequence)"war") ? WebAppRuntime.getDefaultTomcatRuntime() : (StringUtils.equalsIgnoreCase((CharSequence)packaging, (CharSequence)"ear") ? WebAppRuntime.getDefaultJbossRuntime() : WebAppRuntime.getDefaultJavaseRuntime());
        RuntimeConfig runtimeConfig = new RuntimeConfig().os(defaultRuntime.getOperatingSystem()).webContainer(defaultRuntime.getContainerUserText()).javaVersion(defaultRuntime.getJavaVersionUserText());
        AppServiceConfig appServiceConfig = AppServiceConfig.buildDefaultAppServiceConfig(resourceGroup, appName);
        appServiceConfig.runtime(runtimeConfig);
        return appServiceConfig;
    }

    public static FunctionAppConfig buildDefaultFunctionConfig(String resourceGroup, String appName) {
        FunctionAppConfig result = new FunctionAppConfig();
        AppServiceConfig appServiceConfig = AppServiceConfig.buildDefaultAppServiceConfig(resourceGroup, appName);
        AppServiceConfigUtils.mergeAppServiceConfig(result, appServiceConfig);
        FunctionAppRuntime defaultRuntime = FunctionAppRuntime.getDefault();
        RuntimeConfig runtimeConfig = new RuntimeConfig().os(defaultRuntime.getOperatingSystem()).javaVersion(defaultRuntime.getJavaVersionUserText());
        result.runtime(runtimeConfig);
        result.pricingTier(PricingTier.CONSUMPTION);
        result.flexConsumptionConfiguration(FlexConsumptionConfiguration.DEFAULT_CONFIGURATION);
        return result;
    }

    @Nonnull
    private static AppServiceConfig buildDefaultAppServiceConfig(String resourceGroup, String appName) {
        AppServiceConfig appServiceConfig = new AppServiceConfig();
        appServiceConfig.region(Region.US_CENTRAL);
        appServiceConfig.resourceGroup(resourceGroup);
        appServiceConfig.appName(appName);
        appServiceConfig.servicePlanResourceGroup(resourceGroup);
        appServiceConfig.servicePlanName(String.format("asp-%s", appName));
        return appServiceConfig;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public Region getRegion() {
        return this.region;
    }

    public PricingTier getPricingTier() {
        return this.pricingTier;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getServicePlanResourceGroup() {
        return this.servicePlanResourceGroup;
    }

    public String getServicePlanName() {
        return this.servicePlanName;
    }

    public RuntimeConfig getRuntime() {
        return this.runtime;
    }

    public Map<String, String> getAppSettings() {
        return this.appSettings;
    }

    public Set<String> getAppSettingsToRemove() {
        return this.appSettingsToRemove;
    }

    public DeploymentSlotConfig getSlotConfig() {
        return this.slotConfig;
    }

    public DiagnosticConfig getDiagnosticConfig() {
        return this.diagnosticConfig;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setPricingTier(PricingTier pricingTier) {
        this.pricingTier = pricingTier;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setServicePlanResourceGroup(String servicePlanResourceGroup) {
        this.servicePlanResourceGroup = servicePlanResourceGroup;
    }

    public void setServicePlanName(String servicePlanName) {
        this.servicePlanName = servicePlanName;
    }

    public void setRuntime(RuntimeConfig runtime) {
        this.runtime = runtime;
    }

    public void setAppSettings(Map<String, String> appSettings) {
        this.appSettings = appSettings;
    }

    public void setAppSettingsToRemove(Set<String> appSettingsToRemove) {
        this.appSettingsToRemove = appSettingsToRemove;
    }

    public void setSlotConfig(DeploymentSlotConfig slotConfig) {
        this.slotConfig = slotConfig;
    }

    public void setDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
        this.diagnosticConfig = diagnosticConfig;
    }

    protected AppServiceConfig(AppServiceConfigBuilder<?, ?> b) {
        this.subscriptionId = ((AppServiceConfigBuilder)b).subscriptionId;
        this.resourceGroup = ((AppServiceConfigBuilder)b).resourceGroup;
        this.region = ((AppServiceConfigBuilder)b).region;
        this.pricingTier = ((AppServiceConfigBuilder)b).pricingTier;
        this.appName = ((AppServiceConfigBuilder)b).appName;
        this.servicePlanResourceGroup = ((AppServiceConfigBuilder)b).servicePlanResourceGroup;
        this.servicePlanName = ((AppServiceConfigBuilder)b).servicePlanName;
        this.runtime = ((AppServiceConfigBuilder)b).runtime;
        this.appSettings = ((AppServiceConfigBuilder)b).appSettings;
        this.appSettingsToRemove = ((AppServiceConfigBuilder)b).appSettingsToRemove;
        this.slotConfig = ((AppServiceConfigBuilder)b).slotConfig;
        this.diagnosticConfig = ((AppServiceConfigBuilder)b).diagnosticConfig;
        this.file = ((AppServiceConfigBuilder)b).file;
    }

    public static AppServiceConfigBuilder<?, ?> builder() {
        return new AppServiceConfigBuilderImpl();
    }

    public AppServiceConfigBuilder<?, ?> toBuilder() {
        return new AppServiceConfigBuilderImpl().$fillValuesFrom(this);
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public Region region() {
        return this.region;
    }

    public PricingTier pricingTier() {
        return this.pricingTier;
    }

    public String appName() {
        return this.appName;
    }

    public String servicePlanResourceGroup() {
        return this.servicePlanResourceGroup;
    }

    public String servicePlanName() {
        return this.servicePlanName;
    }

    public RuntimeConfig runtime() {
        return this.runtime;
    }

    public Map<String, String> appSettings() {
        return this.appSettings;
    }

    public Set<String> appSettingsToRemove() {
        return this.appSettingsToRemove;
    }

    public DeploymentSlotConfig slotConfig() {
        return this.slotConfig;
    }

    public DiagnosticConfig diagnosticConfig() {
        return this.diagnosticConfig;
    }

    public File file() {
        return this.file;
    }

    public AppServiceConfig subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public AppServiceConfig resourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    public AppServiceConfig region(Region region) {
        this.region = region;
        return this;
    }

    public AppServiceConfig pricingTier(PricingTier pricingTier) {
        this.pricingTier = pricingTier;
        return this;
    }

    public AppServiceConfig appName(String appName) {
        this.appName = appName;
        return this;
    }

    public AppServiceConfig servicePlanResourceGroup(String servicePlanResourceGroup) {
        this.servicePlanResourceGroup = servicePlanResourceGroup;
        return this;
    }

    public AppServiceConfig servicePlanName(String servicePlanName) {
        this.servicePlanName = servicePlanName;
        return this;
    }

    public AppServiceConfig runtime(RuntimeConfig runtime) {
        this.runtime = runtime;
        return this;
    }

    public AppServiceConfig appSettings(Map<String, String> appSettings) {
        this.appSettings = appSettings;
        return this;
    }

    public AppServiceConfig appSettingsToRemove(Set<String> appSettingsToRemove) {
        this.appSettingsToRemove = appSettingsToRemove;
        return this;
    }

    public AppServiceConfig slotConfig(DeploymentSlotConfig slotConfig) {
        this.slotConfig = slotConfig;
        return this;
    }

    public AppServiceConfig diagnosticConfig(DiagnosticConfig diagnosticConfig) {
        this.diagnosticConfig = diagnosticConfig;
        return this;
    }

    public AppServiceConfig file(File file) {
        this.file = file;
        return this;
    }

    public AppServiceConfig() {
    }

    public AppServiceConfig(String subscriptionId, String resourceGroup, Region region, PricingTier pricingTier, String appName, String servicePlanResourceGroup, String servicePlanName, RuntimeConfig runtime, Map<String, String> appSettings, Set<String> appSettingsToRemove, DeploymentSlotConfig slotConfig, DiagnosticConfig diagnosticConfig, File file) {
        this.subscriptionId = subscriptionId;
        this.resourceGroup = resourceGroup;
        this.region = region;
        this.pricingTier = pricingTier;
        this.appName = appName;
        this.servicePlanResourceGroup = servicePlanResourceGroup;
        this.servicePlanName = servicePlanName;
        this.runtime = runtime;
        this.appSettings = appSettings;
        this.appSettingsToRemove = appSettingsToRemove;
        this.slotConfig = slotConfig;
        this.diagnosticConfig = diagnosticConfig;
        this.file = file;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppServiceConfig)) {
            return false;
        }
        AppServiceConfig other = (AppServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$subscriptionId = this.subscriptionId();
        String other$subscriptionId = other.subscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !this$subscriptionId.equals(other$subscriptionId)) {
            return false;
        }
        String this$resourceGroup = this.resourceGroup();
        String other$resourceGroup = other.resourceGroup();
        if (this$resourceGroup == null ? other$resourceGroup != null : !this$resourceGroup.equals(other$resourceGroup)) {
            return false;
        }
        Region this$region = this.region();
        Region other$region = other.region();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        PricingTier this$pricingTier = this.pricingTier();
        PricingTier other$pricingTier = other.pricingTier();
        if (this$pricingTier == null ? other$pricingTier != null : !((Object)this$pricingTier).equals(other$pricingTier)) {
            return false;
        }
        String this$appName = this.appName();
        String other$appName = other.appName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        String this$servicePlanResourceGroup = this.servicePlanResourceGroup();
        String other$servicePlanResourceGroup = other.servicePlanResourceGroup();
        if (this$servicePlanResourceGroup == null ? other$servicePlanResourceGroup != null : !this$servicePlanResourceGroup.equals(other$servicePlanResourceGroup)) {
            return false;
        }
        String this$servicePlanName = this.servicePlanName();
        String other$servicePlanName = other.servicePlanName();
        if (this$servicePlanName == null ? other$servicePlanName != null : !this$servicePlanName.equals(other$servicePlanName)) {
            return false;
        }
        RuntimeConfig this$runtime = this.runtime();
        RuntimeConfig other$runtime = other.runtime();
        if (this$runtime == null ? other$runtime != null : !((Object)this$runtime).equals(other$runtime)) {
            return false;
        }
        Map<String, String> this$appSettings = this.appSettings();
        Map<String, String> other$appSettings = other.appSettings();
        if (this$appSettings == null ? other$appSettings != null : !((Object)this$appSettings).equals(other$appSettings)) {
            return false;
        }
        Set<String> this$appSettingsToRemove = this.appSettingsToRemove();
        Set<String> other$appSettingsToRemove = other.appSettingsToRemove();
        if (this$appSettingsToRemove == null ? other$appSettingsToRemove != null : !((Object)this$appSettingsToRemove).equals(other$appSettingsToRemove)) {
            return false;
        }
        DeploymentSlotConfig this$slotConfig = this.slotConfig();
        DeploymentSlotConfig other$slotConfig = other.slotConfig();
        if (this$slotConfig == null ? other$slotConfig != null : !((Object)this$slotConfig).equals(other$slotConfig)) {
            return false;
        }
        DiagnosticConfig this$diagnosticConfig = this.diagnosticConfig();
        DiagnosticConfig other$diagnosticConfig = other.diagnosticConfig();
        if (this$diagnosticConfig == null ? other$diagnosticConfig != null : !((Object)this$diagnosticConfig).equals(other$diagnosticConfig)) {
            return false;
        }
        File this$file = this.file();
        File other$file = other.file();
        return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppServiceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $subscriptionId = this.subscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : $subscriptionId.hashCode());
        String $resourceGroup = this.resourceGroup();
        result = result * 59 + ($resourceGroup == null ? 43 : $resourceGroup.hashCode());
        Region $region = this.region();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        PricingTier $pricingTier = this.pricingTier();
        result = result * 59 + ($pricingTier == null ? 43 : ((Object)$pricingTier).hashCode());
        String $appName = this.appName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        String $servicePlanResourceGroup = this.servicePlanResourceGroup();
        result = result * 59 + ($servicePlanResourceGroup == null ? 43 : $servicePlanResourceGroup.hashCode());
        String $servicePlanName = this.servicePlanName();
        result = result * 59 + ($servicePlanName == null ? 43 : $servicePlanName.hashCode());
        RuntimeConfig $runtime = this.runtime();
        result = result * 59 + ($runtime == null ? 43 : ((Object)$runtime).hashCode());
        Map<String, String> $appSettings = this.appSettings();
        result = result * 59 + ($appSettings == null ? 43 : ((Object)$appSettings).hashCode());
        Set<String> $appSettingsToRemove = this.appSettingsToRemove();
        result = result * 59 + ($appSettingsToRemove == null ? 43 : ((Object)$appSettingsToRemove).hashCode());
        DeploymentSlotConfig $slotConfig = this.slotConfig();
        result = result * 59 + ($slotConfig == null ? 43 : ((Object)$slotConfig).hashCode());
        DiagnosticConfig $diagnosticConfig = this.diagnosticConfig();
        result = result * 59 + ($diagnosticConfig == null ? 43 : ((Object)$diagnosticConfig).hashCode());
        File $file = this.file();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        return result;
    }

    public static abstract class AppServiceConfigBuilder<C extends AppServiceConfig, B extends AppServiceConfigBuilder<C, B>> {
        private String subscriptionId;
        private String resourceGroup;
        private Region region;
        private PricingTier pricingTier;
        private String appName;
        private String servicePlanResourceGroup;
        private String servicePlanName;
        private RuntimeConfig runtime;
        private Map<String, String> appSettings;
        private Set<String> appSettingsToRemove;
        private DeploymentSlotConfig slotConfig;
        private DiagnosticConfig diagnosticConfig;
        private File file;

        protected B $fillValuesFrom(C instance) {
            AppServiceConfigBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AppServiceConfig instance, AppServiceConfigBuilder<?, ?> b) {
            b.subscriptionId(instance.subscriptionId);
            b.resourceGroup(instance.resourceGroup);
            b.region(instance.region);
            b.pricingTier(instance.pricingTier);
            b.appName(instance.appName);
            b.servicePlanResourceGroup(instance.servicePlanResourceGroup);
            b.servicePlanName(instance.servicePlanName);
            b.runtime(instance.runtime);
            b.appSettings(instance.appSettings);
            b.appSettingsToRemove(instance.appSettingsToRemove);
            b.slotConfig(instance.slotConfig);
            b.diagnosticConfig(instance.diagnosticConfig);
            b.file(instance.file);
        }

        protected abstract B self();

        public abstract C build();

        public B subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this.self();
        }

        public B resourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
            return this.self();
        }

        public B region(Region region) {
            this.region = region;
            return this.self();
        }

        public B pricingTier(PricingTier pricingTier) {
            this.pricingTier = pricingTier;
            return this.self();
        }

        public B appName(String appName) {
            this.appName = appName;
            return this.self();
        }

        public B servicePlanResourceGroup(String servicePlanResourceGroup) {
            this.servicePlanResourceGroup = servicePlanResourceGroup;
            return this.self();
        }

        public B servicePlanName(String servicePlanName) {
            this.servicePlanName = servicePlanName;
            return this.self();
        }

        public B runtime(RuntimeConfig runtime) {
            this.runtime = runtime;
            return this.self();
        }

        public B appSettings(Map<String, String> appSettings) {
            this.appSettings = appSettings;
            return this.self();
        }

        public B appSettingsToRemove(Set<String> appSettingsToRemove) {
            this.appSettingsToRemove = appSettingsToRemove;
            return this.self();
        }

        public B slotConfig(DeploymentSlotConfig slotConfig) {
            this.slotConfig = slotConfig;
            return this.self();
        }

        public B diagnosticConfig(DiagnosticConfig diagnosticConfig) {
            this.diagnosticConfig = diagnosticConfig;
            return this.self();
        }

        public B file(File file) {
            this.file = file;
            return this.self();
        }

        public String toString() {
            return "AppServiceConfig.AppServiceConfigBuilder(subscriptionId=" + this.subscriptionId + ", resourceGroup=" + this.resourceGroup + ", region=" + this.region + ", pricingTier=" + this.pricingTier + ", appName=" + this.appName + ", servicePlanResourceGroup=" + this.servicePlanResourceGroup + ", servicePlanName=" + this.servicePlanName + ", runtime=" + this.runtime + ", appSettings=" + this.appSettings + ", appSettingsToRemove=" + this.appSettingsToRemove + ", slotConfig=" + this.slotConfig + ", diagnosticConfig=" + this.diagnosticConfig + ", file=" + this.file + ")";
        }
    }

    private static final class AppServiceConfigBuilderImpl
    extends AppServiceConfigBuilder<AppServiceConfig, AppServiceConfigBuilderImpl> {
        private AppServiceConfigBuilderImpl() {
        }

        @Override
        protected AppServiceConfigBuilderImpl self() {
            return this;
        }

        @Override
        public AppServiceConfig build() {
            return new AppServiceConfig(this);
        }
    }
}

