/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.function.template;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.toolkit.lib.legacy.function.template.BindingConfiguration;
import com.microsoft.azure.toolkit.lib.legacy.function.template.BindingTemplate;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BindingsTemplate {
    @JsonProperty(value="$schema")
    private String schema;
    private String contentVersion;
    private Map<String, String> variables;
    private BindingTemplate[] bindings;

    public BindingTemplate getBindingTemplate(@Nonnull BindingConfiguration conf) {
        return Arrays.stream(this.bindings).filter(binding -> StringUtils.equalsIgnoreCase((CharSequence)binding.getType(), (CharSequence)conf.getType()) && (conf.isTrigger() && StringUtils.equalsIgnoreCase((CharSequence)binding.getDirection(), (CharSequence)"trigger") || StringUtils.equalsIgnoreCase((CharSequence)binding.getDirection(), (CharSequence)conf.getDirection()))).findFirst().orElse(null);
    }

    public String getSchema() {
        return this.schema;
    }

    public String getContentVersion() {
        return this.contentVersion;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public BindingTemplate[] getBindings() {
        return this.bindings;
    }

    @JsonProperty(value="$schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setContentVersion(String contentVersion) {
        this.contentVersion = contentVersion;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public void setBindings(BindingTemplate[] bindings) {
        this.bindings = bindings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BindingsTemplate)) {
            return false;
        }
        BindingsTemplate other = (BindingsTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$contentVersion = this.getContentVersion();
        String other$contentVersion = other.getContentVersion();
        if (this$contentVersion == null ? other$contentVersion != null : !this$contentVersion.equals(other$contentVersion)) {
            return false;
        }
        Map<String, String> this$variables = this.getVariables();
        Map<String, String> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        return Arrays.deepEquals(this.getBindings(), other.getBindings());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BindingsTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $contentVersion = this.getContentVersion();
        result = result * 59 + ($contentVersion == null ? 43 : $contentVersion.hashCode());
        Map<String, String> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getBindings());
        return result;
    }

    public String toString() {
        return "BindingsTemplate(schema=" + this.getSchema() + ", contentVersion=" + this.getContentVersion() + ", variables=" + this.getVariables() + ", bindings=" + Arrays.deepToString(this.getBindings()) + ")";
    }

    public BindingsTemplate() {
    }

    public BindingsTemplate(String schema, String contentVersion, Map<String, String> variables, BindingTemplate[] bindings) {
        this.schema = schema;
        this.contentVersion = contentVersion;
        this.variables = variables;
        this.bindings = bindings;
    }
}

