/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.webapp;

import com.azure.resourcemanager.appservice.models.DeploymentSlot;
import com.azure.resourcemanager.appservice.models.DeploymentSlots;
import com.azure.resourcemanager.appservice.models.WebDeploymentSlotBasic;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceResourceModule;
import com.microsoft.azure.toolkit.lib.appservice.IDeploymentSlotModule;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDeploymentSlotDraft;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WebAppDeploymentSlotModule
extends AppServiceResourceModule<WebAppDeploymentSlot, WebApp, DeploymentSlot>
implements IDeploymentSlotModule<WebAppDeploymentSlot, WebApp, DeploymentSlot> {
    public static final String NAME = "slots";

    public WebAppDeploymentSlotModule(@Nonnull WebApp parent) {
        super(NAME, parent);
    }

    public DeploymentSlots getClient() {
        return Optional.ofNullable((com.azure.resourcemanager.appservice.models.WebApp)((WebApp)this.parent).getRemote()).map(com.azure.resourcemanager.appservice.models.WebApp::deploymentSlots).orElse(null);
    }

    @Nonnull
    protected WebAppDeploymentSlotDraft newDraftForCreate(@Nonnull String name, @Nullable String resourceGroupName) {
        return new WebAppDeploymentSlotDraft(name, this);
    }

    @Nonnull
    protected WebAppDeploymentSlotDraft newDraftForUpdate(@Nonnull WebAppDeploymentSlot origin) {
        return new WebAppDeploymentSlotDraft(origin);
    }

    @Nonnull
    protected WebAppDeploymentSlot newResource(@Nonnull DeploymentSlot remote) {
        return new WebAppDeploymentSlot((WebDeploymentSlotBasic)remote, this);
    }

    @Nonnull
    protected WebAppDeploymentSlot newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new WebAppDeploymentSlot(name, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Deployment slot";
    }

    @Override
    protected List<String> loadResourceIdsFromAzure() {
        return Optional.ofNullable(this.getClient()).map(client -> client.list().stream().map(HasId::id).collect(Collectors.toList())).orElse(Collections.emptyList());
    }
}

