/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class Runtime {
    private static final Pattern LINUX_FX_VERSION_PATTERN = Pattern.compile("(?i)(JAVA|TOMCAT|JBOSSEAP)\\|((.*)-)?(.+)");
    public static final Runtime WINDOWS_JAVA8 = new Runtime(OperatingSystem.WINDOWS, WebContainer.JAVA_SE, JavaVersion.JAVA_8);
    public static final Runtime WINDOWS_JAVA11 = new Runtime(OperatingSystem.WINDOWS, WebContainer.JAVA_SE, JavaVersion.JAVA_11);
    public static final Runtime WINDOWS_JAVA17 = new Runtime(OperatingSystem.WINDOWS, WebContainer.JAVA_SE, JavaVersion.JAVA_17);
    public static final Runtime WINDOWS_JAVA8_TOMCAT9 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_9, JavaVersion.JAVA_8);
    public static final Runtime WINDOWS_JAVA8_TOMCAT85 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_85, JavaVersion.JAVA_8);
    public static final Runtime WINDOWS_JAVA8_TOMCAT10 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_10, JavaVersion.JAVA_8);
    public static final Runtime WINDOWS_JAVA11_TOMCAT9 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_9, JavaVersion.JAVA_11);
    public static final Runtime WINDOWS_JAVA17_TOMCAT9 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_9, JavaVersion.JAVA_17);
    public static final Runtime WINDOWS_JAVA11_TOMCAT85 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_85, JavaVersion.JAVA_11);
    public static final Runtime WINDOWS_JAVA17_TOMCAT85 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_85, JavaVersion.JAVA_17);
    public static final Runtime WINDOWS_JAVA11_TOMCAT10 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_10, JavaVersion.JAVA_11);
    public static final Runtime WINDOWS_JAVA17_TOMCAT10 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_10, JavaVersion.JAVA_17);
    public static final Runtime LINUX_JAVA8 = new Runtime(OperatingSystem.LINUX, WebContainer.JAVA_SE, JavaVersion.JAVA_8);
    public static final Runtime LINUX_JAVA11 = new Runtime(OperatingSystem.LINUX, WebContainer.JAVA_SE, JavaVersion.JAVA_11);
    public static final Runtime LINUX_JAVA17 = new Runtime(OperatingSystem.LINUX, WebContainer.JAVA_SE, JavaVersion.JAVA_17);
    public static final Runtime LINUX_JAVA8_TOMCAT9 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_9, JavaVersion.JAVA_8);
    public static final Runtime LINUX_JAVA8_TOMCAT85 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_85, JavaVersion.JAVA_8);
    public static final Runtime LINUX_JAVA8_TOMCAT10 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_10, JavaVersion.JAVA_8);
    public static final Runtime LINUX_JAVA8_JBOSS7 = new Runtime(OperatingSystem.LINUX, WebContainer.JBOSS_7, JavaVersion.JAVA_8);
    public static final Runtime LINUX_JAVA11_JBOSS7 = new Runtime(OperatingSystem.LINUX, WebContainer.JBOSS_7, JavaVersion.JAVA_11);
    public static final Runtime LINUX_JAVA11_TOMCAT9 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_9, JavaVersion.JAVA_11);
    public static final Runtime LINUX_JAVA17_TOMCAT9 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_9, JavaVersion.JAVA_17);
    public static final Runtime LINUX_JAVA11_TOMCAT85 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_85, JavaVersion.JAVA_11);
    public static final Runtime LINUX_JAVA17_TOMCAT85 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_85, JavaVersion.JAVA_17);
    public static final Runtime LINUX_JAVA11_TOMCAT10 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_10, JavaVersion.JAVA_11);
    public static final Runtime LINUX_JAVA17_TOMCAT10 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_10, JavaVersion.JAVA_17);
    public static final Runtime FUNCTION_WINDOWS_JAVA8 = new Runtime(OperatingSystem.WINDOWS, WebContainer.JAVA_OFF, JavaVersion.JAVA_8);
    public static final Runtime FUNCTION_WINDOWS_JAVA11 = new Runtime(OperatingSystem.WINDOWS, WebContainer.JAVA_OFF, JavaVersion.JAVA_11);
    public static final Runtime FUNCTION_WINDOWS_JAVA17 = new Runtime(OperatingSystem.WINDOWS, WebContainer.JAVA_OFF, JavaVersion.JAVA_17);
    public static final Runtime FUNCTION_LINUX_JAVA8 = new Runtime(OperatingSystem.LINUX, WebContainer.JAVA_OFF, JavaVersion.JAVA_8);
    public static final Runtime FUNCTION_LINUX_JAVA11 = new Runtime(OperatingSystem.LINUX, WebContainer.JAVA_OFF, JavaVersion.JAVA_11);
    public static final Runtime FUNCTION_LINUX_JAVA17 = new Runtime(OperatingSystem.LINUX, WebContainer.JAVA_OFF, JavaVersion.JAVA_17);
    public static final Runtime DOCKER = new Runtime(OperatingSystem.DOCKER, null, null);
    public static final Runtime DEFAULT_FUNCTION_RUNTIME = FUNCTION_WINDOWS_JAVA17;
    public static final List<Runtime> WEBAPP_RUNTIME = Collections.unmodifiableList(Arrays.asList(WINDOWS_JAVA8, WINDOWS_JAVA11, WINDOWS_JAVA17, WINDOWS_JAVA8_TOMCAT9, WINDOWS_JAVA8_TOMCAT85, WINDOWS_JAVA8_TOMCAT10, WINDOWS_JAVA11_TOMCAT9, WINDOWS_JAVA17_TOMCAT9, WINDOWS_JAVA11_TOMCAT85, WINDOWS_JAVA17_TOMCAT85, WINDOWS_JAVA11_TOMCAT10, WINDOWS_JAVA17_TOMCAT10, LINUX_JAVA8, LINUX_JAVA11, LINUX_JAVA17, LINUX_JAVA8_TOMCAT9, LINUX_JAVA8_TOMCAT85, LINUX_JAVA8_TOMCAT10, LINUX_JAVA11_JBOSS7, LINUX_JAVA8_JBOSS7, LINUX_JAVA11_TOMCAT9, LINUX_JAVA17_TOMCAT9, LINUX_JAVA11_TOMCAT85, LINUX_JAVA17_TOMCAT85, LINUX_JAVA11_TOMCAT10, LINUX_JAVA17_TOMCAT10));
    public static final List<Runtime> FUNCTION_APP_RUNTIME = Collections.unmodifiableList(Arrays.asList(FUNCTION_LINUX_JAVA8, FUNCTION_LINUX_JAVA11, FUNCTION_LINUX_JAVA17, FUNCTION_WINDOWS_JAVA8, FUNCTION_WINDOWS_JAVA11, FUNCTION_WINDOWS_JAVA17));
    private static final List<Runtime> values = Collections.unmodifiableList(new ArrayList(new HashSet(ListUtils.union(WEBAPP_RUNTIME, FUNCTION_APP_RUNTIME))));
    private OperatingSystem operatingSystem;
    private WebContainer webContainer;
    private JavaVersion javaVersion;

    public static Runtime getRuntime(OperatingSystem operatingSystem, WebContainer webContainer, JavaVersion javaVersion) {
        Runtime standardRuntime = Runtime.values().stream().filter(runtime -> Objects.equals((Object)runtime.operatingSystem, (Object)operatingSystem)).filter(runtime -> Objects.equals(runtime.webContainer, webContainer)).filter(runtime -> Objects.equals(runtime.javaVersion, javaVersion)).findFirst().orElse(null);
        if (standardRuntime != null) {
            return standardRuntime;
        }
        return new Runtime(operatingSystem, webContainer, javaVersion);
    }

    public static Runtime getRuntimeFromLinuxFxVersion(String linuxFxVersion) {
        Matcher matcher = LINUX_FX_VERSION_PATTERN.matcher(linuxFxVersion);
        if (!matcher.matches()) {
            return Runtime.getRuntime(OperatingSystem.LINUX, WebContainer.JAVA_OFF, JavaVersion.OFF);
        }
        String javaVersion = matcher.group(4);
        String webContainer = StringUtils.isEmpty((CharSequence)matcher.group(3)) ? matcher.group(1) : String.format("%s %s", matcher.group(1), matcher.group(3)).trim();
        return Runtime.getRuntime(OperatingSystem.LINUX, WebContainer.fromString(webContainer), JavaVersion.fromString(javaVersion));
    }

    public static List<Runtime> values() {
        return values;
    }

    public boolean isWindows() {
        return Objects.equals((Object)this.operatingSystem, (Object)OperatingSystem.WINDOWS);
    }

    public boolean isLinux() {
        return Objects.equals((Object)this.operatingSystem, (Object)OperatingSystem.LINUX);
    }

    public boolean isDocker() {
        return Objects.equals((Object)this.operatingSystem, (Object)OperatingSystem.DOCKER);
    }

    public String toString() {
        if (this.isDocker()) {
            return "Docker";
        }
        return Stream.of(new Object[]{this.getOperatingSystem(), this.getJavaVersion(), this.getWebContainer()}).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining("|"));
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public WebContainer getWebContainer() {
        return this.webContainer;
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public void setOperatingSystem(OperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public void setWebContainer(WebContainer webContainer) {
        this.webContainer = webContainer;
    }

    public void setJavaVersion(JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
    }

    public Runtime() {
    }

    public Runtime(OperatingSystem operatingSystem, WebContainer webContainer, JavaVersion javaVersion) {
        this.operatingSystem = operatingSystem;
        this.webContainer = webContainer;
        this.javaVersion = javaVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Runtime)) {
            return false;
        }
        Runtime other = (Runtime)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OperatingSystem this$operatingSystem = this.getOperatingSystem();
        OperatingSystem other$operatingSystem = other.getOperatingSystem();
        if (this$operatingSystem == null ? other$operatingSystem != null : !((Object)((Object)this$operatingSystem)).equals((Object)other$operatingSystem)) {
            return false;
        }
        WebContainer this$webContainer = this.getWebContainer();
        WebContainer other$webContainer = other.getWebContainer();
        if (this$webContainer == null ? other$webContainer != null : !((Object)this$webContainer).equals(other$webContainer)) {
            return false;
        }
        JavaVersion this$javaVersion = this.getJavaVersion();
        JavaVersion other$javaVersion = other.getJavaVersion();
        return !(this$javaVersion == null ? other$javaVersion != null : !((Object)this$javaVersion).equals(other$javaVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Runtime;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OperatingSystem $operatingSystem = this.getOperatingSystem();
        result = result * 59 + ($operatingSystem == null ? 43 : ((Object)((Object)$operatingSystem)).hashCode());
        WebContainer $webContainer = this.getWebContainer();
        result = result * 59 + ($webContainer == null ? 43 : ((Object)$webContainer).hashCode());
        JavaVersion $javaVersion = this.getJavaVersion();
        result = result * 59 + ($javaVersion == null ? 43 : ((Object)$javaVersion).hashCode());
        return result;
    }
}

