/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.applicationinsights.task;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsight;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightDraft;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsModule;
import com.microsoft.azure.toolkit.lib.applicationinsights.AzureApplicationInsights;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspaceConfig;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GetOrCreateApplicationInsightsTask
extends AzureTask<ApplicationInsight> {
    private static final String APPLICATION_INSIGHTS_CREATE_START = "Creating application insights...";
    private static final String APPLICATION_INSIGHTS_CREATED = "Successfully created the application insights %s for this Function App. You can visit %s/#@/resource%s/overview to view your Application Insights component.";
    @Nonnull
    private final String subscriptionId;
    @Nonnull
    private final String resourceGroup;
    @Nonnull
    private final String name;
    @Nonnull
    private final Region region;
    @Nullable
    private LogAnalyticsWorkspaceConfig workspaceConfig;

    public GetOrCreateApplicationInsightsTask(@Nonnull String subscriptionId, @Nonnull String resourceGroup, @Nonnull Region region, @Nonnull String name) {
        this(subscriptionId, resourceGroup, region, name, null);
    }

    public GetOrCreateApplicationInsightsTask(@Nonnull String subscriptionId, @Nonnull String resourceGroup, @Nonnull Region region, @Nonnull String name, @Nullable LogAnalyticsWorkspaceConfig workspaceConfig) {
        this.subscriptionId = subscriptionId;
        this.resourceGroup = resourceGroup;
        this.name = name;
        this.region = region;
        this.workspaceConfig = workspaceConfig;
    }

    public ApplicationInsight doExecute() {
        this.workspaceConfig = Optional.ofNullable(this.workspaceConfig).orElseGet(this::getDefaultWorkspaceConfig);
        ((AzureResources)Azure.az(AzureResources.class)).groups(this.subscriptionId).createResourceGroupIfNotExist(this.resourceGroup, this.region);
        ApplicationInsightsModule insightsModule = ((AzureApplicationInsights)Azure.az(AzureApplicationInsights.class)).applicationInsights(this.subscriptionId);
        return Optional.ofNullable((ApplicationInsight)insightsModule.get(this.name, this.resourceGroup)).orElseGet(() -> {
            ApplicationInsightDraft draft = (ApplicationInsightDraft)insightsModule.create(this.name, this.resourceGroup);
            draft.setRegion(this.region);
            draft.setWorkspaceConfig(this.workspaceConfig);
            return (ApplicationInsight)draft.commit();
        });
    }

    private LogAnalyticsWorkspaceConfig getDefaultWorkspaceConfig() {
        String defaultWorkspaceName = String.format("DefaultWorkspace-%s-%s", this.subscriptionId, this.region.getAbbreviation());
        return LogAnalyticsWorkspaceConfig.builder().newCreate(true).subscriptionId(this.subscriptionId).name(defaultWorkspaceName).regionName(this.region.getName()).build();
    }
}

