/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.StorageKey;
import com.microsoft.azure.storage.core.Base64;
import com.microsoft.azure.storage.core.Utility;

@Deprecated
public final class Credentials {
    private String accountName;
    private StorageKey key;
    private String keyName;

    public Credentials(String accountName, byte[] key) {
        if (Utility.isNullOrEmptyOrWhitespace(accountName)) {
            throw new IllegalArgumentException("Invalid account name.");
        }
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("Storage Key is not a valid base64 encoded string.");
        }
        this.accountName = accountName;
        this.key = new StorageKey(key);
    }

    public Credentials(String accountName, String key) {
        if (Utility.isNullOrEmptyOrWhitespace(accountName)) {
            throw new IllegalArgumentException("Invalid account name.");
        }
        if (Utility.isNullOrEmptyOrWhitespace(key) || !Base64.validateIsBase64String(key)) {
            throw new IllegalArgumentException("Storage Key is not a valid base64 encoded string.");
        }
        this.accountName = accountName;
        this.key = new StorageKey(Base64.decode(key));
    }

    public String exportBase64EncodedKey() {
        return this.getKey().getBase64EncodedKey();
    }

    public byte[] exportKey() {
        return this.getKey().getKey();
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public StorageKey getKey() {
        return this.key;
    }

    protected void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    protected void setKey(StorageKey key) {
        this.key = key;
    }
}

