/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;
import java.util.UUID;

public final class RequestIDFactory
implements RequestPolicyFactory {
    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new RequestIDPolicy(next, options);
    }

    private final class RequestIDPolicy
    implements RequestPolicy {
        private final RequestPolicy nextPolicy;
        private final RequestPolicyOptions options;

        private RequestIDPolicy(RequestPolicy nextPolicy, RequestPolicyOptions options) {
            this.nextPolicy = nextPolicy;
            this.options = options;
        }

        public Single<HttpResponse> sendAsync(HttpRequest request) {
            request.headers().set("x-ms-client-request-id", UUID.randomUUID().toString());
            return this.nextPolicy.sendAsync(request);
        }
    }
}

