/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.GeneratedStorageClient;
import com.microsoft.azure.storage.blob.models.BlobHTTPHeaders;
import com.microsoft.azure.storage.blob.models.BlockBlobCommitBlockListResponse;
import com.microsoft.azure.storage.blob.models.BlockBlobGetBlockListResponse;
import com.microsoft.azure.storage.blob.models.BlockBlobStageBlockFromURLResponse;
import com.microsoft.azure.storage.blob.models.BlockBlobStageBlockResponse;
import com.microsoft.azure.storage.blob.models.BlockBlobUploadResponse;
import com.microsoft.azure.storage.blob.models.BlockList;
import com.microsoft.azure.storage.blob.models.BlockListType;
import com.microsoft.azure.storage.blob.models.BlockLookupList;
import com.microsoft.azure.storage.blob.models.LeaseAccessConditions;
import com.microsoft.azure.storage.blob.models.ModifiedAccessConditions;
import com.microsoft.azure.storage.blob.models.SourceModifiedAccessConditions;
import com.microsoft.azure.storage.blob.models.StorageErrorException;
import com.microsoft.rest.v2.Context;
import com.microsoft.rest.v2.DateTimeRfc1123;
import com.microsoft.rest.v2.RestProxy;
import com.microsoft.rest.v2.ServiceCallback;
import com.microsoft.rest.v2.ServiceClient;
import com.microsoft.rest.v2.ServiceFuture;
import com.microsoft.rest.v2.Validator;
import com.microsoft.rest.v2.annotations.BodyParam;
import com.microsoft.rest.v2.annotations.ExpectedResponses;
import com.microsoft.rest.v2.annotations.GET;
import com.microsoft.rest.v2.annotations.HeaderParam;
import com.microsoft.rest.v2.annotations.Host;
import com.microsoft.rest.v2.annotations.HostParam;
import com.microsoft.rest.v2.annotations.PUT;
import com.microsoft.rest.v2.annotations.QueryParam;
import com.microsoft.rest.v2.annotations.UnexpectedResponseExceptionType;
import com.microsoft.rest.v2.util.Base64Util;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.annotations.NonNull;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.Map;

public final class GeneratedBlockBlobs {
    private BlockBlobsService service;
    private GeneratedStorageClient client;

    public GeneratedBlockBlobs(GeneratedStorageClient client) {
        this.service = (BlockBlobsService)RestProxy.create(BlockBlobsService.class, (ServiceClient)client);
        this.client = client;
    }

    public void upload(Context context, @NonNull Flowable<ByteBuffer> body, @NonNull long contentLength, Integer timeout, Map<String, String> metadata, String requestId, BlobHTTPHeaders blobHTTPHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        this.uploadAsync(context, body, contentLength, timeout, metadata, requestId, blobHTTPHeaders, leaseAccessConditions, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> uploadAsync(Context context, @NonNull Flowable<ByteBuffer> body, @NonNull long contentLength, Integer timeout, Map<String, String> metadata, String requestId, BlobHTTPHeaders blobHTTPHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.uploadAsync(context, body, contentLength, timeout, metadata, requestId, blobHTTPHeaders, leaseAccessConditions, modifiedAccessConditions), serviceCallback);
    }

    public Single<BlockBlobUploadResponse> uploadWithRestResponseAsync(Context context, @NonNull Flowable<ByteBuffer> body, @NonNull long contentLength, Integer timeout, Map<String, String> metadata, String requestId, BlobHTTPHeaders blobHTTPHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(metadata);
        Validator.validate((Object)blobHTTPHeaders);
        Validator.validate((Object)leaseAccessConditions);
        Validator.validate((Object)modifiedAccessConditions);
        String blobContentType = null;
        if (blobHTTPHeaders != null) {
            blobContentType = blobHTTPHeaders.blobContentType();
        }
        String blobContentEncoding = null;
        if (blobHTTPHeaders != null) {
            blobContentEncoding = blobHTTPHeaders.blobContentEncoding();
        }
        String blobContentLanguage = null;
        if (blobHTTPHeaders != null) {
            blobContentLanguage = blobHTTPHeaders.blobContentLanguage();
        }
        byte[] blobContentMD5 = null;
        if (blobHTTPHeaders != null) {
            blobContentMD5 = blobHTTPHeaders.blobContentMD5();
        }
        String blobCacheControl = null;
        if (blobHTTPHeaders != null) {
            blobCacheControl = blobHTTPHeaders.blobCacheControl();
        }
        String blobContentDisposition = null;
        if (blobHTTPHeaders != null) {
            blobContentDisposition = blobHTTPHeaders.blobContentDisposition();
        }
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        String blobContentMD5Converted = Base64Util.encodeToString((byte[])blobContentMD5);
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.upload(context, this.client.url(), body, timeout, contentLength, metadata, this.client.version(), requestId, "BlockBlob", blobContentType, blobContentEncoding, blobContentLanguage, blobContentMD5Converted, blobCacheControl, blobContentDisposition, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch);
    }

    public Completable uploadAsync(Context context, @NonNull Flowable<ByteBuffer> body, @NonNull long contentLength, Integer timeout, Map<String, String> metadata, String requestId, BlobHTTPHeaders blobHTTPHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.uploadWithRestResponseAsync(context, body, contentLength, timeout, metadata, requestId, blobHTTPHeaders, leaseAccessConditions, modifiedAccessConditions).toCompletable();
    }

    public void stageBlock(Context context, @NonNull String blockId, @NonNull long contentLength, @NonNull Flowable<ByteBuffer> body, byte[] transactionalContentMD5, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        this.stageBlockAsync(context, blockId, contentLength, body, transactionalContentMD5, timeout, requestId, leaseAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> stageBlockAsync(Context context, @NonNull String blockId, @NonNull long contentLength, @NonNull Flowable<ByteBuffer> body, byte[] transactionalContentMD5, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.stageBlockAsync(context, blockId, contentLength, body, transactionalContentMD5, timeout, requestId, leaseAccessConditions), serviceCallback);
    }

    public Single<BlockBlobStageBlockResponse> stageBlockWithRestResponseAsync(Context context, @NonNull String blockId, @NonNull long contentLength, @NonNull Flowable<ByteBuffer> body, byte[] transactionalContentMD5, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (blockId == null) {
            throw new IllegalArgumentException("Parameter blockId is required and cannot be null.");
        }
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)leaseAccessConditions);
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        String transactionalContentMD5Converted = Base64Util.encodeToString((byte[])transactionalContentMD5);
        return this.service.stageBlock(context, this.client.url(), blockId, contentLength, transactionalContentMD5Converted, body, timeout, this.client.version(), requestId, "block", leaseId);
    }

    public Completable stageBlockAsync(Context context, @NonNull String blockId, @NonNull long contentLength, @NonNull Flowable<ByteBuffer> body, byte[] transactionalContentMD5, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        return this.stageBlockWithRestResponseAsync(context, blockId, contentLength, body, transactionalContentMD5, timeout, requestId, leaseAccessConditions).toCompletable();
    }

    public void stageBlockFromURL(Context context, @NonNull String blockId, @NonNull long contentLength, @NonNull URL sourceUrl, String sourceRange, byte[] sourceContentMD5, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions) {
        this.stageBlockFromURLAsync(context, blockId, contentLength, sourceUrl, sourceRange, sourceContentMD5, timeout, requestId, leaseAccessConditions, sourceModifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> stageBlockFromURLAsync(Context context, @NonNull String blockId, @NonNull long contentLength, @NonNull URL sourceUrl, String sourceRange, byte[] sourceContentMD5, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.stageBlockFromURLAsync(context, blockId, contentLength, sourceUrl, sourceRange, sourceContentMD5, timeout, requestId, leaseAccessConditions, sourceModifiedAccessConditions), serviceCallback);
    }

    public Single<BlockBlobStageBlockFromURLResponse> stageBlockFromURLWithRestResponseAsync(Context context, @NonNull String blockId, @NonNull long contentLength, @NonNull URL sourceUrl, String sourceRange, byte[] sourceContentMD5, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (blockId == null) {
            throw new IllegalArgumentException("Parameter blockId is required and cannot be null.");
        }
        if (sourceUrl == null) {
            throw new IllegalArgumentException("Parameter sourceUrl is required and cannot be null.");
        }
        Validator.validate((Object)sourceUrl);
        Validator.validate((Object)leaseAccessConditions);
        Validator.validate((Object)sourceModifiedAccessConditions);
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime sourceIfModifiedSince = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfModifiedSince = sourceModifiedAccessConditions.sourceIfModifiedSince();
        }
        OffsetDateTime sourceIfUnmodifiedSince = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfUnmodifiedSince = sourceModifiedAccessConditions.sourceIfUnmodifiedSince();
        }
        String sourceIfMatch = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatch = sourceModifiedAccessConditions.sourceIfMatch();
        }
        String sourceIfNoneMatch = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatch = sourceModifiedAccessConditions.sourceIfNoneMatch();
        }
        String sourceContentMD5Converted = Base64Util.encodeToString((byte[])sourceContentMD5);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = null;
        if (sourceIfModifiedSince != null) {
            sourceIfModifiedSinceConverted = new DateTimeRfc1123(sourceIfModifiedSince);
        }
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = null;
        if (sourceIfUnmodifiedSince != null) {
            sourceIfUnmodifiedSinceConverted = new DateTimeRfc1123(sourceIfUnmodifiedSince);
        }
        return this.service.stageBlockFromURL(context, this.client.url(), blockId, contentLength, sourceUrl, sourceRange, sourceContentMD5Converted, timeout, this.client.version(), requestId, "block", leaseId, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch);
    }

    public Completable stageBlockFromURLAsync(Context context, @NonNull String blockId, @NonNull long contentLength, @NonNull URL sourceUrl, String sourceRange, byte[] sourceContentMD5, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions) {
        return this.stageBlockFromURLWithRestResponseAsync(context, blockId, contentLength, sourceUrl, sourceRange, sourceContentMD5, timeout, requestId, leaseAccessConditions, sourceModifiedAccessConditions).toCompletable();
    }

    public void commitBlockList(Context context, @NonNull BlockLookupList blocks, Integer timeout, Map<String, String> metadata, String requestId, BlobHTTPHeaders blobHTTPHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        this.commitBlockListAsync(context, blocks, timeout, metadata, requestId, blobHTTPHeaders, leaseAccessConditions, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> commitBlockListAsync(Context context, @NonNull BlockLookupList blocks, Integer timeout, Map<String, String> metadata, String requestId, BlobHTTPHeaders blobHTTPHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.commitBlockListAsync(context, blocks, timeout, metadata, requestId, blobHTTPHeaders, leaseAccessConditions, modifiedAccessConditions), serviceCallback);
    }

    public Single<BlockBlobCommitBlockListResponse> commitBlockListWithRestResponseAsync(Context context, @NonNull BlockLookupList blocks, Integer timeout, Map<String, String> metadata, String requestId, BlobHTTPHeaders blobHTTPHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (blocks == null) {
            throw new IllegalArgumentException("Parameter blocks is required and cannot be null.");
        }
        Validator.validate(metadata);
        Validator.validate((Object)blocks);
        Validator.validate((Object)blobHTTPHeaders);
        Validator.validate((Object)leaseAccessConditions);
        Validator.validate((Object)modifiedAccessConditions);
        String blobCacheControl = null;
        if (blobHTTPHeaders != null) {
            blobCacheControl = blobHTTPHeaders.blobCacheControl();
        }
        String blobContentType = null;
        if (blobHTTPHeaders != null) {
            blobContentType = blobHTTPHeaders.blobContentType();
        }
        String blobContentEncoding = null;
        if (blobHTTPHeaders != null) {
            blobContentEncoding = blobHTTPHeaders.blobContentEncoding();
        }
        String blobContentLanguage = null;
        if (blobHTTPHeaders != null) {
            blobContentLanguage = blobHTTPHeaders.blobContentLanguage();
        }
        byte[] blobContentMD5 = null;
        if (blobHTTPHeaders != null) {
            blobContentMD5 = blobHTTPHeaders.blobContentMD5();
        }
        String blobContentDisposition = null;
        if (blobHTTPHeaders != null) {
            blobContentDisposition = blobHTTPHeaders.blobContentDisposition();
        }
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        String blobContentMD5Converted = Base64Util.encodeToString((byte[])blobContentMD5);
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.commitBlockList(context, this.client.url(), timeout, metadata, blocks, this.client.version(), requestId, "blocklist", blobCacheControl, blobContentType, blobContentEncoding, blobContentLanguage, blobContentMD5Converted, blobContentDisposition, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch);
    }

    public Completable commitBlockListAsync(Context context, @NonNull BlockLookupList blocks, Integer timeout, Map<String, String> metadata, String requestId, BlobHTTPHeaders blobHTTPHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.commitBlockListWithRestResponseAsync(context, blocks, timeout, metadata, requestId, blobHTTPHeaders, leaseAccessConditions, modifiedAccessConditions).toCompletable();
    }

    public BlockList getBlockList(Context context, @NonNull BlockListType listType, String snapshot, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        return (BlockList)this.getBlockListAsync(context, listType, snapshot, timeout, requestId, leaseAccessConditions).blockingGet();
    }

    public ServiceFuture<BlockList> getBlockListAsync(Context context, @NonNull BlockListType listType, String snapshot, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ServiceCallback<BlockList> serviceCallback) {
        return ServiceFuture.fromBody(this.getBlockListAsync(context, listType, snapshot, timeout, requestId, leaseAccessConditions), serviceCallback);
    }

    public Single<BlockBlobGetBlockListResponse> getBlockListWithRestResponseAsync(Context context, @NonNull BlockListType listType, String snapshot, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (listType == null) {
            throw new IllegalArgumentException("Parameter listType is required and cannot be null.");
        }
        Validator.validate((Object)leaseAccessConditions);
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        return this.service.getBlockList(context, this.client.url(), snapshot, listType, timeout, this.client.version(), requestId, "blocklist", leaseId);
    }

    public Maybe<BlockList> getBlockListAsync(Context context, @NonNull BlockListType listType, String snapshot, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        return this.getBlockListWithRestResponseAsync(context, listType, snapshot, timeout, requestId, leaseAccessConditions).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    @Host(value="{url}")
    private static interface BlockBlobsService {
        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlockBlobUploadResponse> upload(Context var1, @HostParam(value="url") String var2, @BodyParam(value="application/octet-stream") Flowable<ByteBuffer> var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="Content-Length") long var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="x-ms-blob-type") String var10, @HeaderParam(value="x-ms-blob-content-type") String var11, @HeaderParam(value="x-ms-blob-content-encoding") String var12, @HeaderParam(value="x-ms-blob-content-language") String var13, @HeaderParam(value="x-ms-blob-content-md5") String var14, @HeaderParam(value="x-ms-blob-cache-control") String var15, @HeaderParam(value="x-ms-blob-content-disposition") String var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var18, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var19, @HeaderParam(value="If-Match") String var20, @HeaderParam(value="If-None-Match") String var21);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlockBlobStageBlockResponse> stageBlock(Context var1, @HostParam(value="url") String var2, @QueryParam(value="blockid") String var3, @HeaderParam(value="Content-Length") long var4, @HeaderParam(value="Content-MD5") String var6, @BodyParam(value="application/octet-stream") Flowable<ByteBuffer> var7, @QueryParam(value="timeout") Integer var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @QueryParam(value="comp") String var11, @HeaderParam(value="x-ms-lease-id") String var12);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlockBlobStageBlockFromURLResponse> stageBlockFromURL(Context var1, @HostParam(value="url") String var2, @QueryParam(value="blockid") String var3, @HeaderParam(value="Content-Length") long var4, @HeaderParam(value="x-ms-copy-source") URL var6, @HeaderParam(value="x-ms-source-range") String var7, @HeaderParam(value="x-ms-source-content-md5") String var8, @QueryParam(value="timeout") Integer var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @QueryParam(value="comp") String var12, @HeaderParam(value="x-ms-lease-id") String var13, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var14, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var15, @HeaderParam(value="x-ms-source-if-match") String var16, @HeaderParam(value="x-ms-source-if-none-match") String var17);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlockBlobCommitBlockListResponse> commitBlockList(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @BodyParam(value="application/xml; charset=utf-8") BlockLookupList var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @HeaderParam(value="x-ms-blob-cache-control") String var9, @HeaderParam(value="x-ms-blob-content-type") String var10, @HeaderParam(value="x-ms-blob-content-encoding") String var11, @HeaderParam(value="x-ms-blob-content-language") String var12, @HeaderParam(value="x-ms-blob-content-md5") String var13, @HeaderParam(value="x-ms-blob-content-disposition") String var14, @HeaderParam(value="x-ms-lease-id") String var15, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var16, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var17, @HeaderParam(value="If-Match") String var18, @HeaderParam(value="If-None-Match") String var19);

        @GET(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<BlockBlobGetBlockListResponse> getBlockList(Context var1, @HostParam(value="url") String var2, @QueryParam(value="snapshot") String var3, @QueryParam(value="blocklisttype") BlockListType var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @HeaderParam(value="x-ms-lease-id") String var9);
    }
}

