/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.trafficmanager.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.trafficmanager.implementation.HeatMapModelInner;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerManagementClientImpl;
import com.microsoft.rest.CollectionFormat;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class HeatMapsInner {
    private HeatMapsService service;
    private TrafficManagerManagementClientImpl client;

    public HeatMapsInner(Retrofit retrofit, TrafficManagerManagementClientImpl client) {
        this.service = (HeatMapsService)retrofit.create(HeatMapsService.class);
        this.client = client;
    }

    public HeatMapModelInner get(String resourceGroupName, String profileName) {
        return (HeatMapModelInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, profileName).toBlocking().single()).body();
    }

    public ServiceFuture<HeatMapModelInner> getAsync(String resourceGroupName, String profileName, ServiceCallback<HeatMapModelInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, profileName), serviceCallback);
    }

    public Observable<HeatMapModelInner> getAsync(String resourceGroupName, String profileName) {
        return this.getWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<HeatMapModelInner>, HeatMapModelInner>(){

            public HeatMapModelInner call(ServiceResponse<HeatMapModelInner> response) {
                return (HeatMapModelInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<HeatMapModelInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String heatMapType = "default";
        List topLeft = null;
        List botRight = null;
        String topLeftConverted = this.client.serializerAdapter().serializeList(topLeft, CollectionFormat.CSV);
        String botRightConverted = this.client.serializerAdapter().serializeList(botRight, CollectionFormat.CSV);
        return this.service.get(this.client.subscriptionId(), resourceGroupName, profileName, "default", topLeftConverted, botRightConverted, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<HeatMapModelInner>>>(){

            public Observable<ServiceResponse<HeatMapModelInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = HeatMapsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public HeatMapModelInner get(String resourceGroupName, String profileName, List<Double> topLeft, List<Double> botRight) {
        return (HeatMapModelInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, profileName, topLeft, botRight).toBlocking().single()).body();
    }

    public ServiceFuture<HeatMapModelInner> getAsync(String resourceGroupName, String profileName, List<Double> topLeft, List<Double> botRight, ServiceCallback<HeatMapModelInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, profileName, topLeft, botRight), serviceCallback);
    }

    public Observable<HeatMapModelInner> getAsync(String resourceGroupName, String profileName, List<Double> topLeft, List<Double> botRight) {
        return this.getWithServiceResponseAsync(resourceGroupName, profileName, topLeft, botRight).map((Func1)new Func1<ServiceResponse<HeatMapModelInner>, HeatMapModelInner>(){

            public HeatMapModelInner call(ServiceResponse<HeatMapModelInner> response) {
                return (HeatMapModelInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<HeatMapModelInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, List<Double> topLeft, List<Double> botRight) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(topLeft);
        Validator.validate(botRight);
        String heatMapType = "default";
        String topLeftConverted = this.client.serializerAdapter().serializeList(topLeft, CollectionFormat.CSV);
        String botRightConverted = this.client.serializerAdapter().serializeList(botRight, CollectionFormat.CSV);
        return this.service.get(this.client.subscriptionId(), resourceGroupName, profileName, "default", topLeftConverted, botRightConverted, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<HeatMapModelInner>>>(){

            public Observable<ServiceResponse<HeatMapModelInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = HeatMapsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<HeatMapModelInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<HeatMapModelInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface HeatMapsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.trafficmanager.HeatMaps get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}/heatMaps/{heatMapType}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="profileName") String var3, @Path(value="heatMapType") String var4, @Query(value="topLeft") String var5, @Query(value="botRight") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);
    }
}

