/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewayAuthenticationCertificate;
import com.microsoft.azure.management.network.ApplicationGatewayBackend;
import com.microsoft.azure.management.network.ApplicationGatewayBackendHealth;
import com.microsoft.azure.management.network.ApplicationGatewayBackendHealthPool;
import com.microsoft.azure.management.network.ApplicationGatewayBackendHttpConfiguration;
import com.microsoft.azure.management.network.ApplicationGatewayFrontend;
import com.microsoft.azure.management.network.ApplicationGatewayIPConfiguration;
import com.microsoft.azure.management.network.ApplicationGatewayListener;
import com.microsoft.azure.management.network.ApplicationGatewayOperationalState;
import com.microsoft.azure.management.network.ApplicationGatewayProbe;
import com.microsoft.azure.management.network.ApplicationGatewayRedirectConfiguration;
import com.microsoft.azure.management.network.ApplicationGatewayRequestRoutingRule;
import com.microsoft.azure.management.network.ApplicationGatewaySku;
import com.microsoft.azure.management.network.ApplicationGatewaySkuName;
import com.microsoft.azure.management.network.ApplicationGatewaySslCertificate;
import com.microsoft.azure.management.network.ApplicationGatewaySslPolicy;
import com.microsoft.azure.management.network.ApplicationGatewaySslProtocol;
import com.microsoft.azure.management.network.ApplicationGatewayTier;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayAuthenticationCertificateImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayAuthenticationCertificateInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendAddressPoolInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendHealthImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendHealthInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendHttpConfigurationImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendHttpSettingsInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayFrontendIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayFrontendImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayFrontendPortInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayHttpListenerInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayIPConfigurationImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayListenerImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayProbeImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayProbeInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayRedirectConfigurationImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayRedirectConfigurationInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayRequestRoutingRuleImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayRequestRoutingRuleInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewaySslCertificateImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewaySslCertificateInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewaysInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.AvailabilityZoneId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class ApplicationGatewayImpl
extends GroupableParentResourceImpl<ApplicationGateway, ApplicationGatewayInner, ApplicationGatewayImpl, NetworkManager>
implements ApplicationGateway,
ApplicationGateway.Definition,
ApplicationGateway.Update {
    private Map<String, ApplicationGatewayIPConfiguration> ipConfigs;
    private Map<String, ApplicationGatewayFrontend> frontends;
    private Map<String, ApplicationGatewayProbe> probes;
    private Map<String, ApplicationGatewayBackend> backends;
    private Map<String, ApplicationGatewayBackendHttpConfiguration> backendConfigs;
    private Map<String, ApplicationGatewayListener> listeners;
    private Map<String, ApplicationGatewayRequestRoutingRule> rules;
    private Map<String, ApplicationGatewaySslCertificate> sslCerts;
    private Map<String, ApplicationGatewayAuthenticationCertificate> authCertificates;
    private Map<String, ApplicationGatewayRedirectConfiguration> redirectConfigs;
    private static final String DEFAULT = "default";
    private ApplicationGatewayFrontendImpl defaultPrivateFrontend;
    private ApplicationGatewayFrontendImpl defaultPublicFrontend;
    private Map<String, String> creatablePipsByFrontend;
    private Creatable<Network> creatableNetwork = null;
    private Creatable<PublicIPAddress> creatablePip = null;

    ApplicationGatewayImpl(String name, ApplicationGatewayInner innerModel, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (ManagerBase)networkManager);
    }

    public Observable<ApplicationGateway> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<ApplicationGateway, ApplicationGateway>(){

            public ApplicationGateway call(ApplicationGateway applicationGateway) {
                ApplicationGatewayImpl impl = (ApplicationGatewayImpl)applicationGateway;
                impl.initializeChildrenFromInner();
                return impl;
            }
        });
    }

    protected Observable<ApplicationGatewayInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).applicationGateways().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    protected void initializeChildrenFromInner() {
        this.initializeConfigsFromInner();
        this.initializeFrontendsFromInner();
        this.initializeProbesFromInner();
        this.initializeBackendsFromInner();
        this.initializeBackendHttpConfigsFromInner();
        this.initializeHttpListenersFromInner();
        this.initializeRedirectConfigurationsFromInner();
        this.initializeRequestRoutingRulesFromInner();
        this.initializeSslCertificatesFromInner();
        this.initializeAuthCertificatesFromInner();
        this.defaultPrivateFrontend = null;
        this.defaultPublicFrontend = null;
        this.creatablePipsByFrontend = new HashMap<String, String>();
    }

    private void initializeAuthCertificatesFromInner() {
        this.authCertificates = new TreeMap<String, ApplicationGatewayAuthenticationCertificate>();
        List<ApplicationGatewayAuthenticationCertificateInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).authenticationCertificates();
        if (inners != null) {
            for (ApplicationGatewayAuthenticationCertificateInner inner : inners) {
                ApplicationGatewayAuthenticationCertificateImpl cert = new ApplicationGatewayAuthenticationCertificateImpl(inner, this);
                this.authCertificates.put(inner.name(), cert);
            }
        }
    }

    private void initializeSslCertificatesFromInner() {
        this.sslCerts = new TreeMap<String, ApplicationGatewaySslCertificate>();
        List<ApplicationGatewaySslCertificateInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).sslCertificates();
        if (inners != null) {
            for (ApplicationGatewaySslCertificateInner inner : inners) {
                ApplicationGatewaySslCertificateImpl cert = new ApplicationGatewaySslCertificateImpl(inner, this);
                this.sslCerts.put(inner.name(), cert);
            }
        }
    }

    private void initializeFrontendsFromInner() {
        this.frontends = new TreeMap<String, ApplicationGatewayFrontend>();
        List<ApplicationGatewayFrontendIPConfigurationInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).frontendIPConfigurations();
        if (inners != null) {
            for (ApplicationGatewayFrontendIPConfigurationInner inner : inners) {
                ApplicationGatewayFrontendImpl frontend = new ApplicationGatewayFrontendImpl(inner, this);
                this.frontends.put(inner.name(), frontend);
            }
        }
    }

    private void initializeProbesFromInner() {
        this.probes = new TreeMap<String, ApplicationGatewayProbe>();
        List<ApplicationGatewayProbeInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).probes();
        if (inners != null) {
            for (ApplicationGatewayProbeInner inner : inners) {
                ApplicationGatewayProbeImpl probe = new ApplicationGatewayProbeImpl(inner, this);
                this.probes.put(inner.name(), probe);
            }
        }
    }

    private void initializeBackendsFromInner() {
        this.backends = new TreeMap<String, ApplicationGatewayBackend>();
        List<ApplicationGatewayBackendAddressPoolInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).backendAddressPools();
        if (inners != null) {
            for (ApplicationGatewayBackendAddressPoolInner inner : inners) {
                ApplicationGatewayBackendImpl backend = new ApplicationGatewayBackendImpl(inner, this);
                this.backends.put(inner.name(), backend);
            }
        }
    }

    private void initializeBackendHttpConfigsFromInner() {
        this.backendConfigs = new TreeMap<String, ApplicationGatewayBackendHttpConfiguration>();
        List<ApplicationGatewayBackendHttpSettingsInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).backendHttpSettingsCollection();
        if (inners != null) {
            for (ApplicationGatewayBackendHttpSettingsInner inner : inners) {
                ApplicationGatewayBackendHttpConfigurationImpl httpConfig = new ApplicationGatewayBackendHttpConfigurationImpl(inner, this);
                this.backendConfigs.put(inner.name(), httpConfig);
            }
        }
    }

    private void initializeHttpListenersFromInner() {
        this.listeners = new TreeMap<String, ApplicationGatewayListener>();
        List<ApplicationGatewayHttpListenerInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).httpListeners();
        if (inners != null) {
            for (ApplicationGatewayHttpListenerInner inner : inners) {
                ApplicationGatewayListenerImpl httpListener = new ApplicationGatewayListenerImpl(inner, this);
                this.listeners.put(inner.name(), httpListener);
            }
        }
    }

    private void initializeRedirectConfigurationsFromInner() {
        this.redirectConfigs = new TreeMap<String, ApplicationGatewayRedirectConfiguration>();
        List<ApplicationGatewayRedirectConfigurationInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).redirectConfigurations();
        if (inners != null) {
            for (ApplicationGatewayRedirectConfigurationInner inner : inners) {
                ApplicationGatewayRedirectConfigurationImpl redirectConfig = new ApplicationGatewayRedirectConfigurationImpl(inner, this);
                this.redirectConfigs.put(inner.name(), redirectConfig);
            }
        }
    }

    private void initializeRequestRoutingRulesFromInner() {
        this.rules = new TreeMap<String, ApplicationGatewayRequestRoutingRule>();
        List<ApplicationGatewayRequestRoutingRuleInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).requestRoutingRules();
        if (inners != null) {
            for (ApplicationGatewayRequestRoutingRuleInner inner : inners) {
                ApplicationGatewayRequestRoutingRuleImpl rule = new ApplicationGatewayRequestRoutingRuleImpl(inner, this);
                this.rules.put(inner.name(), rule);
            }
        }
    }

    private void initializeConfigsFromInner() {
        this.ipConfigs = new TreeMap<String, ApplicationGatewayIPConfiguration>();
        List<ApplicationGatewayIPConfigurationInner> inners = ((ApplicationGatewayInner)((Object)this.inner())).gatewayIPConfigurations();
        if (inners != null) {
            for (ApplicationGatewayIPConfigurationInner inner : inners) {
                ApplicationGatewayIPConfigurationImpl config = new ApplicationGatewayIPConfigurationImpl(inner, this);
                this.ipConfigs.put(inner.name(), config);
            }
        }
    }

    protected void beforeCreating() {
        SubResource ref;
        for (Map.Entry<String, String> frontendPipPair : this.creatablePipsByFrontend.entrySet()) {
            com.microsoft.azure.management.resources.fluentcore.arm.models.Resource createdPip = (com.microsoft.azure.management.resources.fluentcore.arm.models.Resource)this.taskResult(frontendPipPair.getValue());
            this.updateFrontend(frontendPipPair.getKey()).withExistingPublicIPAddress(createdPip.id());
        }
        this.creatablePipsByFrontend.clear();
        this.ensureDefaultIPConfig();
        ((ApplicationGatewayInner)((Object)this.inner())).withGatewayIPConfigurations(this.innersFromWrappers(this.ipConfigs.values()));
        ((ApplicationGatewayInner)((Object)this.inner())).withFrontendIPConfigurations(this.innersFromWrappers(this.frontends.values()));
        ((ApplicationGatewayInner)((Object)this.inner())).withProbes(this.innersFromWrappers(this.probes.values()));
        ((ApplicationGatewayInner)((Object)this.inner())).withAuthenticationCertificates(this.innersFromWrappers(this.authCertificates.values()));
        ((ApplicationGatewayInner)((Object)this.inner())).withBackendAddressPools(this.innersFromWrappers(this.backends.values()));
        ((ApplicationGatewayInner)((Object)this.inner())).withSslCertificates(this.innersFromWrappers(this.sslCerts.values()));
        ((ApplicationGatewayInner)((Object)this.inner())).withBackendHttpSettingsCollection(this.innersFromWrappers(this.backendConfigs.values()));
        for (ApplicationGatewayBackendHttpConfiguration config : this.backendConfigs.values()) {
            List<SubResource> certRefs;
            ref = ((ApplicationGatewayBackendHttpSettingsInner)((Object)config.inner())).probe();
            if (ref != null && !this.probes().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayBackendHttpSettingsInner)((Object)config.inner())).withProbe(null);
            }
            if ((certRefs = ((ApplicationGatewayBackendHttpSettingsInner)((Object)config.inner())).authenticationCertificates()) == null) continue;
            certRefs = new ArrayList<SubResource>(certRefs);
            for (SubResource certRef : certRefs) {
                if (certRef == null || this.authCertificates.containsKey(ResourceUtils.nameFromResourceId((String)certRef.id()))) continue;
                ((ApplicationGatewayBackendHttpSettingsInner)((Object)config.inner())).authenticationCertificates().remove(certRef);
            }
        }
        ((ApplicationGatewayInner)((Object)this.inner())).withRedirectConfigurations(this.innersFromWrappers(this.redirectConfigs.values()));
        for (ApplicationGatewayRedirectConfiguration redirect : this.redirectConfigs.values()) {
            ref = ((ApplicationGatewayRedirectConfigurationInner)((Object)redirect.inner())).targetListener();
            if (ref == null || this.listeners.containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) continue;
            ((ApplicationGatewayRedirectConfigurationInner)((Object)redirect.inner())).withTargetListener(null);
        }
        ((ApplicationGatewayInner)((Object)this.inner())).withHttpListeners(this.innersFromWrappers(this.listeners.values()));
        for (ApplicationGatewayListener listener : this.listeners.values()) {
            ref = ((ApplicationGatewayHttpListenerInner)((Object)listener.inner())).frontendIPConfiguration();
            if (ref != null && !this.frontends().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayHttpListenerInner)((Object)listener.inner())).withFrontendIPConfiguration(null);
            }
            if ((ref = ((ApplicationGatewayHttpListenerInner)((Object)listener.inner())).frontendPort()) != null && !this.frontendPorts().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayHttpListenerInner)((Object)listener.inner())).withFrontendPort(null);
            }
            if ((ref = ((ApplicationGatewayHttpListenerInner)((Object)listener.inner())).sslCertificate()) == null || this.sslCertificates().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) continue;
            ((ApplicationGatewayHttpListenerInner)((Object)listener.inner())).withSslCertificate(null);
        }
        ((ApplicationGatewayInner)((Object)this.inner())).withRequestRoutingRules(this.innersFromWrappers(this.rules.values()));
        for (ApplicationGatewayRequestRoutingRule rule : this.rules.values()) {
            ref = ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.inner())).redirectConfiguration();
            if (ref != null && !this.redirectConfigs.containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.inner())).withRedirectConfiguration(null);
            }
            if ((ref = ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.inner())).backendAddressPool()) != null && !this.backends().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.inner())).withBackendAddressPool(null);
            }
            if ((ref = ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.inner())).backendHttpSettings()) != null && !this.backendConfigs.containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.inner())).withBackendHttpSettings(null);
            }
            if ((ref = ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.inner())).httpListener()) == null || this.listeners().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) continue;
            ((ApplicationGatewayRequestRoutingRuleInner)((Object)rule.inner())).withHttpListener(null);
        }
    }

    protected void afterCreating() {
    }

    protected SubResource ensureBackendRef(String name) {
        ApplicationGatewayBackendImpl backend;
        if (name == null) {
            backend = this.ensureUniqueBackend();
        } else {
            backend = this.defineBackend(name);
            backend.attach();
        }
        return new SubResource().withId(this.futureResourceId() + "/backendAddressPools/" + backend.name());
    }

    protected ApplicationGatewayBackendImpl ensureUniqueBackend() {
        String name = SdkContext.randomResourceName((String)"backend", (int)20);
        ApplicationGatewayBackendImpl backend = this.defineBackend(name);
        backend.attach();
        return backend;
    }

    private ApplicationGatewayIPConfigurationImpl ensureDefaultIPConfig() {
        ApplicationGatewayIPConfigurationImpl ipConfig = (ApplicationGatewayIPConfigurationImpl)this.defaultIPConfiguration();
        if (ipConfig == null) {
            String name = SdkContext.randomResourceName((String)"ipcfg", (int)11);
            ipConfig = this.defineIPConfiguration(name);
            ipConfig.attach();
        }
        return ipConfig;
    }

    protected ApplicationGatewayFrontendImpl ensureDefaultPrivateFrontend() {
        ApplicationGatewayFrontendImpl frontend = (ApplicationGatewayFrontendImpl)this.defaultPrivateFrontend();
        if (frontend != null) {
            return frontend;
        }
        String name = SdkContext.randomResourceName((String)"frontend", (int)14);
        frontend = this.defineFrontend(name);
        frontend.attach();
        this.defaultPrivateFrontend = frontend;
        return frontend;
    }

    protected ApplicationGatewayFrontendImpl ensureDefaultPublicFrontend() {
        ApplicationGatewayFrontendImpl frontend = (ApplicationGatewayFrontendImpl)this.defaultPublicFrontend();
        if (frontend != null) {
            return frontend;
        }
        String name = SdkContext.randomResourceName((String)"frontend", (int)14);
        frontend = this.defineFrontend(name);
        frontend.attach();
        this.defaultPublicFrontend = frontend;
        return frontend;
    }

    private Creatable<Network> ensureDefaultNetworkDefinition() {
        if (this.creatableNetwork == null) {
            String vnetName = SdkContext.randomResourceName((String)"vnet", (int)10);
            this.creatableNetwork = ((Network.DefinitionStages.WithCreate)((Network.DefinitionStages.WithGroup)((Network.DefinitionStages.Blank)((NetworkManager)this.manager()).networks().define(vnetName)).withRegion(this.region())).withExistingResourceGroup(this.resourceGroupName())).withAddressSpace("10.0.0.0/24").withSubnet(DEFAULT, "10.0.0.0/25").withSubnet("apps", "10.0.0.128/25");
        }
        return this.creatableNetwork;
    }

    private Creatable<PublicIPAddress> ensureDefaultPipDefinition() {
        if (this.creatablePip == null) {
            String pipName = SdkContext.randomResourceName((String)"pip", (int)9);
            this.creatablePip = (Creatable)((PublicIPAddress.DefinitionStages.WithGroup)((PublicIPAddress.DefinitionStages.Blank)((NetworkManager)this.manager()).publicIPAddresses().define(pipName)).withRegion(this.regionName())).withExistingResourceGroup(this.resourceGroupName());
        }
        return this.creatablePip;
    }

    private static ApplicationGatewayFrontendImpl useSubnetFromIPConfigForFrontend(ApplicationGatewayIPConfigurationImpl ipConfig, ApplicationGatewayFrontendImpl frontend) {
        if (frontend != null) {
            frontend.withExistingSubnet(ipConfig.networkId(), ipConfig.subnetName());
            if (frontend.privateIPAddress() == null) {
                frontend.withPrivateIPAddressDynamic();
            } else if (frontend.privateIPAllocationMethod() == null) {
                frontend.withPrivateIPAddressDynamic();
            }
        }
        return frontend;
    }

    protected Observable<ApplicationGatewayInner> createInner() {
        Observable networkObservable;
        final ApplicationGatewayFrontendImpl defaultPublicFrontend = (ApplicationGatewayFrontendImpl)this.defaultPublicFrontend();
        Observable pipObservable = defaultPublicFrontend != null && defaultPublicFrontend.publicIPAddressId() == null ? Utils.rootResource((Observable)this.ensureDefaultPipDefinition().createAsync()).map((Func1)new Func1<PublicIPAddress, com.microsoft.azure.management.resources.fluentcore.arm.models.Resource>(){

            public com.microsoft.azure.management.resources.fluentcore.arm.models.Resource call(PublicIPAddress publicIPAddress) {
                defaultPublicFrontend.withExistingPublicIPAddress(publicIPAddress);
                return publicIPAddress;
            }
        }) : Observable.empty();
        final ApplicationGatewayIPConfigurationImpl defaultIPConfig = this.ensureDefaultIPConfig();
        final ApplicationGatewayFrontendImpl defaultPrivateFrontend = (ApplicationGatewayFrontendImpl)this.defaultPrivateFrontend();
        if (defaultIPConfig.subnetName() != null) {
            if (defaultPrivateFrontend != null) {
                ApplicationGatewayImpl.useSubnetFromIPConfigForFrontend(defaultIPConfig, defaultPrivateFrontend);
            }
            networkObservable = Observable.empty();
        } else {
            networkObservable = Utils.rootResource((Observable)this.ensureDefaultNetworkDefinition().createAsync()).map((Func1)new Func1<Network, com.microsoft.azure.management.resources.fluentcore.arm.models.Resource>(){

                public com.microsoft.azure.management.resources.fluentcore.arm.models.Resource call(Network network) {
                    defaultIPConfig.withExistingSubnet(network, ApplicationGatewayImpl.DEFAULT);
                    if (defaultPrivateFrontend != null) {
                        ApplicationGatewayImpl.useSubnetFromIPConfigForFrontend(defaultIPConfig, defaultPrivateFrontend);
                    }
                    return network;
                }
            });
        }
        final ApplicationGatewaysInner innerCollection = ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).applicationGateways();
        return Observable.merge((Observable)networkObservable, (Observable)pipObservable).defaultIfEmpty(null).last().flatMap((Func1)new Func1<com.microsoft.azure.management.resources.fluentcore.arm.models.Resource, Observable<ApplicationGatewayInner>>(){

            public Observable<ApplicationGatewayInner> call(com.microsoft.azure.management.resources.fluentcore.arm.models.Resource resource) {
                return innerCollection.createOrUpdateAsync(ApplicationGatewayImpl.this.resourceGroupName(), ApplicationGatewayImpl.this.name(), (ApplicationGatewayInner)((Object)ApplicationGatewayImpl.this.inner()));
            }
        });
    }

    <T> Boolean needToCreate(T byName, T byPort, String name) {
        if (byName != null && byPort != null) {
            if (byName == byPort) {
                return false;
            }
            return null;
        }
        if (byPort != null) {
            if (name == null) {
                return false;
            }
            return null;
        }
        return true;
    }

    String futureResourceId() {
        return super.resourceIdBase() + "/providers/Microsoft.Network/applicationGateways/" + this.name();
    }

    @Override
    public ApplicationGatewayImpl withDisabledSslProtocol(ApplicationGatewaySslProtocol protocol) {
        ApplicationGatewaySslPolicy policy;
        if (protocol != null && !(policy = this.ensureSslPolicy()).disabledSslProtocols().contains(protocol)) {
            policy.disabledSslProtocols().add(protocol);
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withDisabledSslProtocols(ApplicationGatewaySslProtocol ... protocols) {
        if (protocols != null) {
            for (ApplicationGatewaySslProtocol protocol : protocols) {
                this.withDisabledSslProtocol(protocol);
            }
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutDisabledSslProtocol(ApplicationGatewaySslProtocol protocol) {
        if (((ApplicationGatewayInner)((Object)this.inner())).sslPolicy() != null && ((ApplicationGatewayInner)((Object)this.inner())).sslPolicy().disabledSslProtocols() != null) {
            ((ApplicationGatewayInner)((Object)this.inner())).sslPolicy().disabledSslProtocols().remove(protocol);
            if (((ApplicationGatewayInner)((Object)this.inner())).sslPolicy().disabledSslProtocols().isEmpty()) {
                this.withoutAnyDisabledSslProtocols();
            }
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutDisabledSslProtocols(ApplicationGatewaySslProtocol ... protocols) {
        if (protocols != null) {
            for (ApplicationGatewaySslProtocol protocol : protocols) {
                this.withoutDisabledSslProtocol(protocol);
            }
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutAnyDisabledSslProtocols() {
        ((ApplicationGatewayInner)((Object)this.inner())).withSslPolicy(null);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withInstanceCount(int capacity) {
        if (((ApplicationGatewayInner)((Object)this.inner())).sku() == null) {
            this.withSize(ApplicationGatewaySkuName.STANDARD_SMALL);
        }
        ((ApplicationGatewayInner)((Object)this.inner())).sku().withCapacity(capacity);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withPrivateIPAddressDynamic() {
        this.ensureDefaultPrivateFrontend().withPrivateIPAddressDynamic();
        return this;
    }

    @Override
    public ApplicationGatewayImpl withPrivateIPAddressStatic(String ipAddress) {
        this.ensureDefaultPrivateFrontend().withPrivateIPAddressStatic(ipAddress);
        return this;
    }

    ApplicationGatewayImpl withFrontend(ApplicationGatewayFrontendImpl frontend) {
        if (frontend != null) {
            this.frontends.put(frontend.name(), frontend);
        }
        return this;
    }

    ApplicationGatewayImpl withProbe(ApplicationGatewayProbeImpl probe) {
        if (probe != null) {
            this.probes.put(probe.name(), probe);
        }
        return this;
    }

    ApplicationGatewayImpl withBackend(ApplicationGatewayBackendImpl backend) {
        if (backend != null) {
            this.backends.put(backend.name(), backend);
        }
        return this;
    }

    ApplicationGatewayImpl withAuthenticationCertificate(ApplicationGatewayAuthenticationCertificateImpl authCert) {
        if (authCert != null) {
            this.authCertificates.put(authCert.name(), authCert);
        }
        return this;
    }

    ApplicationGatewayImpl withSslCertificate(ApplicationGatewaySslCertificateImpl cert) {
        if (cert != null) {
            this.sslCerts.put(cert.name(), cert);
        }
        return this;
    }

    ApplicationGatewayImpl withHttpListener(ApplicationGatewayListenerImpl httpListener) {
        if (httpListener != null) {
            this.listeners.put(httpListener.name(), httpListener);
        }
        return this;
    }

    ApplicationGatewayImpl withRedirectConfiguration(ApplicationGatewayRedirectConfigurationImpl redirectConfig) {
        if (redirectConfig != null) {
            this.redirectConfigs.put(redirectConfig.name(), redirectConfig);
        }
        return this;
    }

    ApplicationGatewayImpl withRequestRoutingRule(ApplicationGatewayRequestRoutingRuleImpl rule) {
        if (rule != null) {
            this.rules.put(rule.name(), rule);
        }
        return this;
    }

    ApplicationGatewayImpl withBackendHttpConfiguration(ApplicationGatewayBackendHttpConfigurationImpl httpConfig) {
        if (httpConfig != null) {
            this.backendConfigs.put(httpConfig.name(), httpConfig);
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withSize(ApplicationGatewaySkuName skuName) {
        int count = this.sku() != null ? this.sku().capacity() : 1;
        ApplicationGatewaySku sku = new ApplicationGatewaySku().withName(skuName).withCapacity(count);
        ((ApplicationGatewayInner)((Object)this.inner())).withSku(sku);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withExistingSubnet(Subnet subnet) {
        this.ensureDefaultIPConfig().withExistingSubnet(subnet);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withExistingSubnet(Network network, String subnetName) {
        this.ensureDefaultIPConfig().withExistingSubnet(network, subnetName);
        return this;
    }

    public ApplicationGatewayImpl withExistingSubnet(String networkResourceId, String subnetName) {
        this.ensureDefaultIPConfig().withExistingSubnet(networkResourceId, subnetName);
        return this;
    }

    ApplicationGatewayImpl withConfig(ApplicationGatewayIPConfigurationImpl config) {
        if (config != null) {
            this.ipConfigs.put(config.name(), config);
        }
        return this;
    }

    public ApplicationGatewaySslCertificateImpl defineSslCertificate(String name) {
        ApplicationGatewaySslCertificate cert = this.sslCerts.get(name);
        if (cert == null) {
            ApplicationGatewaySslCertificateInner inner = new ApplicationGatewaySslCertificateInner().withName(name);
            return new ApplicationGatewaySslCertificateImpl(inner, this);
        }
        return (ApplicationGatewaySslCertificateImpl)cert;
    }

    private ApplicationGatewayIPConfigurationImpl defineIPConfiguration(String name) {
        ApplicationGatewayIPConfiguration config = this.ipConfigs.get(name);
        if (config == null) {
            ApplicationGatewayIPConfigurationInner inner = new ApplicationGatewayIPConfigurationInner().withName(name);
            return new ApplicationGatewayIPConfigurationImpl(inner, this);
        }
        return (ApplicationGatewayIPConfigurationImpl)config;
    }

    private ApplicationGatewayFrontendImpl defineFrontend(String name) {
        ApplicationGatewayFrontend frontend = this.frontends.get(name);
        if (frontend == null) {
            ApplicationGatewayFrontendIPConfigurationInner inner = new ApplicationGatewayFrontendIPConfigurationInner().withName(name);
            return new ApplicationGatewayFrontendImpl(inner, this);
        }
        return (ApplicationGatewayFrontendImpl)frontend;
    }

    public ApplicationGatewayBackendImpl defineBackend(String name) {
        ApplicationGatewayBackend backend = this.backends.get(name);
        if (backend == null) {
            ApplicationGatewayBackendAddressPoolInner inner = new ApplicationGatewayBackendAddressPoolInner().withName(name);
            return new ApplicationGatewayBackendImpl(inner, this);
        }
        return (ApplicationGatewayBackendImpl)backend;
    }

    public ApplicationGatewayAuthenticationCertificateImpl defineAuthenticationCertificate(String name) {
        ApplicationGatewayAuthenticationCertificate cert = this.authCertificates.get(name);
        if (cert == null) {
            ApplicationGatewayAuthenticationCertificateInner inner = new ApplicationGatewayAuthenticationCertificateInner().withName(name);
            return new ApplicationGatewayAuthenticationCertificateImpl(inner, this);
        }
        return (ApplicationGatewayAuthenticationCertificateImpl)cert;
    }

    public ApplicationGatewayProbeImpl defineProbe(String name) {
        ApplicationGatewayProbe probe = this.probes.get(name);
        if (probe == null) {
            ApplicationGatewayProbeInner inner = new ApplicationGatewayProbeInner().withName(name);
            return new ApplicationGatewayProbeImpl(inner, this);
        }
        return (ApplicationGatewayProbeImpl)probe;
    }

    public ApplicationGatewayListenerImpl defineListener(String name) {
        ApplicationGatewayListener httpListener = this.listeners.get(name);
        if (httpListener == null) {
            ApplicationGatewayHttpListenerInner inner = new ApplicationGatewayHttpListenerInner().withName(name);
            return new ApplicationGatewayListenerImpl(inner, this);
        }
        return (ApplicationGatewayListenerImpl)httpListener;
    }

    public ApplicationGatewayRedirectConfigurationImpl defineRedirectConfiguration(String name) {
        ApplicationGatewayRedirectConfiguration redirectConfig = this.redirectConfigs.get(name);
        if (redirectConfig == null) {
            ApplicationGatewayRedirectConfigurationInner inner = new ApplicationGatewayRedirectConfigurationInner().withName(name);
            return new ApplicationGatewayRedirectConfigurationImpl(inner, this);
        }
        return (ApplicationGatewayRedirectConfigurationImpl)redirectConfig;
    }

    public ApplicationGatewayRequestRoutingRuleImpl defineRequestRoutingRule(String name) {
        ApplicationGatewayRequestRoutingRule rule = this.rules.get(name);
        if (rule == null) {
            ApplicationGatewayRequestRoutingRuleInner inner = new ApplicationGatewayRequestRoutingRuleInner().withName(name);
            return new ApplicationGatewayRequestRoutingRuleImpl(inner, this);
        }
        return (ApplicationGatewayRequestRoutingRuleImpl)rule;
    }

    public ApplicationGatewayBackendHttpConfigurationImpl defineBackendHttpConfiguration(String name) {
        ApplicationGatewayBackendHttpConfiguration httpConfig = this.backendConfigs.get(name);
        if (httpConfig == null) {
            ApplicationGatewayBackendHttpSettingsInner inner = new ApplicationGatewayBackendHttpSettingsInner().withName(name).withPort(80);
            return new ApplicationGatewayBackendHttpConfigurationImpl(inner, this);
        }
        return (ApplicationGatewayBackendHttpConfigurationImpl)httpConfig;
    }

    @Override
    public ApplicationGatewayImpl withoutPrivateFrontend() {
        ArrayList<String> toDelete = new ArrayList<String>();
        for (ApplicationGatewayFrontend frontend : this.frontends.values()) {
            if (!frontend.isPrivate()) continue;
            toDelete.add(frontend.name());
        }
        for (String frontendName : toDelete) {
            this.frontends.remove(frontendName);
        }
        this.defaultPrivateFrontend = null;
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutPublicFrontend() {
        ArrayList<String> toDelete = new ArrayList<String>();
        for (ApplicationGatewayFrontend frontend : this.frontends.values()) {
            if (!frontend.isPublic()) continue;
            toDelete.add(frontend.name());
        }
        for (String frontendName : toDelete) {
            this.frontends.remove(frontendName);
        }
        this.defaultPublicFrontend = null;
        return this;
    }

    @Override
    public ApplicationGatewayImpl withFrontendPort(int portNumber) {
        return this.withFrontendPort(portNumber, null);
    }

    @Override
    public ApplicationGatewayImpl withFrontendPort(int portNumber, String name) {
        List<ApplicationGatewayFrontendPortInner> frontendPorts = ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts();
        if (frontendPorts == null) {
            frontendPorts = new ArrayList<ApplicationGatewayFrontendPortInner>();
            ((ApplicationGatewayInner)((Object)this.inner())).withFrontendPorts(frontendPorts);
        }
        ApplicationGatewayFrontendPortInner frontendPortByName = null;
        ApplicationGatewayFrontendPortInner frontendPortByNumber = null;
        for (ApplicationGatewayFrontendPortInner inner : ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts()) {
            if (name != null && name.equalsIgnoreCase(inner.name())) {
                frontendPortByName = inner;
            }
            if (inner.port() != portNumber) continue;
            frontendPortByNumber = inner;
        }
        Boolean needToCreate = this.needToCreate(frontendPortByName, frontendPortByNumber, name);
        if (Boolean.TRUE.equals(needToCreate)) {
            if (name == null) {
                name = SdkContext.randomResourceName((String)"port", (int)9);
            }
            frontendPortByName = new ApplicationGatewayFrontendPortInner().withName(name).withPort(portNumber);
            frontendPorts.add(frontendPortByName);
            return this;
        }
        if (Boolean.FALSE.equals(needToCreate)) {
            return this;
        }
        return null;
    }

    @Override
    public ApplicationGatewayImpl withPrivateFrontend() {
        this.ensureDefaultPrivateFrontend();
        return this;
    }

    @Override
    public ApplicationGatewayImpl withExistingPublicIPAddress(PublicIPAddress publicIPAddress) {
        this.ensureDefaultPublicFrontend().withExistingPublicIPAddress(publicIPAddress);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withExistingPublicIPAddress(String resourceId) {
        this.ensureDefaultPublicFrontend().withExistingPublicIPAddress(resourceId);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withNewPublicIPAddress(Creatable<PublicIPAddress> creatable) {
        String name = this.ensureDefaultPublicFrontend().name();
        this.creatablePipsByFrontend.put(name, this.addDependency(creatable));
        return this;
    }

    @Override
    public ApplicationGatewayImpl withNewPublicIPAddress() {
        this.ensureDefaultPublicFrontend();
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutBackendFqdn(String fqdn) {
        for (ApplicationGatewayBackend backend : this.backends.values()) {
            ((ApplicationGatewayBackendImpl)backend).withoutFqdn(fqdn);
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutBackendIPAddress(String ipAddress) {
        for (ApplicationGatewayBackend backend : this.backends.values()) {
            ApplicationGatewayBackendImpl backendImpl = (ApplicationGatewayBackendImpl)backend;
            backendImpl.withoutIPAddress(ipAddress);
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutIPConfiguration(String ipConfigurationName) {
        this.ipConfigs.remove(ipConfigurationName);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutFrontend(String frontendName) {
        this.frontends.remove(frontendName);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutFrontendPort(String name) {
        if (((ApplicationGatewayInner)((Object)this.inner())).frontendPorts() == null) {
            return this;
        }
        for (int i = 0; i < ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts().size(); ++i) {
            ApplicationGatewayFrontendPortInner inner = ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts().get(i);
            if (!inner.name().equalsIgnoreCase(name)) continue;
            ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts().remove(i);
            break;
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutFrontendPort(int portNumber) {
        for (int i = 0; i < ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts().size(); ++i) {
            ApplicationGatewayFrontendPortInner inner = ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts().get(i);
            if (!inner.port().equals(portNumber)) continue;
            ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts().remove(i);
            break;
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutCertificate(String name) {
        return this.withoutSslCertificate(name);
    }

    @Override
    public ApplicationGatewayImpl withoutSslCertificate(String name) {
        this.sslCerts.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutAuthenticationCertificate(String name) {
        this.authCertificates.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutProbe(String name) {
        this.probes.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutListener(String name) {
        this.listeners.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutRedirectConfiguration(String name) {
        this.redirectConfigs.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutRequestRoutingRule(String name) {
        this.rules.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withoutBackend(String backendName) {
        this.backends.remove(backendName);
        return this;
    }

    @Override
    public ApplicationGatewayImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (((ApplicationGatewayInner)((Object)this.inner())).zones() == null) {
            ((ApplicationGatewayInner)((Object)this.inner())).withZones(new ArrayList<String>());
        }
        if (!((ApplicationGatewayInner)((Object)this.inner())).zones().contains(zoneId.toString())) {
            ((ApplicationGatewayInner)((Object)this.inner())).zones().add(zoneId.toString());
        }
        return this;
    }

    @Override
    public ApplicationGatewayBackendImpl updateBackend(String name) {
        return (ApplicationGatewayBackendImpl)this.backends.get(name);
    }

    @Override
    public ApplicationGatewayFrontendImpl updatePublicFrontend() {
        return (ApplicationGatewayFrontendImpl)this.defaultPublicFrontend();
    }

    @Override
    public ApplicationGatewayListenerImpl updateListener(String name) {
        return (ApplicationGatewayListenerImpl)this.listeners.get(name);
    }

    @Override
    public ApplicationGatewayRedirectConfigurationImpl updateRedirectConfiguration(String name) {
        return (ApplicationGatewayRedirectConfigurationImpl)this.redirectConfigs.get(name);
    }

    @Override
    public ApplicationGatewayRequestRoutingRuleImpl updateRequestRoutingRule(String name) {
        return (ApplicationGatewayRequestRoutingRuleImpl)this.rules.get(name);
    }

    @Override
    public ApplicationGatewayImpl withoutBackendHttpConfiguration(String name) {
        this.backendConfigs.remove(name);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl updateBackendHttpConfiguration(String name) {
        return (ApplicationGatewayBackendHttpConfigurationImpl)this.backendConfigs.get(name);
    }

    @Override
    public ApplicationGatewayIPConfigurationImpl updateIPConfiguration(String ipConfigurationName) {
        return (ApplicationGatewayIPConfigurationImpl)this.ipConfigs.get(ipConfigurationName);
    }

    @Override
    public ApplicationGatewayProbeImpl updateProbe(String name) {
        return (ApplicationGatewayProbeImpl)this.probes.get(name);
    }

    @Override
    public ApplicationGatewayIPConfigurationImpl updateDefaultIPConfiguration() {
        return (ApplicationGatewayIPConfigurationImpl)this.defaultIPConfiguration();
    }

    public ApplicationGatewayIPConfigurationImpl defineDefaultIPConfiguration() {
        return this.ensureDefaultIPConfig();
    }

    public ApplicationGatewayFrontendImpl definePublicFrontend() {
        return this.ensureDefaultPublicFrontend();
    }

    public ApplicationGatewayFrontendImpl definePrivateFrontend() {
        return this.ensureDefaultPrivateFrontend();
    }

    @Override
    public ApplicationGatewayFrontendImpl updateFrontend(String frontendName) {
        return (ApplicationGatewayFrontendImpl)this.frontends.get(frontendName);
    }

    @Override
    public Collection<ApplicationGatewaySslProtocol> disabledSslProtocols() {
        if (((ApplicationGatewayInner)((Object)this.inner())).sslPolicy() == null || ((ApplicationGatewayInner)((Object)this.inner())).sslPolicy().disabledSslProtocols() == null) {
            return new ArrayList<ApplicationGatewaySslProtocol>();
        }
        return Collections.unmodifiableCollection(((ApplicationGatewayInner)((Object)this.inner())).sslPolicy().disabledSslProtocols());
    }

    @Override
    public ApplicationGatewayFrontend defaultPrivateFrontend() {
        Map<String, ApplicationGatewayFrontend> privateFrontends = this.privateFrontends();
        if (privateFrontends.size() == 1) {
            this.defaultPrivateFrontend = (ApplicationGatewayFrontendImpl)privateFrontends.values().iterator().next();
        } else if (this.frontends().size() == 0) {
            this.defaultPrivateFrontend = null;
        }
        return this.defaultPrivateFrontend;
    }

    @Override
    public ApplicationGatewayFrontend defaultPublicFrontend() {
        Map<String, ApplicationGatewayFrontend> publicFrontends = this.publicFrontends();
        if (publicFrontends.size() == 1) {
            this.defaultPublicFrontend = (ApplicationGatewayFrontendImpl)publicFrontends.values().iterator().next();
        } else if (this.frontends().size() == 0) {
            this.defaultPublicFrontend = null;
        }
        return this.defaultPublicFrontend;
    }

    @Override
    public ApplicationGatewayIPConfiguration defaultIPConfiguration() {
        if (this.ipConfigs.size() == 1) {
            return this.ipConfigs.values().iterator().next();
        }
        return null;
    }

    @Override
    public ApplicationGatewayListener listenerByPortNumber(int portNumber) {
        ApplicationGatewayListener listener = null;
        for (ApplicationGatewayListener l : this.listeners.values()) {
            if (l.frontendPortNumber() != portNumber) continue;
            listener = l;
            break;
        }
        return listener;
    }

    @Override
    public Map<String, ApplicationGatewayAuthenticationCertificate> authenticationCertificates() {
        return Collections.unmodifiableMap(this.authCertificates);
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        TreeSet<AvailabilityZoneId> zones = new TreeSet<AvailabilityZoneId>();
        if (((ApplicationGatewayInner)((Object)this.inner())).zones() != null) {
            for (String zone : ((ApplicationGatewayInner)((Object)this.inner())).zones()) {
                zones.add(AvailabilityZoneId.fromString((String)zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }

    @Override
    public Map<String, ApplicationGatewayBackendHttpConfiguration> backendHttpConfigurations() {
        return Collections.unmodifiableMap(this.backendConfigs);
    }

    @Override
    public Map<String, ApplicationGatewayBackend> backends() {
        return Collections.unmodifiableMap(this.backends);
    }

    @Override
    public Map<String, ApplicationGatewayRequestRoutingRule> requestRoutingRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    @Override
    public Map<String, ApplicationGatewayFrontend> frontends() {
        return Collections.unmodifiableMap(this.frontends);
    }

    @Override
    public Map<String, ApplicationGatewayProbe> probes() {
        return Collections.unmodifiableMap(this.probes);
    }

    @Override
    public Map<String, ApplicationGatewaySslCertificate> sslCertificates() {
        return Collections.unmodifiableMap(this.sslCerts);
    }

    @Override
    public Map<String, ApplicationGatewayListener> listeners() {
        return Collections.unmodifiableMap(this.listeners);
    }

    @Override
    public Map<String, ApplicationGatewayRedirectConfiguration> redirectConfigurations() {
        return Collections.unmodifiableMap(this.redirectConfigs);
    }

    @Override
    public Map<String, ApplicationGatewayIPConfiguration> ipConfigurations() {
        return Collections.unmodifiableMap(this.ipConfigs);
    }

    @Override
    public ApplicationGatewaySku sku() {
        return ((ApplicationGatewayInner)((Object)this.inner())).sku();
    }

    @Override
    public ApplicationGatewayOperationalState operationalState() {
        return ((ApplicationGatewayInner)((Object)this.inner())).operationalState();
    }

    @Override
    public Map<String, Integer> frontendPorts() {
        TreeMap<String, Integer> ports = new TreeMap<String, Integer>();
        if (((ApplicationGatewayInner)((Object)this.inner())).frontendPorts() != null) {
            for (ApplicationGatewayFrontendPortInner portInner : ((ApplicationGatewayInner)((Object)this.inner())).frontendPorts()) {
                ports.put(portInner.name(), portInner.port());
            }
        }
        return Collections.unmodifiableMap(ports);
    }

    @Override
    public String frontendPortNameFromNumber(int portNumber) {
        String portName = null;
        for (Map.Entry<String, Integer> portEntry : this.frontendPorts().entrySet()) {
            if (portNumber != portEntry.getValue()) continue;
            portName = portEntry.getKey();
            break;
        }
        return portName;
    }

    private SubResource defaultSubnetRef() {
        ApplicationGatewayIPConfiguration ipConfig = this.defaultIPConfiguration();
        if (ipConfig == null) {
            return null;
        }
        return ((ApplicationGatewayIPConfigurationInner)((Object)ipConfig.inner())).subnet();
    }

    public String networkId() {
        SubResource subnetRef = this.defaultSubnetRef();
        if (subnetRef == null) {
            return null;
        }
        return ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
    }

    public String subnetName() {
        SubResource subnetRef = this.defaultSubnetRef();
        if (subnetRef == null) {
            return null;
        }
        return ResourceUtils.nameFromResourceId((String)subnetRef.id());
    }

    @Override
    public String privateIPAddress() {
        ApplicationGatewayFrontend frontend = this.defaultPrivateFrontend();
        if (frontend == null) {
            return null;
        }
        return frontend.privateIPAddress();
    }

    @Override
    public IPAllocationMethod privateIPAllocationMethod() {
        ApplicationGatewayFrontend frontend = this.defaultPrivateFrontend();
        if (frontend == null) {
            return null;
        }
        return frontend.privateIPAllocationMethod();
    }

    @Override
    public boolean isPrivate() {
        for (ApplicationGatewayFrontend frontend : this.frontends.values()) {
            if (!frontend.isPrivate()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPublic() {
        for (ApplicationGatewayFrontend frontend : this.frontends.values()) {
            if (!frontend.isPublic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, ApplicationGatewayFrontend> publicFrontends() {
        TreeMap<String, ApplicationGatewayFrontend> publicFrontends = new TreeMap<String, ApplicationGatewayFrontend>();
        for (ApplicationGatewayFrontend frontend : this.frontends().values()) {
            if (!frontend.isPublic()) continue;
            publicFrontends.put(frontend.name(), frontend);
        }
        return Collections.unmodifiableMap(publicFrontends);
    }

    @Override
    public Map<String, ApplicationGatewayFrontend> privateFrontends() {
        TreeMap<String, ApplicationGatewayFrontend> privateFrontends = new TreeMap<String, ApplicationGatewayFrontend>();
        for (ApplicationGatewayFrontend frontend : this.frontends.values()) {
            if (!frontend.isPrivate()) continue;
            privateFrontends.put(frontend.name(), frontend);
        }
        return Collections.unmodifiableMap(privateFrontends);
    }

    @Override
    public int instanceCount() {
        if (this.sku() != null && this.sku().capacity() != null) {
            return this.sku().capacity();
        }
        return 1;
    }

    @Override
    public ApplicationGatewaySkuName size() {
        if (this.sku() != null && this.sku().name() != null) {
            return this.sku().name();
        }
        return ApplicationGatewaySkuName.STANDARD_SMALL;
    }

    @Override
    public ApplicationGatewayTier tier() {
        if (this.sku() != null && this.sku().tier() != null) {
            return this.sku().tier();
        }
        return ApplicationGatewayTier.STANDARD;
    }

    @Override
    public ApplicationGateway.Update withoutPublicIPAddress() {
        return this.withoutPublicFrontend();
    }

    @Override
    public void start() {
        this.startAsync().await();
    }

    @Override
    public void stop() {
        this.stopAsync().await();
    }

    @Override
    public Completable startAsync() {
        Observable<Void> startObservable = ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).applicationGateways().startAsync(this.resourceGroupName(), this.name());
        Observable<ApplicationGateway> refreshObservable = this.refreshAsync();
        return Observable.concat(startObservable, refreshObservable).toCompletable();
    }

    @Override
    public Completable stopAsync() {
        Observable<Void> stopObservable = ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).applicationGateways().stopAsync(this.resourceGroupName(), this.name());
        Observable<ApplicationGateway> refreshObservable = this.refreshAsync();
        return Observable.concat(stopObservable, refreshObservable).toCompletable();
    }

    private ApplicationGatewaySslPolicy ensureSslPolicy() {
        List<ApplicationGatewaySslProtocol> protocols;
        ApplicationGatewaySslPolicy policy = ((ApplicationGatewayInner)((Object)this.inner())).sslPolicy();
        if (policy == null) {
            policy = new ApplicationGatewaySslPolicy();
            ((ApplicationGatewayInner)((Object)this.inner())).withSslPolicy(policy);
        }
        if ((protocols = policy.disabledSslProtocols()) == null) {
            protocols = new ArrayList<ApplicationGatewaySslProtocol>();
            policy.withDisabledSslProtocols(protocols);
        }
        return policy;
    }

    @Override
    public Map<String, ApplicationGatewayBackendHealth> checkBackendHealth() {
        return (Map)this.checkBackendHealthAsync().toBlocking().last();
    }

    @Override
    public Observable<Map<String, ApplicationGatewayBackendHealth>> checkBackendHealthAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).applicationGateways().backendHealthAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<ApplicationGatewayBackendHealthInner, Map<String, ApplicationGatewayBackendHealth>>(){

            public Map<String, ApplicationGatewayBackendHealth> call(ApplicationGatewayBackendHealthInner inner) {
                TreeMap<String, ApplicationGatewayBackendHealthImpl> backendHealths = new TreeMap<String, ApplicationGatewayBackendHealthImpl>();
                if (inner != null) {
                    for (ApplicationGatewayBackendHealthPool healthInner : inner.backendAddressPools()) {
                        ApplicationGatewayBackendHealthImpl backendHealth = new ApplicationGatewayBackendHealthImpl(healthInner, ApplicationGatewayImpl.this);
                        backendHealths.put(backendHealth.name(), backendHealth);
                    }
                }
                return Collections.unmodifiableMap(backendHealths);
            }
        });
    }
}

