/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.network.ExpressRouteCircuit;
import com.microsoft.azure.management.network.IpsecPolicy;
import com.microsoft.azure.management.network.LocalNetworkGateway;
import com.microsoft.azure.management.network.TunnelConnectionHealth;
import com.microsoft.azure.management.network.VirtualNetworkGateway;
import com.microsoft.azure.management.network.VirtualNetworkGatewayConnectionStatus;
import com.microsoft.azure.management.network.VirtualNetworkGatewayConnectionType;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayConnectionInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasParent;
import com.microsoft.azure.management.resources.fluentcore.arm.models.IndependentChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.Collection;

@Fluent
@Beta(value=Beta.SinceVersion.V1_3_0)
public interface VirtualNetworkGatewayConnection
extends IndependentChildResource<NetworkManager, VirtualNetworkGatewayConnectionInner>,
Refreshable<VirtualNetworkGatewayConnection>,
Updatable<Update>,
HasParent<VirtualNetworkGateway> {
    public String authorizationKey();

    public String virtualNetworkGateway1Id();

    public String virtualNetworkGateway2Id();

    public String localNetworkGateway2Id();

    public VirtualNetworkGatewayConnectionType connectionType();

    public int routingWeight();

    public String sharedKey();

    public VirtualNetworkGatewayConnectionStatus connectionStatus();

    public Collection<TunnelConnectionHealth> tunnelConnectionStatus();

    public long egressBytesTransferred();

    public long ingressBytesTransferred();

    public String peerId();

    public boolean isBgpEnabled();

    public boolean usePolicyBasedTrafficSelectors();

    public Collection<IpsecPolicy> ipsecPolicies();

    public String provisioningState();

    public static interface UpdateStages {

        public static interface WithAuthorization {
            public Update withAuthorization(String var1);
        }

        public static interface WithSharedKey {
            public Update withSharedKey(String var1);
        }

        public static interface WithBgp {
            public Update withBgp();

            public Update withoutBgp();
        }
    }

    public static interface Update
    extends Appliable<VirtualNetworkGatewayConnection>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithBgp,
    UpdateStages.WithSharedKey,
    UpdateStages.WithAuthorization {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<VirtualNetworkGatewayConnection>,
        Resource.DefinitionWithTags<WithCreate>,
        WithBgp,
        WithAuthorization {
        }

        public static interface WithAuthorization {
            public WithCreate withAuthorization(String var1);
        }

        public static interface WithBgp {
            public WithCreate withBgp();
        }

        public static interface WithSharedKey {
            public WithCreate withSharedKey(String var1);
        }

        public static interface WithSecondVirtualNetworkGateway {
            public WithSharedKey withSecondVirtualNetworkGateway(VirtualNetworkGateway var1);
        }

        public static interface WithLocalNetworkGateway {
            public WithSharedKey withLocalNetworkGateway(LocalNetworkGateway var1);
        }

        public static interface WithConnectionType {
            public WithLocalNetworkGateway withSiteToSite();

            public WithSecondVirtualNetworkGateway withVNetToVNet();

            public WithCreate withExpressRoute(String var1);

            public WithCreate withExpressRoute(ExpressRouteCircuit var1);
        }

        public static interface Blank
        extends WithConnectionType {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithConnectionType,
    DefinitionStages.WithLocalNetworkGateway,
    DefinitionStages.WithSecondVirtualNetworkGateway,
    DefinitionStages.WithSharedKey,
    DefinitionStages.WithAuthorization,
    DefinitionStages.WithCreate {
    }
}

