/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.network.NetworkPeerings;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.VirtualNetworkInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;
import java.util.Map;

@Fluent
public interface Network
extends GroupableResource<NetworkManager, VirtualNetworkInner>,
Refreshable<Network>,
Updatable<Update> {
    @Beta(value=Beta.SinceVersion.V1_3_0)
    public boolean isPrivateIPAddressAvailable(String var1);

    @Beta(value=Beta.SinceVersion.V1_3_0)
    public boolean isPrivateIPAddressInNetwork(String var1);

    public List<String> addressSpaces();

    public List<String> dnsServerIPs();

    public Map<String, Subnet> subnets();

    @Beta(value=Beta.SinceVersion.V1_3_0)
    public NetworkPeerings peerings();

    public static interface Update
    extends Appliable<Network>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSubnet,
    UpdateStages.WithDnsServer,
    UpdateStages.WithAddressSpace {
    }

    public static interface UpdateStages {

        public static interface WithAddressSpace {
            public Update withAddressSpace(String var1);

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withoutAddressSpace(String var1);
        }

        public static interface WithDnsServer {
            public Update withDnsServer(String var1);
        }

        public static interface WithSubnet {
            public Update withSubnet(String var1, String var2);

            public Update withSubnets(Map<String, String> var1);

            public Update withoutSubnet(String var1);

            public Subnet.Update updateSubnet(String var1);

            public Subnet.UpdateDefinitionStages.Blank<Update> defineSubnet(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreateAndSubnet
        extends WithCreate,
        WithSubnet {
        }

        public static interface WithCreate
        extends Creatable<Network>,
        Resource.DefinitionWithTags<WithCreate> {
            public WithCreate withDnsServer(String var1);

            public WithCreateAndSubnet withAddressSpace(String var1);
        }

        public static interface WithSubnet {
            public WithCreateAndSubnet withSubnet(String var1, String var2);

            public WithCreateAndSubnet withSubnets(Map<String, String> var1);

            public Subnet.DefinitionStages.Blank<WithCreateAndSubnet> defineSubnet(String var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCreate> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithSubnet,
    DefinitionStages.WithCreate,
    DefinitionStages.WithCreateAndSubnet {
    }
}

