/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryGroup;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryUser;
import com.microsoft.azure.management.graphrbac.ServicePrincipal;
import com.microsoft.azure.management.keyvault.AccessPolicy;
import com.microsoft.azure.management.keyvault.AccessPolicyEntry;
import com.microsoft.azure.management.keyvault.CertificatePermissions;
import com.microsoft.azure.management.keyvault.KeyPermissions;
import com.microsoft.azure.management.keyvault.Permissions;
import com.microsoft.azure.management.keyvault.SecretPermissions;
import com.microsoft.azure.management.keyvault.StoragePermissions;
import com.microsoft.azure.management.keyvault.Vault;
import com.microsoft.azure.management.keyvault.implementation.VaultImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

@LangDefinition
class AccessPolicyImpl
extends ChildResourceImpl<AccessPolicyEntry, VaultImpl, Vault>
implements AccessPolicy,
AccessPolicy.Definition<Vault.DefinitionStages.WithCreate>,
AccessPolicy.UpdateDefinition<Vault.Update>,
AccessPolicy.Update {
    private String userPrincipalName;
    private String servicePrincipalName;

    AccessPolicyImpl(AccessPolicyEntry innerObject, VaultImpl parent) {
        super((Object)innerObject, (Object)parent);
        ((AccessPolicyEntry)this.inner()).withTenantId(UUID.fromString(parent.tenantId()));
    }

    String userPrincipalName() {
        return this.userPrincipalName;
    }

    String servicePrincipalName() {
        return this.servicePrincipalName;
    }

    @Override
    public String tenantId() {
        if (((AccessPolicyEntry)this.inner()).tenantId() == null) {
            return null;
        }
        return ((AccessPolicyEntry)this.inner()).tenantId().toString();
    }

    @Override
    public String objectId() {
        if (((AccessPolicyEntry)this.inner()).objectId() == null) {
            return null;
        }
        return ((AccessPolicyEntry)this.inner()).objectId();
    }

    @Override
    public String applicationId() {
        if (((AccessPolicyEntry)this.inner()).applicationId() == null) {
            return null;
        }
        return ((AccessPolicyEntry)this.inner()).applicationId().toString();
    }

    @Override
    public Permissions permissions() {
        return ((AccessPolicyEntry)this.inner()).permissions();
    }

    public String name() {
        return ((AccessPolicyEntry)this.inner()).objectId();
    }

    private void initializeKeyPermissions() {
        if (((AccessPolicyEntry)this.inner()).permissions() == null) {
            ((AccessPolicyEntry)this.inner()).withPermissions(new Permissions());
        }
        if (((AccessPolicyEntry)this.inner()).permissions().keys() == null) {
            ((AccessPolicyEntry)this.inner()).permissions().withKeys(new ArrayList<KeyPermissions>());
        }
    }

    private void initializeSecretPermissions() {
        if (((AccessPolicyEntry)this.inner()).permissions() == null) {
            ((AccessPolicyEntry)this.inner()).withPermissions(new Permissions());
        }
        if (((AccessPolicyEntry)this.inner()).permissions().secrets() == null) {
            ((AccessPolicyEntry)this.inner()).permissions().withSecrets(new ArrayList<SecretPermissions>());
        }
    }

    private void initializeCertificatePermissions() {
        if (((AccessPolicyEntry)this.inner()).permissions() == null) {
            ((AccessPolicyEntry)this.inner()).withPermissions(new Permissions());
        }
        if (((AccessPolicyEntry)this.inner()).permissions().certificates() == null) {
            ((AccessPolicyEntry)this.inner()).permissions().withCertificates(new ArrayList<CertificatePermissions>());
        }
    }

    private void initializeStoragePermissions() {
        if (((AccessPolicyEntry)this.inner()).permissions() == null) {
            ((AccessPolicyEntry)this.inner()).withPermissions(new Permissions());
        }
        if (((AccessPolicyEntry)this.inner()).permissions().storage() == null) {
            ((AccessPolicyEntry)this.inner()).permissions().withStorage(new ArrayList<StoragePermissions>());
        }
    }

    @Override
    public AccessPolicyImpl allowKeyPermissions(KeyPermissions ... permissions) {
        this.initializeKeyPermissions();
        for (KeyPermissions permission : permissions) {
            if (((AccessPolicyEntry)this.inner()).permissions().keys().contains((Object)permission)) continue;
            ((AccessPolicyEntry)this.inner()).permissions().keys().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowKeyPermissions(List<KeyPermissions> permissions) {
        this.initializeKeyPermissions();
        for (KeyPermissions permission : permissions) {
            if (((AccessPolicyEntry)this.inner()).permissions().keys().contains((Object)permission)) continue;
            ((AccessPolicyEntry)this.inner()).permissions().keys().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowSecretPermissions(SecretPermissions ... permissions) {
        this.initializeSecretPermissions();
        for (SecretPermissions permission : permissions) {
            if (((AccessPolicyEntry)this.inner()).permissions().secrets().contains((Object)permission)) continue;
            ((AccessPolicyEntry)this.inner()).permissions().secrets().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowSecretPermissions(List<SecretPermissions> permissions) {
        this.initializeSecretPermissions();
        for (SecretPermissions permission : permissions) {
            if (((AccessPolicyEntry)this.inner()).permissions().secrets().contains((Object)permission)) continue;
            ((AccessPolicyEntry)this.inner()).permissions().secrets().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowCertificateAllPermissions() {
        for (CertificatePermissions permission : CertificatePermissions.values()) {
            this.allowCertificatePermissions(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowCertificatePermissions(CertificatePermissions ... permissions) {
        this.initializeCertificatePermissions();
        for (CertificatePermissions permission : permissions) {
            if (((AccessPolicyEntry)this.inner()).permissions().certificates().contains((Object)permission)) continue;
            ((AccessPolicyEntry)this.inner()).permissions().certificates().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowCertificatePermissions(List<CertificatePermissions> permissions) {
        this.initializeCertificatePermissions();
        for (CertificatePermissions permission : permissions) {
            if (((AccessPolicyEntry)this.inner()).permissions().certificates().contains((Object)permission)) continue;
            ((AccessPolicyEntry)this.inner()).permissions().certificates().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowStorageAllPermissions() {
        for (StoragePermissions permission : StoragePermissions.values()) {
            this.allowStoragePermissions(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowStoragePermissions(StoragePermissions ... permissions) {
        this.initializeStoragePermissions();
        for (StoragePermissions permission : permissions) {
            if (((AccessPolicyEntry)this.inner()).permissions().storage().contains((Object)permission)) continue;
            ((AccessPolicyEntry)this.inner()).permissions().storage().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowStoragePermissions(List<StoragePermissions> permissions) {
        this.initializeStoragePermissions();
        for (StoragePermissions permission : permissions) {
            if (((AccessPolicyEntry)this.inner()).permissions().storage().contains((Object)permission)) continue;
            ((AccessPolicyEntry)this.inner()).permissions().storage().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl disallowCertificateAllPermissions() {
        this.initializeCertificatePermissions();
        ((AccessPolicyEntry)this.inner()).permissions().secrets().clear();
        return this;
    }

    @Override
    public AccessPolicyImpl disallowCertificatePermissions(CertificatePermissions ... permissions) {
        this.initializeCertificatePermissions();
        ((AccessPolicyEntry)this.inner()).permissions().certificates().removeAll(Arrays.asList(permissions));
        return this;
    }

    @Override
    public AccessPolicyImpl disallowCertificatePermissions(List<CertificatePermissions> permissions) {
        this.initializeCertificatePermissions();
        ((AccessPolicyEntry)this.inner()).permissions().certificates().removeAll(permissions);
        return this;
    }

    public VaultImpl attach() {
        ((VaultImpl)this.parent()).withAccessPolicy(this);
        return (VaultImpl)this.parent();
    }

    public AccessPolicyImpl forObjectId(String objectId) {
        ((AccessPolicyEntry)this.inner()).withObjectId(objectId);
        return this;
    }

    public AccessPolicyImpl forUser(ActiveDirectoryUser user) {
        ((AccessPolicyEntry)this.inner()).withObjectId(user.id());
        return this;
    }

    public AccessPolicyImpl forUser(String userPrincipalName) {
        this.userPrincipalName = userPrincipalName;
        return this;
    }

    public AccessPolicyImpl forApplicationId(String applicationId) {
        ((AccessPolicyEntry)this.inner()).withApplicationId(UUID.fromString(applicationId));
        return this;
    }

    public AccessPolicyImpl forTenantId(String tenantId) {
        ((AccessPolicyEntry)this.inner()).withTenantId(UUID.fromString(tenantId));
        return this;
    }

    public AccessPolicyImpl forGroup(ActiveDirectoryGroup activeDirectoryGroup) {
        ((AccessPolicyEntry)this.inner()).withObjectId(activeDirectoryGroup.id());
        return this;
    }

    public AccessPolicyImpl forServicePrincipal(ServicePrincipal servicePrincipal) {
        ((AccessPolicyEntry)this.inner()).withObjectId(servicePrincipal.id());
        return this;
    }

    public AccessPolicyImpl forServicePrincipal(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
        return this;
    }

    @Override
    public AccessPolicyImpl allowKeyAllPermissions() {
        for (KeyPermissions permission : KeyPermissions.values()) {
            this.allowKeyPermissions(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl disallowKeyAllPermissions() {
        this.initializeKeyPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().keys().clear();
        return this;
    }

    @Override
    public AccessPolicyImpl disallowKeyPermissions(KeyPermissions ... permissions) {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().keys().removeAll(Arrays.asList(permissions));
        return this;
    }

    @Override
    public AccessPolicyImpl disallowKeyPermissions(List<KeyPermissions> permissions) {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().keys().removeAll(permissions);
        return this;
    }

    @Override
    public AccessPolicyImpl allowSecretAllPermissions() {
        for (SecretPermissions permission : SecretPermissions.values()) {
            this.allowSecretPermissions(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl disallowSecretAllPermissions() {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().secrets().clear();
        return this;
    }

    @Override
    public AccessPolicyImpl disallowSecretPermissions(SecretPermissions ... permissions) {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().secrets().removeAll(Arrays.asList(permissions));
        return this;
    }

    @Override
    public AccessPolicyImpl disallowSecretPermissions(List<SecretPermissions> permissions) {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.inner()).permissions().secrets().removeAll(permissions);
        return this;
    }

    @Override
    public AccessPolicyImpl disallowStorageAllPermissions() {
        this.initializeStoragePermissions();
        ((AccessPolicyEntry)this.inner()).permissions().storage().clear();
        return this;
    }

    @Override
    public AccessPolicyImpl disallowStoragePermissions(StoragePermissions ... permissions) {
        this.initializeStoragePermissions();
        ((AccessPolicyEntry)this.inner()).permissions().storage().removeAll(Arrays.asList(permissions));
        return this;
    }

    @Override
    public AccessPolicyImpl disallowStoragePermissions(List<StoragePermissions> permissions) {
        this.initializeStoragePermissions();
        ((AccessPolicyEntry)this.inner()).permissions().storage().removeAll(permissions);
        return this;
    }
}

