/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.cosmosdb.CosmosDBAccount;
import com.microsoft.azure.management.cosmosdb.PrivateEndpointConnection;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBAccountImpl;
import com.microsoft.azure.management.cosmosdb.implementation.PrivateEndpointConnectionImpl;
import com.microsoft.azure.management.cosmosdb.implementation.PrivateEndpointConnectionInner;
import com.microsoft.azure.management.cosmosdb.implementation.PrivateEndpointConnectionsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesCachedImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class PrivateEndpointConnectionsImpl
extends ExternalChildResourcesCachedImpl<PrivateEndpointConnectionImpl, PrivateEndpointConnection, PrivateEndpointConnectionInner, CosmosDBAccountImpl, CosmosDBAccount> {
    private final PrivateEndpointConnectionsInner client;

    PrivateEndpointConnectionsImpl(PrivateEndpointConnectionsInner client, CosmosDBAccountImpl parent) {
        super((Object)parent, parent.taskGroup(), "PrivateEndpointConnection");
        this.client = client;
        this.cacheCollection();
    }

    public PrivateEndpointConnectionImpl define(String name) {
        return (PrivateEndpointConnectionImpl)this.prepareInlineDefine(name);
    }

    public PrivateEndpointConnectionImpl update(String name) {
        return (PrivateEndpointConnectionImpl)this.prepareInlineUpdate(name);
    }

    public void remove(String name) {
        this.prepareInlineRemove(name);
    }

    public Map<String, PrivateEndpointConnection> asMap() {
        return (Map)this.asMapAsync().toBlocking().last();
    }

    public Observable<Map<String, PrivateEndpointConnection>> asMapAsync() {
        return this.listAsync().map((Func1)new Func1<List<PrivateEndpointConnectionImpl>, Map<String, PrivateEndpointConnection>>(){

            public Map<String, PrivateEndpointConnection> call(List<PrivateEndpointConnectionImpl> privateEndpointConnections) {
                HashMap<String, PrivateEndpointConnection> privateEndpointConnectionMap = new HashMap<String, PrivateEndpointConnection>();
                for (PrivateEndpointConnectionImpl privateEndpointConnection : privateEndpointConnections) {
                    privateEndpointConnectionMap.put(privateEndpointConnection.name(), privateEndpointConnection);
                }
                return privateEndpointConnectionMap;
            }
        });
    }

    public Observable<List<PrivateEndpointConnectionImpl>> listAsync() {
        return this.client.listByDatabaseAccountAsync(((CosmosDBAccountImpl)this.parent()).resourceGroupName(), ((CosmosDBAccountImpl)this.parent()).name()).map((Func1)new Func1<List<PrivateEndpointConnectionInner>, List<PrivateEndpointConnectionImpl>>(){

            public List<PrivateEndpointConnectionImpl> call(List<PrivateEndpointConnectionInner> privateEndpointConnectionInners) {
                ArrayList<PrivateEndpointConnectionImpl> privateEndpointConnections = new ArrayList<PrivateEndpointConnectionImpl>();
                for (PrivateEndpointConnectionInner inner : privateEndpointConnectionInners) {
                    privateEndpointConnections.add(new PrivateEndpointConnectionImpl(inner.name(), (CosmosDBAccountImpl)PrivateEndpointConnectionsImpl.this.parent(), inner, PrivateEndpointConnectionsImpl.this.client));
                }
                return Collections.unmodifiableList(privateEndpointConnections);
            }
        });
    }

    public Observable<PrivateEndpointConnectionImpl> getImplAsync(String name) {
        return this.client.getAsync(((CosmosDBAccountImpl)this.parent()).resourceGroupName(), ((CosmosDBAccountImpl)this.parent()).name(), name).map((Func1)new Func1<PrivateEndpointConnectionInner, PrivateEndpointConnectionImpl>(){

            public PrivateEndpointConnectionImpl call(PrivateEndpointConnectionInner privateEndpointConnectionInner) {
                return new PrivateEndpointConnectionImpl(privateEndpointConnectionInner.name(), (CosmosDBAccountImpl)PrivateEndpointConnectionsImpl.this.parent(), privateEndpointConnectionInner, PrivateEndpointConnectionsImpl.this.client);
            }
        });
    }

    protected List<PrivateEndpointConnectionImpl> listChildResources() {
        return new ArrayList<PrivateEndpointConnectionImpl>();
    }

    protected PrivateEndpointConnectionImpl newChildResource(String name) {
        return new PrivateEndpointConnectionImpl(name, (CosmosDBAccountImpl)this.parent(), new PrivateEndpointConnectionInner(), this.client);
    }
}

