/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.cosmosdb.Capability;
import com.microsoft.azure.management.cosmosdb.ConnectorOffer;
import com.microsoft.azure.management.cosmosdb.ConsistencyPolicy;
import com.microsoft.azure.management.cosmosdb.CosmosDBAccount;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountKind;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountListConnectionStringsResult;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountListKeysResult;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountListReadOnlyKeysResult;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountOfferType;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountUpdateParameters;
import com.microsoft.azure.management.cosmosdb.DefaultConsistencyLevel;
import com.microsoft.azure.management.cosmosdb.FailoverPolicy;
import com.microsoft.azure.management.cosmosdb.KeyKind;
import com.microsoft.azure.management.cosmosdb.Location;
import com.microsoft.azure.management.cosmosdb.PrivateEndpointConnection;
import com.microsoft.azure.management.cosmosdb.PrivateLinkResource;
import com.microsoft.azure.management.cosmosdb.SqlDatabase;
import com.microsoft.azure.management.cosmosdb.VirtualNetworkRule;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBManager;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountGetResultsInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListConnectionStringsResultImpl;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListConnectionStringsResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListKeysResultImpl;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListKeysResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListReadOnlyKeysResultImpl;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListReadOnlyKeysResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.PrivateEndpointConnectionImpl;
import com.microsoft.azure.management.cosmosdb.implementation.PrivateEndpointConnectionsImpl;
import com.microsoft.azure.management.cosmosdb.implementation.PrivateLinkResourceImpl;
import com.microsoft.azure.management.cosmosdb.implementation.PrivateLinkResourceInner;
import com.microsoft.azure.management.cosmosdb.implementation.SqlDatabaseGetResultsInner;
import com.microsoft.azure.management.cosmosdb.implementation.SqlDatabaseImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class CosmosDBAccountImpl
extends GroupableResourceImpl<CosmosDBAccount, DatabaseAccountGetResultsInner, CosmosDBAccountImpl, CosmosDBManager>
implements CosmosDBAccount,
CosmosDBAccount.Definition,
CosmosDBAccount.Update {
    private List<FailoverPolicy> failoverPolicies = new ArrayList<FailoverPolicy>();
    private boolean hasFailoverPolicyChanges;
    private final int maxDelayDueToMissingFailovers = 600;
    private Map<String, VirtualNetworkRule> virtualNetworkRulesMap;
    private PrivateEndpointConnectionsImpl privateEndpointConnections = new PrivateEndpointConnectionsImpl(((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).privateEndpointConnections(), this);

    CosmosDBAccountImpl(String name, DatabaseAccountGetResultsInner innerObject, CosmosDBManager manager) {
        super(CosmosDBAccountImpl.fixDBName(name), (Resource)innerObject, (ManagerBase)manager);
    }

    @Override
    public DatabaseAccountKind kind() {
        return ((DatabaseAccountGetResultsInner)((Object)this.inner())).kind();
    }

    @Override
    public String documentEndpoint() {
        return ((DatabaseAccountGetResultsInner)((Object)this.inner())).documentEndpoint();
    }

    @Override
    public DatabaseAccountOfferType databaseAccountOfferType() {
        return ((DatabaseAccountGetResultsInner)((Object)this.inner())).databaseAccountOfferType();
    }

    @Override
    public String ipRangeFilter() {
        return ((DatabaseAccountGetResultsInner)((Object)this.inner())).ipRangeFilter();
    }

    @Override
    public ConsistencyPolicy consistencyPolicy() {
        return ((DatabaseAccountGetResultsInner)((Object)this.inner())).consistencyPolicy();
    }

    @Override
    public DefaultConsistencyLevel defaultConsistencyLevel() {
        if (((DatabaseAccountGetResultsInner)((Object)this.inner())).consistencyPolicy() == null) {
            throw new RuntimeException("Consistency policy is missing!");
        }
        return ((DatabaseAccountGetResultsInner)((Object)this.inner())).consistencyPolicy().defaultConsistencyLevel();
    }

    @Override
    public List<Location> writableReplications() {
        return ((DatabaseAccountGetResultsInner)((Object)this.inner())).writeLocations();
    }

    @Override
    public List<Location> readableReplications() {
        return ((DatabaseAccountGetResultsInner)((Object)this.inner())).readLocations();
    }

    @Override
    public DatabaseAccountListKeysResult listKeys() {
        return (DatabaseAccountListKeysResult)this.listKeysAsync().toBlocking().last();
    }

    @Override
    public Observable<DatabaseAccountListKeysResult> listKeysAsync() {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().listKeysAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<DatabaseAccountListKeysResultInner, DatabaseAccountListKeysResult>(){

            public DatabaseAccountListKeysResult call(DatabaseAccountListKeysResultInner databaseAccountListKeysResultInner) {
                return new DatabaseAccountListKeysResultImpl(databaseAccountListKeysResultInner);
            }
        });
    }

    @Override
    public DatabaseAccountListReadOnlyKeysResult listReadOnlyKeys() {
        return (DatabaseAccountListReadOnlyKeysResult)this.listReadOnlyKeysAsync().toBlocking().last();
    }

    @Override
    public Observable<DatabaseAccountListReadOnlyKeysResult> listReadOnlyKeysAsync() {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().listReadOnlyKeysAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<DatabaseAccountListReadOnlyKeysResultInner, DatabaseAccountListReadOnlyKeysResult>(){

            public DatabaseAccountListReadOnlyKeysResult call(DatabaseAccountListReadOnlyKeysResultInner databaseAccountListReadOnlyKeysResultInner) {
                return new DatabaseAccountListReadOnlyKeysResultImpl(databaseAccountListReadOnlyKeysResultInner);
            }
        });
    }

    @Override
    public DatabaseAccountListConnectionStringsResult listConnectionStrings() {
        return (DatabaseAccountListConnectionStringsResult)this.listConnectionStringsAsync().toBlocking().last();
    }

    @Override
    public Observable<DatabaseAccountListConnectionStringsResult> listConnectionStringsAsync() {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().listConnectionStringsAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<DatabaseAccountListConnectionStringsResultInner, DatabaseAccountListConnectionStringsResult>(){

            public DatabaseAccountListConnectionStringsResult call(DatabaseAccountListConnectionStringsResultInner databaseAccountListConnectionStringsResultInner) {
                return new DatabaseAccountListConnectionStringsResultImpl(databaseAccountListConnectionStringsResultInner);
            }
        });
    }

    @Override
    public List<SqlDatabase> listSqlDatabases() {
        return (List)this.listSqlDatabasesAsync().toBlocking().last();
    }

    @Override
    public Observable<List<SqlDatabase>> listSqlDatabasesAsync() {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).sqlResources().listSqlDatabasesAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<List<SqlDatabaseGetResultsInner>, List<SqlDatabase>>(){

            public List<SqlDatabase> call(List<SqlDatabaseGetResultsInner> sqlDatabaseInners) {
                ArrayList<SqlDatabaseImpl> sqlDatabases = new ArrayList<SqlDatabaseImpl>();
                for (SqlDatabaseGetResultsInner inner : sqlDatabaseInners) {
                    sqlDatabases.add(new SqlDatabaseImpl(inner));
                }
                return Collections.unmodifiableList(sqlDatabases);
            }
        });
    }

    @Override
    public List<PrivateLinkResource> listPrivateLinkResources() {
        return (List)this.listPrivateLinkResourcesAsync().toBlocking().last();
    }

    @Override
    public Observable<List<PrivateLinkResource>> listPrivateLinkResourcesAsync() {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).privateLinkResources().listByDatabaseAccountAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<List<PrivateLinkResourceInner>, List<PrivateLinkResource>>(){

            public List<PrivateLinkResource> call(List<PrivateLinkResourceInner> privateLinkResourceInners) {
                ArrayList<PrivateLinkResourceImpl> privateLinkResources = new ArrayList<PrivateLinkResourceImpl>();
                for (PrivateLinkResourceInner inner : privateLinkResourceInners) {
                    privateLinkResources.add(new PrivateLinkResourceImpl(inner));
                }
                return Collections.unmodifiableList(privateLinkResources);
            }
        });
    }

    @Override
    public PrivateLinkResource getPrivateLinkResource(String groupName) {
        return (PrivateLinkResource)this.getPrivateLinkResourceAsync(groupName).toBlocking().last();
    }

    @Override
    public Observable<PrivateLinkResource> getPrivateLinkResourceAsync(String groupName) {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).privateLinkResources().getAsync(this.resourceGroupName(), this.name(), groupName).map((Func1)new Func1<PrivateLinkResourceInner, PrivateLinkResource>(){

            public PrivateLinkResource call(PrivateLinkResourceInner privateLinkResourceInner) {
                if (privateLinkResourceInner == null) {
                    return null;
                }
                return new PrivateLinkResourceImpl(privateLinkResourceInner);
            }
        });
    }

    @Override
    public Map<String, PrivateEndpointConnection> listPrivateEndpointConnection() {
        return (Map)this.listPrivateEndpointConnectionAsync().toBlocking().last();
    }

    @Override
    public Observable<Map<String, PrivateEndpointConnection>> listPrivateEndpointConnectionAsync() {
        return this.privateEndpointConnections.asMapAsync();
    }

    @Override
    public PrivateEndpointConnection getPrivateEndpointConnection(String name) {
        return (PrivateEndpointConnection)this.getPrivateEndpointConnectionAsync(name).toBlocking().last();
    }

    @Override
    public Observable<PrivateEndpointConnection> getPrivateEndpointConnectionAsync(String name) {
        return this.privateEndpointConnections.getImplAsync(name).map((Func1)new Func1<PrivateEndpointConnectionImpl, PrivateEndpointConnection>(){

            public PrivateEndpointConnection call(PrivateEndpointConnectionImpl privateEndpointConnection) {
                return privateEndpointConnection;
            }
        });
    }

    @Override
    public boolean multipleWriteLocationsEnabled() {
        return ((DatabaseAccountGetResultsInner)((Object)this.inner())).enableMultipleWriteLocations();
    }

    @Override
    public boolean cassandraConnectorEnabled() {
        return ((DatabaseAccountGetResultsInner)((Object)this.inner())).enableCassandraConnector();
    }

    @Override
    public ConnectorOffer cassandraConnectorOffer() {
        return ((DatabaseAccountGetResultsInner)((Object)this.inner())).connectorOffer();
    }

    @Override
    public boolean keyBasedMetadataWriteAccessDisabled() {
        return ((DatabaseAccountGetResultsInner)((Object)this.inner())).disableKeyBasedMetadataWriteAccess();
    }

    @Override
    public List<Capability> capabilities() {
        List<Capability> capabilities = ((DatabaseAccountGetResultsInner)((Object)this.inner())).capabilities();
        if (capabilities == null) {
            capabilities = new ArrayList<Capability>();
        }
        return Collections.unmodifiableList(capabilities);
    }

    @Override
    public List<VirtualNetworkRule> virtualNetworkRules() {
        ArrayList result = this.inner() != null && ((DatabaseAccountGetResultsInner)((Object)this.inner())).virtualNetworkRules() != null ? ((DatabaseAccountGetResultsInner)((Object)this.inner())).virtualNetworkRules() : new ArrayList();
        return Collections.unmodifiableList(result);
    }

    @Override
    public void offlineRegion(Region region) {
        ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().offlineRegion(this.resourceGroupName(), this.name(), region.label());
    }

    @Override
    public Completable offlineRegionAsync(Region region) {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().offlineRegionAsync(this.resourceGroupName(), this.name(), region.label()).toCompletable();
    }

    @Override
    public void onlineRegion(Region region) {
        ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().onlineRegion(this.resourceGroupName(), this.name(), region.label());
    }

    @Override
    public Completable onlineRegionAsync(Region region) {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().onlineRegionAsync(this.resourceGroupName(), this.name(), region.label()).toCompletable();
    }

    @Override
    public void regenerateKey(KeyKind keyKind) {
        ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().regenerateKey(this.resourceGroupName(), this.name(), keyKind);
    }

    @Override
    public Completable regenerateKeyAsync(KeyKind keyKind) {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().regenerateKeyAsync(this.resourceGroupName(), this.name(), keyKind).toCompletable();
    }

    @Override
    public CosmosDBAccountImpl withKind(DatabaseAccountKind kind) {
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withKind(kind);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withKind(DatabaseAccountKind kind, Capability ... capabilities) {
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withKind(kind);
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withCapabilities(Arrays.asList(capabilities));
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDataModelSql() {
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withKind(DatabaseAccountKind.GLOBAL_DOCUMENT_DB);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDataModelMongoDB() {
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withKind(DatabaseAccountKind.MONGO_DB);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDataModelCassandra() {
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withKind(DatabaseAccountKind.GLOBAL_DOCUMENT_DB);
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        capabilities.add(new Capability().withName("EnableCassandra"));
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withCapabilities(capabilities);
        this.withTag("defaultExperience", "Cassandra");
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDataModelAzureTable() {
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withKind(DatabaseAccountKind.GLOBAL_DOCUMENT_DB);
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        capabilities.add(new Capability().withName("EnableTable"));
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withCapabilities(capabilities);
        this.withTag("defaultExperience", "Table");
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDataModelGremlin() {
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withKind(DatabaseAccountKind.GLOBAL_DOCUMENT_DB);
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        capabilities.add(new Capability().withName("EnableGremlin"));
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withCapabilities(capabilities);
        this.withTag("defaultExperience", "Graph");
        return this;
    }

    @Override
    public CosmosDBAccountImpl withIpRangeFilter(String ipRangeFilter) {
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withIpRangeFilter(ipRangeFilter);
        return this;
    }

    protected Observable<DatabaseAccountGetResultsInner> getInnerAsync() {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public CosmosDBAccountImpl withWriteReplication(Region region) {
        FailoverPolicy failoverPolicyInner = new FailoverPolicy();
        failoverPolicyInner.withLocationName(region.name());
        this.hasFailoverPolicyChanges = true;
        this.failoverPolicies.add(failoverPolicyInner);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withReadReplication(Region region) {
        this.ensureFailoverIsInitialized();
        FailoverPolicy failoverPolicyInner = new FailoverPolicy();
        failoverPolicyInner.withLocationName(region.name());
        failoverPolicyInner.withFailoverPriority(this.failoverPolicies.size());
        this.hasFailoverPolicyChanges = true;
        this.failoverPolicies.add(failoverPolicyInner);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withoutReadReplication(Region region) {
        this.ensureFailoverIsInitialized();
        for (int i = 1; i < this.failoverPolicies.size(); ++i) {
            String locName;
            if (this.failoverPolicies.get(i).locationName() == null || !(locName = this.failoverPolicies.get(i).locationName().replace(" ", "").toLowerCase()).equals(region.name())) continue;
            this.failoverPolicies.remove(i);
        }
        return this;
    }

    @Override
    public CosmosDBAccountImpl withEventualConsistency() {
        this.setConsistencyPolicy(DefaultConsistencyLevel.EVENTUAL, 0L, 0);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withSessionConsistency() {
        this.setConsistencyPolicy(DefaultConsistencyLevel.SESSION, 0L, 0);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withBoundedStalenessConsistency(long maxStalenessPrefix, int maxIntervalInSeconds) {
        this.setConsistencyPolicy(DefaultConsistencyLevel.BOUNDED_STALENESS, maxStalenessPrefix, maxIntervalInSeconds);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withStrongConsistency() {
        this.setConsistencyPolicy(DefaultConsistencyLevel.STRONG, 0L, 0);
        return this;
    }

    public PrivateEndpointConnectionImpl defineNewPrivateEndpointConnection(String name) {
        return this.privateEndpointConnections.define(name);
    }

    @Override
    public PrivateEndpointConnectionImpl updatePrivateEndpointConnection(String name) {
        return this.privateEndpointConnections.update(name);
    }

    @Override
    public CosmosDBAccountImpl withoutPrivateEndpointConnection(String name) {
        this.privateEndpointConnections.remove(name);
        return this;
    }

    public Observable<CosmosDBAccount> createResourceAsync() {
        return this.doDatabaseUpdateCreate();
    }

    private DatabaseAccountCreateUpdateParameters createUpdateParametersInner(DatabaseAccountGetResultsInner inner) {
        this.ensureFailoverIsInitialized();
        DatabaseAccountCreateUpdateParameters createUpdateParametersInner = new DatabaseAccountCreateUpdateParameters();
        createUpdateParametersInner.withLocation(this.regionName().toLowerCase());
        createUpdateParametersInner.withConsistencyPolicy(inner.consistencyPolicy());
        createUpdateParametersInner.withDatabaseAccountOfferType(DatabaseAccountOfferType.STANDARD.toString());
        createUpdateParametersInner.withIpRangeFilter(inner.ipRangeFilter());
        createUpdateParametersInner.withKind(inner.kind());
        createUpdateParametersInner.withCapabilities(inner.capabilities());
        createUpdateParametersInner.withTags(inner.getTags());
        createUpdateParametersInner.withEnableMultipleWriteLocations(inner.enableMultipleWriteLocations());
        this.addLocationsForParameters(new CreateUpdateLocationParameters(createUpdateParametersInner), this.failoverPolicies);
        createUpdateParametersInner.withIsVirtualNetworkFilterEnabled(inner.isVirtualNetworkFilterEnabled());
        createUpdateParametersInner.withEnableCassandraConnector(inner.enableCassandraConnector());
        createUpdateParametersInner.withConnectorOffer(inner.connectorOffer());
        createUpdateParametersInner.withEnableAutomaticFailover(inner.enableAutomaticFailover());
        createUpdateParametersInner.withDisableKeyBasedMetadataWriteAccess(inner.disableKeyBasedMetadataWriteAccess());
        if (this.virtualNetworkRulesMap != null) {
            createUpdateParametersInner.withVirtualNetworkRules(new ArrayList<VirtualNetworkRule>(this.virtualNetworkRulesMap.values()));
            this.virtualNetworkRulesMap = null;
        }
        return createUpdateParametersInner;
    }

    private DatabaseAccountUpdateParameters updateParametersInner(DatabaseAccountGetResultsInner inner) {
        this.ensureFailoverIsInitialized();
        DatabaseAccountUpdateParameters updateParameters = new DatabaseAccountUpdateParameters();
        updateParameters.withTags(inner.getTags());
        updateParameters.withLocation(this.regionName().toLowerCase());
        updateParameters.withConsistencyPolicy(inner.consistencyPolicy());
        updateParameters.withIpRangeFilter(inner.ipRangeFilter());
        updateParameters.withIsVirtualNetworkFilterEnabled(inner.isVirtualNetworkFilterEnabled());
        updateParameters.withEnableAutomaticFailover(inner.enableAutomaticFailover());
        updateParameters.withCapabilities(inner.capabilities());
        updateParameters.withEnableMultipleWriteLocations(inner.enableMultipleWriteLocations());
        updateParameters.withEnableCassandraConnector(inner.enableCassandraConnector());
        updateParameters.withConnectorOffer(inner.connectorOffer());
        updateParameters.withDisableKeyBasedMetadataWriteAccess(inner.disableKeyBasedMetadataWriteAccess());
        if (this.virtualNetworkRulesMap != null) {
            updateParameters.withVirtualNetworkRules(new ArrayList<VirtualNetworkRule>(this.virtualNetworkRulesMap.values()));
            this.virtualNetworkRulesMap = null;
        }
        this.addLocationsForParameters(new UpdateLocationParameters(updateParameters), this.failoverPolicies);
        return updateParameters;
    }

    private static String fixDBName(String name) {
        return name.toLowerCase();
    }

    private void setConsistencyPolicy(DefaultConsistencyLevel level, long maxStalenessPrefix, int maxIntervalInSeconds) {
        ConsistencyPolicy policy = new ConsistencyPolicy();
        policy.withDefaultConsistencyLevel(level);
        if (level == DefaultConsistencyLevel.BOUNDED_STALENESS) {
            policy.withMaxStalenessPrefix(maxStalenessPrefix);
            policy.withMaxIntervalInSeconds(maxIntervalInSeconds);
        }
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withConsistencyPolicy(policy);
    }

    private void addLocationsForParameters(HasLocations locationParameters, List<FailoverPolicy> failoverPolicies) {
        ArrayList<Location> locations = new ArrayList<Location>();
        if (failoverPolicies.size() > 0) {
            for (int i = 0; i < failoverPolicies.size(); ++i) {
                FailoverPolicy policyInner = failoverPolicies.get(i);
                Location location = new Location();
                location.withFailoverPriority(i);
                location.withLocationName(policyInner.locationName());
                locations.add(location);
            }
        } else {
            Location location = new Location();
            location.withFailoverPriority(0);
            location.withLocationName(locationParameters.location());
            locations.add(location);
        }
        locationParameters.withLocations(locations);
    }

    private Observable<CosmosDBAccount> updateFailoverPriorityAsync() {
        final CosmosDBAccountImpl self = this;
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().failoverPriorityChangeAsync(this.resourceGroupName(), this.name(), this.failoverPolicies).map((Func1)new Func1<Void, CosmosDBAccount>(){

            public CosmosDBAccount call(Void voidInner) {
                if (((DatabaseAccountGetResultsInner)((Object)self.inner())).failoverPolicies() != null) {
                    ((DatabaseAccountGetResultsInner)((Object)self.inner())).failoverPolicies().clear();
                    ((DatabaseAccountGetResultsInner)((Object)self.inner())).failoverPolicies().addAll(self.failoverPolicies);
                }
                self.failoverPolicies.clear();
                return self;
            }
        });
    }

    private Observable<CosmosDBAccount> doDatabaseUpdateCreate() {
        final CosmosDBAccountImpl self = this;
        final ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(0);
        Observable<DatabaseAccountGetResultsInner> request = null;
        HasLocations locationParameters = null;
        if (this.isInCreateMode()) {
            DatabaseAccountCreateUpdateParameters createUpdateParametersInner = this.createUpdateParametersInner((DatabaseAccountGetResultsInner)((Object)this.inner()));
            request = ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().createOrUpdateAsync(this.resourceGroupName(), this.name(), createUpdateParametersInner);
            locationParameters = new CreateUpdateLocationParameters(createUpdateParametersInner);
        } else {
            DatabaseAccountUpdateParameters updateParametersInner = this.updateParametersInner((DatabaseAccountGetResultsInner)((Object)this.inner()));
            request = ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().updateAsync(this.resourceGroupName(), this.name(), updateParametersInner);
            locationParameters = new UpdateLocationParameters(updateParametersInner);
        }
        final HasLocations finalLocationParameters = locationParameters;
        return request.flatMap((Func1)new Func1<DatabaseAccountGetResultsInner, Observable<? extends CosmosDBAccount>>(){

            public Observable<? extends CosmosDBAccount> call(DatabaseAccountGetResultsInner databaseAccountInner) {
                self.failoverPolicies.clear();
                self.hasFailoverPolicyChanges = false;
                return ((CosmosDBManager)CosmosDBAccountImpl.this.manager()).databaseAccounts().getByResourceGroupAsync(CosmosDBAccountImpl.this.resourceGroupName(), CosmosDBAccountImpl.this.name()).repeatWhen(new Func1<Observable<? extends Void>, Observable<?>>(){

                    public Observable<?> call(Observable<? extends Void> observable) {
                        data.set(0, (Integer)data.get(0) + 5);
                        return observable.delay(5L, TimeUnit.SECONDS);
                    }
                }).filter((Func1)new Func1<CosmosDBAccount, Boolean>(){

                    public Boolean call(CosmosDBAccount databaseAccount) {
                        if (600 > (Integer)data.get(0) && (databaseAccount.id() == null || databaseAccount.id().length() == 0 || finalLocationParameters.locations().size() > ((DatabaseAccountGetResultsInner)((Object)databaseAccount.inner())).failoverPolicies().size())) {
                            data.set(0, (Integer)data.get(0) + 5);
                            return false;
                        }
                        if (CosmosDBAccountImpl.this.isAFinalProvisioningState(((DatabaseAccountGetResultsInner)((Object)databaseAccount.inner())).provisioningState())) {
                            for (Location location : databaseAccount.readableReplications()) {
                                if (CosmosDBAccountImpl.this.isAFinalProvisioningState(location.provisioningState())) continue;
                                return false;
                            }
                        } else {
                            return false;
                        }
                        self.setInner(databaseAccount.inner());
                        return true;
                    }
                }).first();
            }
        });
    }

    private void ensureFailoverIsInitialized() {
        if (this.isInCreateMode()) {
            return;
        }
        if (!this.hasFailoverPolicyChanges) {
            this.failoverPolicies.clear();
            FailoverPolicy[] policyInners = new FailoverPolicy[((DatabaseAccountGetResultsInner)((Object)this.inner())).failoverPolicies().size()];
            ((DatabaseAccountGetResultsInner)((Object)this.inner())).failoverPolicies().toArray(policyInners);
            Arrays.sort(policyInners, new Comparator<FailoverPolicy>(){

                @Override
                public int compare(FailoverPolicy o1, FailoverPolicy o2) {
                    return o1.failoverPriority().compareTo(o2.failoverPriority());
                }
            });
            for (int i = 0; i < policyInners.length; ++i) {
                this.failoverPolicies.add(policyInners[i]);
            }
            this.hasFailoverPolicyChanges = true;
        }
    }

    private boolean isAFinalProvisioningState(String state) {
        switch (state.toLowerCase()) {
            case "succeeded": 
            case "canceled": 
            case "failed": {
                return true;
            }
        }
        return false;
    }

    private Map<String, VirtualNetworkRule> ensureVirtualNetworkRules() {
        if (this.virtualNetworkRulesMap == null) {
            this.virtualNetworkRulesMap = new HashMap<String, VirtualNetworkRule>();
            if (this.inner() != null && ((DatabaseAccountGetResultsInner)((Object)this.inner())).virtualNetworkRules() != null) {
                for (VirtualNetworkRule virtualNetworkRule : ((DatabaseAccountGetResultsInner)((Object)this.inner())).virtualNetworkRules()) {
                    this.virtualNetworkRulesMap.put(virtualNetworkRule.id(), virtualNetworkRule);
                }
            }
        }
        return this.virtualNetworkRulesMap;
    }

    @Override
    public CosmosDBAccountImpl withVirtualNetwork(String virtualNetworkId, String subnetName) {
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withIsVirtualNetworkFilterEnabled(true);
        String vnetId = virtualNetworkId + "/subnets/" + subnetName;
        this.ensureVirtualNetworkRules().put(vnetId, new VirtualNetworkRule().withId(vnetId));
        return this;
    }

    @Override
    public CosmosDBAccountImpl withoutVirtualNetwork(String virtualNetworkId, String subnetName) {
        Map<String, VirtualNetworkRule> vnetRules = this.ensureVirtualNetworkRules();
        vnetRules.remove(virtualNetworkId + "/subnets/" + subnetName);
        if (vnetRules.size() == 0) {
            ((DatabaseAccountGetResultsInner)((Object)this.inner())).withIsVirtualNetworkFilterEnabled(false);
        }
        return this;
    }

    @Override
    public CosmosDBAccountImpl withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        Map<String, VirtualNetworkRule> vnetRules = this.ensureVirtualNetworkRules();
        if (virtualNetworkRules == null || virtualNetworkRules.isEmpty()) {
            vnetRules.clear();
            ((DatabaseAccountGetResultsInner)((Object)this.inner())).withIsVirtualNetworkFilterEnabled(false);
            return this;
        }
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withIsVirtualNetworkFilterEnabled(true);
        for (VirtualNetworkRule vnetRule : virtualNetworkRules) {
            this.virtualNetworkRulesMap.put(vnetRule.id(), vnetRule);
        }
        return this;
    }

    @Override
    public CosmosDBAccountImpl withMultipleWriteLocationsEnabled(boolean enabled) {
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withEnableMultipleWriteLocations(enabled);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withCassandraConnector(ConnectorOffer connectorOffer) {
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withEnableCassandraConnector(true);
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withConnectorOffer(connectorOffer);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withoutCassandraConnector() {
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withEnableCassandraConnector(false);
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withConnectorOffer(null);
        return this;
    }

    @Override
    public CosmosDBAccountImpl withDisableKeyBaseMetadataWriteAccess(boolean disabled) {
        ((DatabaseAccountGetResultsInner)((Object)this.inner())).withDisableKeyBasedMetadataWriteAccess(disabled);
        return this;
    }

    class UpdateLocationParameters
    implements HasLocations {
        private DatabaseAccountUpdateParameters parameters;

        UpdateLocationParameters(DatabaseAccountUpdateParameters parametersObject) {
            this.parameters = parametersObject;
        }

        @Override
        public String location() {
            return this.parameters.location();
        }

        @Override
        public List<Location> locations() {
            return this.parameters.locations();
        }

        @Override
        public void withLocations(List<Location> locations) {
            this.parameters.withLocations(locations);
        }
    }

    class CreateUpdateLocationParameters
    implements HasLocations {
        private DatabaseAccountCreateUpdateParameters parameters;

        CreateUpdateLocationParameters(DatabaseAccountCreateUpdateParameters parametersObject) {
            this.parameters = parametersObject;
        }

        @Override
        public String location() {
            return this.parameters.location();
        }

        @Override
        public List<Location> locations() {
            return this.parameters.locations();
        }

        @Override
        public void withLocations(List<Location> locations) {
            this.parameters.withLocations(locations);
        }
    }

    static interface HasLocations {
        public String location();

        public List<Location> locations();

        public void withLocations(List<Location> var1);
    }
}

